/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.fluids;

import buildcraft.core.fluids.Tank;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class SingleUseTank
extends Tank {
    private Fluid acceptedFluid;

    public SingleUseTank(String name, int capacity) {
        super(name, capacity);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (doFill && this.acceptedFluid == null) {
            this.acceptedFluid = resource.getFluid();
        }
        if (this.acceptedFluid == null || this.acceptedFluid == resource.getFluid()) {
            return super.fill(resource, doFill);
        }
        return 0;
    }

    public void reset() {
        this.acceptedFluid = null;
    }

    public void setAcceptedFluid(Fluid fluid) {
        this.acceptedFluid = fluid;
    }

    public Fluid getAcceptedFluid() {
        return this.acceptedFluid;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        if (this.acceptedFluid != null) {
            nbt.func_74778_a("acceptedFluid", this.acceptedFluid.getName());
        }
        return nbt;
    }

    @Override
    public FluidTank readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.acceptedFluid = FluidRegistry.getFluid((String)nbt.func_74779_i("acceptedFluid"));
        return this;
    }
}

