/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.BuildCraftCore;
import buildcraft.api.blueprints.BlockSignature;
import buildcraft.api.blueprints.BlueprintManager;
import buildcraft.api.blueprints.BptBlock;
import buildcraft.api.blueprints.IBptContext;
import buildcraft.api.blueprints.ItemSignature;
import buildcraft.core.IBptContributor;
import buildcraft.core.blueprints.BptBase;
import buildcraft.core.blueprints.BptDataStream;
import buildcraft.core.blueprints.BptError;
import buildcraft.core.blueprints.BptSlot;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StringReader;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class BptBlueprint
extends BptBase {
    private int[] idMapping = new int[Item.field_77698_e.length];
    TreeSet idsToMap = new TreeSet();

    public BptBlueprint() {
        for (int i = 0; i < this.idMapping.length; ++i) {
            this.idMapping[i] = i;
        }
    }

    public BptBlueprint(int sizeX, int sizeY, int sizeZ) {
        super(sizeX, sizeY, sizeZ);
        for (int i = 0; i < this.idMapping.length; ++i) {
            this.idMapping[i] = i;
        }
    }

    public void readFromWorld(IBptContext context, TileEntity anchorTile, int x, int y, int z) {
        TileEntity tile;
        BptSlot slot = new BptSlot();
        slot.x = (int)((double)x - context.surroundingBox().pMin().x);
        slot.y = (int)((double)y - context.surroundingBox().pMin().y);
        slot.z = (int)((double)z - context.surroundingBox().pMin().z);
        slot.blockId = anchorTile.field_70331_k.func_72798_a(x, y, z);
        slot.meta = anchorTile.field_70331_k.func_72805_g(x, y, z);
        if (Block.field_71973_m[slot.blockId] instanceof BlockContainer && (tile = anchorTile.field_70331_k.func_72796_p(x, y, z)) != null && tile instanceof IBptContributor) {
            IBptContributor contributor = (IBptContributor)tile;
            contributor.saveToBluePrint(anchorTile, this, slot);
        }
        try {
            slot.initializeFromWorld(context, x, y, z);
            this.contents[slot.x][slot.y][slot.z] = slot;
        }
        catch (Throwable t) {
            t.printStackTrace();
            BuildCraftCore.bcLog.throwing("BptBlueprint", "readFromWorld", t);
        }
    }

    @Override
    public void saveAttributes(BufferedWriter writer) throws IOException {
        int x;
        BptSlot slot;
        int z;
        writer.write("sizeX:" + this.sizeX);
        writer.newLine();
        writer.write("sizeY:" + this.sizeY);
        writer.newLine();
        writer.write("sizeZ:" + this.sizeZ);
        writer.newLine();
        writer.write("anchorX:" + this.anchorX);
        writer.newLine();
        writer.write("anchorY:" + this.anchorY);
        writer.newLine();
        writer.write("anchorZ:" + this.anchorZ);
        writer.newLine();
        boolean[] idsUsed = new boolean[Item.field_77698_e.length];
        for (int i = 1; i < idsUsed.length; ++i) {
            idsUsed[i] = false;
        }
        for (int x2 = 0; x2 < this.sizeX; ++x2) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (z = 0; z < this.sizeZ; ++z) {
                    slot = this.contents[x2][y][z];
                    this.storeId(slot.blockId);
                    for (ItemStack stack : slot.storedRequirements) {
                        this.storeId(stack.field_77993_c);
                    }
                }
            }
        }
        writer.write("idMap:");
        writer.newLine();
        for (Integer id : this.idsToMap) {
            if (id < Block.field_71973_m.length && Block.field_71973_m[id] != null) {
                writer.write(BlueprintManager.getBlockSignature(Block.field_71973_m[id]) + "=" + id);
            } else {
                writer.write(BlueprintManager.getItemSignature(Item.field_77698_e[id]) + "=" + id);
            }
            writer.newLine();
        }
        writer.write(":idMap");
        writer.newLine();
        writer.write("contents:");
        writer.newLine();
        for (x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (z = 0; z < this.sizeZ; ++z) {
                    slot = this.contents[x][y][z];
                    if (slot != null && slot.blockId != 0) {
                        slot.cpt.func_74768_a("bId", slot.blockId);
                        if (slot.meta != 0) {
                            slot.cpt.func_74768_a("meta", slot.meta);
                        }
                        NBTBase.func_74731_a((NBTBase)slot.cpt, (DataOutput)new BptDataStream(writer));
                        writer.newLine();
                        continue;
                    }
                    writer.newLine();
                }
            }
        }
        writer.write(":contents");
        writer.newLine();
        writer.write("requirements:");
        writer.newLine();
        for (x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (z = 0; z < this.sizeZ; ++z) {
                    slot = this.contents[x][y][z];
                    if (slot != null && slot.blockId != 0 && slot.storedRequirements.size() > 0) {
                        NBTTagList list = new NBTTagList();
                        for (ItemStack stack : slot.storedRequirements) {
                            NBTTagCompound sub = new NBTTagCompound();
                            stack.func_77955_b(sub);
                            list.func_74742_a((NBTBase)sub);
                        }
                        NBTBase.func_74731_a((NBTBase)list, (DataOutput)new BptDataStream(writer));
                        writer.newLine();
                        continue;
                    }
                    writer.newLine();
                }
            }
        }
        writer.write(":requirements");
        writer.newLine();
    }

    @Override
    public void loadAttribute(BufferedReader reader, String attr, String val) throws IOException, BptError {
        block19: {
            block20: {
                block18: {
                    String mapStr;
                    if ("3.1.0".equals(this.version)) {
                        throw new BptError("Blueprint format 3.1.0 is not supported anymore, can't load " + this.file);
                    }
                    if (!attr.equals("blockMap") && !attr.equals("idMap")) break block18;
                    while ((mapStr = reader.readLine()) != null) {
                        if ((mapStr = mapStr.replaceAll("\n", "")).equals(":blockMap") || mapStr.equals(":idMap")) {
                            return;
                        }
                        String[] parts = mapStr.split("=");
                        int blockId = Integer.parseInt(parts[1]);
                        if (parts[0].startsWith("#I")) {
                            ItemSignature sig = new ItemSignature(parts[0]);
                            int itemId = Integer.parseInt(parts[1]);
                            if (this.itemMatch(sig, Item.field_77698_e[itemId])) continue;
                            boolean found = false;
                            for (int i = 256; i < Item.field_77698_e.length; ++i) {
                                if (i < Block.field_71973_m.length && Block.field_71973_m[i] != null || !this.itemMatch(sig, Item.field_77698_e[i])) continue;
                                found = true;
                                this.idMapping[itemId] = i;
                                break;
                            }
                            if (found) continue;
                            throw new BptError("BLUEPRINT ERROR: can't find item of signature " + sig + " for " + this.name);
                        }
                        BlockSignature bptSignature = new BlockSignature(parts[0]);
                        BptBlock defaultBlock = BlueprintManager.blockBptProps[0];
                        BptBlock handlingBlock = BlueprintManager.blockBptProps[blockId];
                        if (handlingBlock == null) {
                            handlingBlock = defaultBlock;
                        }
                        if (handlingBlock.match(Block.field_71973_m[blockId], bptSignature)) continue;
                        boolean found = false;
                        for (int i = 0; i < Block.field_71973_m.length; ++i) {
                            if (Block.field_71973_m[i] == null) continue;
                            handlingBlock = BlueprintManager.blockBptProps[i];
                            if (handlingBlock == null) {
                                handlingBlock = defaultBlock;
                            }
                            if (!handlingBlock.match(Block.field_71973_m[i], bptSignature)) continue;
                            this.idMapping[blockId] = i;
                            found = true;
                        }
                        if (found) continue;
                        throw new BptError("BLUEPRINT ERROR: can't find block of signature " + bptSignature + " for " + this.name);
                    }
                    break block19;
                }
                if (!attr.equals("contents")) break block20;
                this.contents = new BptSlot[this.sizeX][this.sizeY][this.sizeZ];
                for (int x = 0; x < this.sizeX; ++x) {
                    for (int y = 0; y < this.sizeY; ++y) {
                        for (int z = 0; z < this.sizeZ; ++z) {
                            String slotStr = reader.readLine().replaceAll("\n", "");
                            if (slotStr.equals(":contents")) {
                                return;
                            }
                            if (slotStr.equals("")) continue;
                            BptSlot slot = new BptSlot();
                            slot.x = x;
                            slot.y = y;
                            slot.z = z;
                            slot.cpt = (NBTTagCompound)NBTBase.func_74739_b((DataInput)new BptDataStream(new StringReader(slotStr)));
                            slot.blockId = this.mapWorldId(slot.cpt.func_74762_e("bId"));
                            if (slot.cpt.func_74764_b("meta")) {
                                slot.meta = slot.cpt.func_74762_e("meta");
                            }
                            this.contents[x][y][z] = slot;
                        }
                    }
                }
                break block19;
            }
            if (!attr.equals("requirements")) break block19;
            for (int x = 0; x < this.sizeX; ++x) {
                for (int y = 0; y < this.sizeY; ++y) {
                    for (int z = 0; z < this.sizeZ; ++z) {
                        String reqStr = reader.readLine().replaceAll("\n", "");
                        if (reqStr.equals(":requirements")) {
                            return;
                        }
                        if (reqStr.equals("")) continue;
                        NBTTagList list = (NBTTagList)NBTBase.func_74739_b((DataInput)new BptDataStream(new StringReader(reqStr)));
                        for (int i = 0; i < list.func_74745_c(); ++i) {
                            ItemStack stk = this.mapItemStack(ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)list.func_74743_b(i))));
                            this.contents[x][y][z].storedRequirements.add(stk);
                        }
                    }
                }
            }
        }
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return "Blueprint #" + this.position;
        }
        return this.name;
    }

    public ItemStack mapItemStack(ItemStack bptItemStack) {
        ItemStack newStack = bptItemStack.func_77946_l();
        newStack.field_77993_c = this.idMapping[newStack.field_77993_c];
        return newStack;
    }

    public int mapWorldId(int bptWorldId) {
        return this.idMapping[bptWorldId];
    }

    public void storeId(int worldId) {
        if (worldId != 0) {
            this.idsToMap.add(worldId);
        }
    }

    private boolean itemMatch(ItemSignature sig, Item item) {
        if (item == null) {
            return false;
        }
        if (!"*".equals(sig.itemClassName) && !item.getClass().getSimpleName().equals(sig.itemClassName)) {
            return false;
        }
        return "*".equals(sig.itemName) || item.func_77667_c(new ItemStack(item)).equals(sig.itemName);
    }

    @Override
    public void setBlockId(int x, int y, int z, int blockId) {
        super.setBlockId(x, y, z, blockId);
    }

    @Override
    protected void copyTo(BptBase bpt) {
        ((BptBlueprint)bpt).idMapping = (int[])this.idMapping.clone();
    }
}

