/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.LaserKind;
import buildcraft.api.filler.FillerManager;
import buildcraft.api.filler.IFillerPattern;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionReceptor;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.builders.TileMarker;
import buildcraft.core.Box;
import buildcraft.core.IMachine;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.network.TileNetworkData;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.triggers.ActionMachineControl;
import buildcraft.core.utils.Utils;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public class TileFiller
extends TileBuildCraft
implements ISidedInventory,
IPowerReceptor,
IMachine,
IActionReceptor {
    private static int[] SLOTS_GRID = Utils.createSlotArray(0, 9);
    private static int[] SLOTS_INPUT = Utils.createSlotArray(9, 27);
    @TileNetworkData
    public Box box = new Box();
    @TileNetworkData
    public int currentPatternId = 0;
    @TileNetworkData
    public boolean done = true;
    public IFillerPattern currentPattern;
    boolean forceDone = false;
    private ItemStack[] contents;
    private PowerHandler powerHandler;
    private ActionMachineControl.Mode lastMode = ActionMachineControl.Mode.Unknown;

    public TileFiller() {
        this.contents = new ItemStack[this.func_70302_i_()];
        this.powerHandler = new PowerHandler(this, PowerHandler.Type.MACHINE);
        this.initPowerProvider();
    }

    private void initPowerProvider() {
        this.powerHandler.configure(30.0f, 50.0f, 25.0f, 100.0f);
        this.powerHandler.configurePowerPerdition(1, 1);
    }

    @Override
    public void initialize() {
        IAreaProvider a;
        super.initialize();
        if (!CoreProxy.proxy.isRenderWorld(this.field_70331_k) && (a = Utils.getNearbyAreaProvider(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n)) != null) {
            this.box.initialize(a);
            if (a instanceof TileMarker) {
                ((TileMarker)a).removeFromWorld();
            }
            if (!CoreProxy.proxy.isRenderWorld(this.field_70331_k) && this.box.isInitialized()) {
                this.box.createLasers(this.field_70331_k, LaserKind.Stripes);
            }
            this.sendNetworkUpdate();
        }
        this.computeRecipe();
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this.done) {
            if (this.lastMode == ActionMachineControl.Mode.Loop) {
                this.done = false;
            } else {
                return;
            }
        }
        if (this.powerHandler.getEnergyStored() >= 25.0f) {
            this.doWork(this.powerHandler);
        }
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        if (CoreProxy.proxy.isRenderWorld(this.field_70331_k)) {
            return;
        }
        if (this.lastMode == ActionMachineControl.Mode.Off) {
            return;
        }
        if (this.powerHandler.useEnergy(25.0f, 25.0f, true) < 25.0f) {
            return;
        }
        if (this.box.isInitialized() && this.currentPattern != null && !this.done) {
            ItemStack stack = null;
            int stackId = 0;
            for (int s = 9; s < this.func_70302_i_(); ++s) {
                if (this.func_70301_a(s) == null || this.func_70301_a((int)s).field_77994_a <= 0) continue;
                stack = this.contents[s];
                stackId = s;
                break;
            }
            this.done = this.currentPattern.iteratePattern(this, this.box, stack);
            if (stack != null && stack.field_77994_a == 0) {
                this.contents[stackId] = null;
            }
            if (this.done) {
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                this.sendNetworkUpdate();
            }
        }
        if (this.powerHandler.getEnergyStored() >= 25.0f) {
            this.doWork(workProvider);
        }
    }

    public final int func_70302_i_() {
        return 36;
    }

    public ItemStack func_70301_a(int i) {
        return this.contents[i];
    }

    public void computeRecipe() {
        if (CoreProxy.proxy.isRenderWorld(this.field_70331_k)) {
            return;
        }
        IFillerPattern newPattern = FillerManager.registry.findMatchingRecipe((IInventory)this);
        if (newPattern == this.currentPattern) {
            return;
        }
        this.currentPattern = newPattern;
        if (this.currentPattern == null || this.forceDone) {
            this.done = this.lastMode != ActionMachineControl.Mode.Loop;
            this.forceDone = false;
        } else {
            this.done = false;
        }
        if (this.field_70331_k != null) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        this.currentPatternId = this.currentPattern == null ? 0 : this.currentPattern.getId();
        if (CoreProxy.proxy.isSimulating(this.field_70331_k)) {
            this.sendNetworkUpdate();
        }
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.contents[i] != null) {
            if (this.contents[i].field_77994_a <= j) {
                ItemStack itemstack = this.contents[i];
                this.contents[i] = null;
                this.computeRecipe();
                return itemstack;
            }
            ItemStack itemstack1 = this.contents[i].func_77979_a(j);
            if (this.contents[i].field_77994_a == 0) {
                this.contents[i] = null;
            }
            this.computeRecipe();
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.contents[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.computeRecipe();
    }

    public ItemStack func_70304_b(int slot) {
        if (this.contents[slot] == null) {
            return null;
        }
        ItemStack toReturn = this.contents[slot];
        this.contents[slot] = null;
        return toReturn;
    }

    public String func_70303_b() {
        return "Filler";
    }

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        Utils.readStacksFromNBT(nbttagcompound, "Items", this.contents);
        if (nbttagcompound.func_74764_b("box")) {
            this.box.initialize(nbttagcompound.func_74775_l("box"));
        }
        this.done = nbttagcompound.func_74767_n("done");
        this.lastMode = ActionMachineControl.Mode.values()[nbttagcompound.func_74771_c("lastMode")];
        this.forceDone = this.done;
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        Utils.writeStacksToNBT(nbttagcompound, "Items", this.contents);
        if (this.box != null) {
            NBTTagCompound boxStore = new NBTTagCompound();
            this.box.writeToNBT(boxStore);
            nbttagcompound.func_74782_a("box", (NBTBase)boxStore);
        }
        nbttagcompound.func_74757_a("done", this.done);
        nbttagcompound.func_74774_a("lastMode", (byte)this.lastMode.ordinal());
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        this.destroy();
    }

    @Override
    public void destroy() {
        if (this.box != null) {
            this.box.deleteLasers();
        }
    }

    @Override
    public void handleDescriptionPacket(PacketUpdate packet) throws IOException {
        boolean initialized = this.box.isInitialized();
        super.handleDescriptionPacket(packet);
        this.currentPattern = FillerManager.registry.getPattern(this.currentPatternId);
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (!initialized && this.box.isInitialized()) {
            this.box.createLasers(this.field_70331_k, LaserKind.Stripes);
        }
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) throws IOException {
        boolean initialized = this.box.isInitialized();
        super.handleUpdatePacket(packet);
        this.currentPattern = FillerManager.registry.getPattern(this.currentPatternId);
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (!initialized && this.box.isInitialized()) {
            this.box.createLasers(this.field_70331_k, LaserKind.Stripes);
        }
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public boolean isActive() {
        return !this.done && this.lastMode != ActionMachineControl.Mode.Off;
    }

    @Override
    public boolean manageFluids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void actionActivated(IAction action) {
        if (action == BuildCraftCore.actionOn) {
            this.lastMode = ActionMachineControl.Mode.On;
        } else if (action == BuildCraftCore.actionOff) {
            this.lastMode = ActionMachineControl.Mode.Off;
        } else if (action == BuildCraftCore.actionLoop) {
            this.lastMode = ActionMachineControl.Mode.Loop;
        }
    }

    @Override
    public boolean allowAction(IAction action) {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot < 9) {
            if (this.func_70301_a(slot) != null) {
                return false;
            }
            return stack.field_77993_c == Block.field_72081_al.field_71990_ca || stack.field_77993_c == Block.field_71946_M.field_71990_ca;
        }
        return true;
    }

    public int[] func_94128_d(int side) {
        if (ForgeDirection.UP.ordinal() == side) {
            return SLOTS_GRID;
        }
        return SLOTS_INPUT;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return true;
    }
}

