/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.api.fuels.IronEngineCoolant;
import buildcraft.api.fuels.IronEngineFuel;
import buildcraft.api.recipes.RefineryRecipes;
import buildcraft.core.BlockSpring;
import buildcraft.core.DefaultProps;
import buildcraft.core.network.PacketHandler;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.energy.BlockBuildcraftFluid;
import buildcraft.energy.BlockEngine;
import buildcraft.energy.BptBlockEngine;
import buildcraft.energy.BucketHandler;
import buildcraft.energy.EnergyProxy;
import buildcraft.energy.GuiHandler;
import buildcraft.energy.ItemBucketBuildcraft;
import buildcraft.energy.ItemEngine;
import buildcraft.energy.TileEngine;
import buildcraft.energy.TriggerEngineHeat;
import buildcraft.energy.worldgen.BiomeGenOilDesert;
import buildcraft.energy.worldgen.BiomeGenOilOcean;
import buildcraft.energy.worldgen.BiomeInitializer;
import buildcraft.energy.worldgen.OilPopulate;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

@Mod(name="BuildCraft Energy", version="4.0.2", useMetadata=false, modid="BuildCraft|Energy", dependencies="required-after:BuildCraft|Core@4.0.2")
@NetworkMod(channels={"BC"}, packetHandler=PacketHandler.class, clientSideRequired=true, serverSideRequired=true)
public class BuildCraftEnergy {
    public static final int ENERGY_REMOVE_BLOCK = 25;
    public static final int ENERGY_EXTRACT_ITEM = 2;
    public static boolean spawnOilSprings = true;
    public static BiomeGenOilDesert biomeOilDesert;
    public static BiomeGenOilOcean biomeOilOcean;
    public static BlockEngine engineBlock;
    private static Fluid buildcraftFluidOil;
    private static Fluid buildcraftFluidFuel;
    public static Fluid fluidOil;
    public static Fluid fluidFuel;
    public static Block blockOil;
    public static Block blockFuel;
    public static Item bucketOil;
    public static Item bucketFuel;
    public static Item fuel;
    public static boolean canOilBurn;
    public static TreeMap saturationStored;
    public static BCTrigger triggerBlueEngineHeat;
    public static BCTrigger triggerGreenEngineHeat;
    public static BCTrigger triggerYellowEngineHeat;
    public static BCTrigger triggerRedEngineHeat;
    @Mod.Instance(value="BuildCraft|Energy")
    public static BuildCraftEnergy instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        class BiomeIdException
        extends RuntimeException {
            public BiomeIdException(String biome, int id) {
                super(String.format("You have a Biome Id conflict at %d for %s", id, biome));
            }
        }
        Property engineId = BuildCraftCore.mainConfiguration.getBlock("engine.id", DefaultProps.ENGINE_ID);
        int defaultOilId = DefaultProps.OIL_ID;
        if (BuildCraftCore.mainConfiguration.hasKey("block", "oilStill.id")) {
            defaultOilId = BuildCraftCore.mainConfiguration.get("block", "oilStill.id", defaultOilId).getInt(defaultOilId);
            BuildCraftCore.mainConfiguration.getCategory("block").remove((Object)"oilStill.id");
        }
        int blockOilId = BuildCraftCore.mainConfiguration.getBlock("oil.id", defaultOilId).getInt(defaultOilId);
        int blockFuelId = BuildCraftCore.mainConfiguration.getBlock("fuel.id", DefaultProps.FUEL_ID).getInt(DefaultProps.FUEL_ID);
        int bucketOilId = BuildCraftCore.mainConfiguration.getItem("bucketOil.id", DefaultProps.BUCKET_OIL_ID).getInt(DefaultProps.BUCKET_OIL_ID);
        int bucketFuelId = BuildCraftCore.mainConfiguration.getItem("bucketFuel.id", DefaultProps.BUCKET_FUEL_ID).getInt(DefaultProps.BUCKET_FUEL_ID);
        int oilDesertBiomeId = BuildCraftCore.mainConfiguration.get("biomes", "oilDesert", DefaultProps.BIOME_OIL_DESERT).getInt(DefaultProps.BIOME_OIL_DESERT);
        int oilOceanBiomeId = BuildCraftCore.mainConfiguration.get("biomes", "oilOcean", DefaultProps.BIOME_OIL_OCEAN).getInt(DefaultProps.BIOME_OIL_OCEAN);
        canOilBurn = BuildCraftCore.mainConfiguration.get("general", "burnOil", true, "Can oil burn?").getBoolean(true);
        BuildCraftCore.mainConfiguration.save();
        if (oilDesertBiomeId > 0) {
            if (BiomeGenBase.field_76773_a[oilDesertBiomeId] != null) {
                throw new BiomeIdException("oilDesert", oilDesertBiomeId);
            }
            biomeOilDesert = BiomeGenOilDesert.makeBiome(oilDesertBiomeId);
        }
        if (oilOceanBiomeId > 0) {
            if (BiomeGenBase.field_76773_a[oilOceanBiomeId] != null) {
                throw new BiomeIdException("oilOcean", oilOceanBiomeId);
            }
            biomeOilOcean = BiomeGenOilOcean.makeBiome(oilOceanBiomeId);
        }
        engineBlock = new BlockEngine(engineId.getInt(DefaultProps.ENGINE_ID));
        CoreProxy.proxy.registerBlock((Block)engineBlock, ItemEngine.class);
        LanguageRegistry.addName((Object)new ItemStack((Block)engineBlock, 1, 0), (String)"Redstone Engine");
        LanguageRegistry.addName((Object)new ItemStack((Block)engineBlock, 1, 1), (String)"Steam Engine");
        LanguageRegistry.addName((Object)new ItemStack((Block)engineBlock, 1, 2), (String)"Combustion Engine");
        buildcraftFluidOil = new Fluid("oil").setDensity(800).setViscosity(1500);
        FluidRegistry.registerFluid((Fluid)buildcraftFluidOil);
        fluidOil = FluidRegistry.getFluid((String)"oil");
        buildcraftFluidFuel = new Fluid("fuel");
        FluidRegistry.registerFluid((Fluid)buildcraftFluidFuel);
        fluidFuel = FluidRegistry.getFluid((String)"fuel");
        if (fluidOil.getBlockID() == -1) {
            if (blockOilId > 0) {
                blockOil = new BlockBuildcraftFluid(blockOilId, fluidOil, Material.field_76244_g).setFlammable(canOilBurn).setFlammability(0);
                blockOil.func_71864_b("blockOil");
                CoreProxy.proxy.addName(blockOil, "Oil");
                CoreProxy.proxy.registerBlock(blockOil);
                fluidOil.setBlockID(blockOil);
            }
        } else {
            blockOil = Block.field_71973_m[fluidOil.getBlockID()];
        }
        if (blockOil != null) {
            Property oilSpringsProp = BuildCraftCore.mainConfiguration.get("general", "oilSprings", true);
            BlockSpring.EnumSpring.OIL.canGen = spawnOilSprings = oilSpringsProp.getBoolean(true);
            BlockSpring.EnumSpring.OIL.liquidBlock = blockOil;
        }
        if (fluidFuel.getBlockID() == -1) {
            if (blockFuelId > 0) {
                blockFuel = new BlockBuildcraftFluid(blockFuelId, fluidFuel, Material.field_76244_g).setFlammable(true).setFlammability(5).setParticleColor(0.7f, 0.7f, 0.0f);
                blockFuel.func_71864_b("blockFuel");
                CoreProxy.proxy.addName(blockFuel, "Fuel");
                CoreProxy.proxy.registerBlock(blockFuel);
                fluidFuel.setBlockID(blockFuel);
            }
        } else {
            blockFuel = Block.field_71973_m[fluidFuel.getBlockID()];
        }
        if (blockOil != null && bucketOilId > 0) {
            bucketOil = new ItemBucketBuildcraft(bucketOilId, BuildCraftEnergy.blockOil.field_71990_ca);
            bucketOil.func_77655_b("bucketOil").func_77642_a(Item.field_77788_aw);
            LanguageRegistry.addName((Object)bucketOil, (String)"Oil Bucket");
            FluidContainerRegistry.registerFluidContainer((FluidStack)FluidRegistry.getFluidStack((String)"oil", (int)1000), (ItemStack)new ItemStack(bucketOil), (ItemStack)new ItemStack(Item.field_77788_aw));
        }
        if (blockFuel != null && bucketFuelId > 0) {
            bucketFuel = new ItemBucketBuildcraft(bucketFuelId, BuildCraftEnergy.blockFuel.field_71990_ca);
            bucketFuel.func_77655_b("bucketFuel").func_77642_a(Item.field_77788_aw);
            LanguageRegistry.addName((Object)bucketFuel, (String)"Fuel Bucket");
            FluidContainerRegistry.registerFluidContainer((FluidStack)FluidRegistry.getFluidStack((String)"fuel", (int)1000), (ItemStack)new ItemStack(bucketFuel), (ItemStack)new ItemStack(Item.field_77788_aw));
        }
        BucketHandler.INSTANCE.buckets.put(blockOil, bucketOil);
        BucketHandler.INSTANCE.buckets.put(blockFuel, bucketFuel);
        MinecraftForge.EVENT_BUS.register((Object)BucketHandler.INSTANCE);
        RefineryRecipes.addRecipe(new FluidStack(fluidOil, 1), new FluidStack(fluidFuel, 1), 12, 1);
        IronEngineFuel.addFuel("lava", 1.0f, 20000);
        IronEngineFuel.addFuel("oil", 3.0f, 20000);
        IronEngineFuel.addFuel("fuel", 6.0f, 100000);
        IronEngineCoolant.addCoolant(FluidRegistry.getFluid((String)"water"), 0.0023f);
        IronEngineCoolant.addCoolant(Block.field_72036_aT.field_71990_ca, 0, FluidRegistry.getFluidStack((String)"water", (int)2000));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        new BptBlockEngine(BuildCraftEnergy.engineBlock.field_71990_ca);
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftEnergy.loadRecipes();
        }
        EnergyProxy.proxy.registerBlockRenderers();
        EnergyProxy.proxy.registerTileEntities();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        if (BuildCraftCore.modifyWorld) {
            MinecraftForge.EVENT_BUS.register((Object)OilPopulate.INSTANCE);
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)new BiomeInitializer());
        }
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Post event) {
        if (event.map.field_94255_a == 0) {
            buildcraftFluidOil.setIcons(blockOil.func_71851_a(1), blockOil.func_71851_a(2));
            buildcraftFluidFuel.setIcons(blockFuel.func_71851_a(1), blockFuel.func_71851_a(2));
        }
    }

    public static void loadRecipes() {
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)engineBlock, 1, 0), "www", " g ", "GpG", Character.valueOf('w'), "plankWood", Character.valueOf('g'), Block.field_71946_M, Character.valueOf('G'), BuildCraftCore.woodenGearItem, Character.valueOf('p'), Block.field_71963_Z);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)engineBlock, 1, 1), "www", " g ", "GpG", Character.valueOf('w'), Block.field_71978_w, Character.valueOf('g'), Block.field_71946_M, Character.valueOf('G'), BuildCraftCore.stoneGearItem, Character.valueOf('p'), Block.field_71963_Z);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)engineBlock, 1, 2), "www", " g ", "GpG", Character.valueOf('w'), Item.field_77703_o, Character.valueOf('g'), Block.field_71946_M, Character.valueOf('G'), BuildCraftCore.ironGearItem, Character.valueOf('p'), Block.field_71963_Z);
    }

    @Mod.IMCCallback
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage m : event.getMessages()) {
            int id;
            String biomeID;
            if (m.key.equals("oil-lake-biome")) {
                try {
                    biomeID = m.getStringValue().trim();
                    id = Integer.valueOf(biomeID);
                    if (id >= BiomeGenBase.field_76773_a.length) {
                        throw new IllegalArgumentException("Biome ID must be less than " + BiomeGenBase.field_76773_a.length);
                    }
                    OilPopulate.INSTANCE.surfaceDepositBiomes.add(id);
                }
                catch (Exception ex) {
                    Logger.getLogger("Buildcraft").log(Level.WARNING, String.format("Received an invalid oil-lake-biome request %s from mod %s", m.getStringValue(), m.getSender()));
                }
                Logger.getLogger("Buildcraft").log(Level.INFO, String.format("Received an successfull oil-lake-biome request %s from mod %s", m.getStringValue(), m.getSender()));
                continue;
            }
            if (!m.key.equals("oil-gen-exclude")) continue;
            try {
                biomeID = m.getStringValue().trim();
                id = Integer.valueOf(biomeID);
                if (id >= BiomeGenBase.field_76773_a.length) {
                    throw new IllegalArgumentException("Biome ID must be less than " + BiomeGenBase.field_76773_a.length);
                }
                OilPopulate.INSTANCE.excludedBiomes.add(id);
            }
            catch (Exception ex) {
                Logger.getLogger("Buildcraft").log(Level.WARNING, String.format("Received an invalid oil-gen-exclude request %s from mod %s", m.getStringValue(), m.getSender()));
            }
            Logger.getLogger("Buildcraft").log(Level.INFO, String.format("Received an successfull oil-gen-exclude request %s from mod %s", m.getStringValue(), m.getSender()));
        }
    }

    static {
        saturationStored = new TreeMap();
        triggerBlueEngineHeat = new TriggerEngineHeat(DefaultProps.TRIGGER_BLUE_ENGINE_HEAT, TileEngine.EnergyStage.BLUE, "buildcraft.engine.stage.blue");
        triggerGreenEngineHeat = new TriggerEngineHeat(DefaultProps.TRIGGER_GREEN_ENGINE_HEAT, TileEngine.EnergyStage.GREEN, "buildcraft.engine.stage.green");
        triggerYellowEngineHeat = new TriggerEngineHeat(DefaultProps.TRIGGER_YELLOW_ENGINE_HEAT, TileEngine.EnergyStage.YELLOW, "buildcraft.engine.stage.yellow");
        triggerRedEngineHeat = new TriggerEngineHeat(DefaultProps.TRIGGER_RED_ENGINE_HEAT, TileEngine.EnergyStage.RED, "buildcraft.engine.stage.red");
    }
}

