/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines;

import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.core.machines.power.ComponentProcess;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.craftgui.minecraft.IMachineInformation;
import binnie.extratrees.core.ExtraTreeTexture;
import binnie.extratrees.core.ExtraTreesGUID;
import binnie.extratrees.machines.ExtraTreeMachine;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

public class FruitPress {
    public static int slotFruit = 0;
    public static int slotCurrent = 1;
    public static int tankWater = 0;
    private static Map<ItemStack, FluidStack> pressRecipes = new HashMap<ItemStack, FluidStack>();

    public static boolean isInput(ItemStack itemstack) {
        return FruitPress.getOutput(itemstack) != null;
    }

    public static FluidStack getOutput(ItemStack itemstack) {
        if (itemstack == null) {
            return null;
        }
        for (Map.Entry<ItemStack, FluidStack> entry : pressRecipes.entrySet()) {
            if (!itemstack.func_77969_a(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void addRecipe(ItemStack stack, FluidStack fluid) {
        pressRecipes.put(stack, fluid);
    }

    public static class SlotValidatorSqueezable
    extends SlotValidator {
        public SlotValidatorSqueezable() {
            super(SlotValidator.IconBlock);
        }

        @Override
        public boolean isValid(ItemStack itemStack) {
            return FruitPress.isInput(itemStack);
        }

        @Override
        public String getTooltip() {
            return "Fruit";
        }
    }

    public static class ComponentFruitPressLogic
    extends ComponentProcess
    implements IProcess {
        int lastProgress = 0;

        public ComponentFruitPressLogic(Machine machine) {
            super(machine, 250, 50);
        }

        @Override
        public ErrorState canWork() {
            if (this.getUtil().isSlotEmpty(slotCurrent)) {
                return new ErrorState.NoItem("No Fruit", slotCurrent);
            }
            return super.canWork();
        }

        @Override
        public ErrorState canProgress() {
            if (!this.getUtil().spaceInTank(tankWater, 5)) {
                return new ErrorState.InsufficientLiquid("No room in tank", tankWater);
            }
            return super.canProgress();
        }

        @Override
        protected void onFinishTask() {
            this.getUtil().decreaseStack(slotCurrent, 1);
        }

        @Override
        protected void onTickTask() {
        }

        @Override
        public void onUpdate() {
            super.onUpdate();
            FluidStack output = FruitPress.getOutput(this.getUtil().getStack(slotCurrent));
            if (output == null) {
                return;
            }
            int newProgress = (int)this.getProgress();
            while (this.lastProgress + 4 <= newProgress) {
                int change = newProgress - this.lastProgress;
                int amount = output.amount * change / 25;
                FluidStack tank = new FluidStack(output, amount);
                this.getUtil().fillTank(tankWater, tank);
                this.lastProgress += 4;
            }
            if (this.lastProgress > newProgress) {
                this.lastProgress = 0;
            }
        }
    }

    public static class PackageFruitPress
    extends ExtraTreeMachine.PackageExtraTreeMachine
    implements IMachineInformation {
        public PackageFruitPress() {
            super("fruitPress", "Fruit Press", ExtraTreeTexture.pressTexture);
        }

        @Override
        public void createMachine(Machine machine) {
            new ExtraTreeMachine.ComponentExtraTreeGUI(machine, ExtraTreesGUID.FruitPress);
            ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
            inventory.addSlot(slotFruit, InventorySlot.NameInput);
            inventory.getSlot(slotFruit).setValidator(new SlotValidatorSqueezable());
            inventory.getSlot(slotFruit).forbidExtraction();
            inventory.addSlot(slotCurrent, InventorySlot.NameProcess);
            inventory.getSlot(slotCurrent).setValidator(new SlotValidatorSqueezable());
            inventory.getSlot(slotCurrent).forbidInteraction();
            ComponentTankContainer tanks = new ComponentTankContainer(machine);
            tanks.addTank(tankWater, "Juice Tank", 10000);
            new ComponentPowerReceptor(machine);
            new ComponentInventoryTransfer(machine).addRestock(new int[]{slotFruit}, slotCurrent, 1);
            new ComponentFruitPressLogic(machine);
        }

        @Override
        public TileEntity createTileEntity() {
            return new TileEntityMachine(this);
        }

        @Override
        public void register() {
        }

        @Override
        public String getInformation() {
            return "The Lumbermill converts logs into planks at an increased rate, as well as giving byproducts such as sawdust and bark.";
        }
    }
}

