/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.genetics;

import binnie.core.genetics.BinnieGenetics;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.block.ILogType;
import binnie.extratrees.gen.WorldGenAlder;
import binnie.extratrees.gen.WorldGenApple;
import binnie.extratrees.gen.WorldGenAsh;
import binnie.extratrees.gen.WorldGenBanana;
import binnie.extratrees.gen.WorldGenBeech;
import binnie.extratrees.gen.WorldGenConifer;
import binnie.extratrees.gen.WorldGenDefault;
import binnie.extratrees.gen.WorldGenEucalyptus;
import binnie.extratrees.gen.WorldGenFir;
import binnie.extratrees.gen.WorldGenHolly;
import binnie.extratrees.gen.WorldGenJungle;
import binnie.extratrees.gen.WorldGenMaple;
import binnie.extratrees.gen.WorldGenPoplar;
import binnie.extratrees.gen.WorldGenShrub;
import binnie.extratrees.gen.WorldGenSorbus;
import binnie.extratrees.gen.WorldGenTree;
import binnie.extratrees.gen.WorldGenTree2;
import binnie.extratrees.gen.WorldGenTree3;
import binnie.extratrees.gen.WorldGenWalnut;
import binnie.extratrees.genetics.ExtraTreeFruitGene;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IIconProvider;
import forestry.api.core.ItemInterface;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.EnumPlantType;

public enum ExtraTreeSpecies implements IAlleleTreeSpecies,
IIconProvider
{
    OrchardApple("Orchard Apple", "malus", "domestica", 6588464, 16751859, ILogType.ExtraTreeLog.Apple, ExtraTreeFruitGene.Apple, WorldGenApple.OrchardApple.class),
    SweetCrabapple("Sweet Crabapple", "malus", "coronaria", 8034643, 16528799, ILogType.ExtraTreeLog.Apple, ExtraTreeFruitGene.Crabapple, WorldGenApple.SweetCrabapple.class),
    FloweringCrabapple("Flowering Crabapple", "malus", "hopa", 8034643, 16528799, ILogType.ExtraTreeLog.Apple, ExtraTreeFruitGene.Crabapple, WorldGenApple.FloweringCrabapple.class),
    PrairieCrabapple("Prairie Crabapple", "malus", "ioensis", 8034643, 16528799, ILogType.ExtraTreeLog.Apple, ExtraTreeFruitGene.Crabapple, WorldGenApple.PrairieCrabapple.class),
    Blackthorn("Blackthorn", "prunus", "spinosa ", 7180062, 16746439, ILogType.ForestryLog.PLUM, ExtraTreeFruitGene.Blackthorn, null),
    CherryPlum("Cherry Plum", "prunus", "cerasifera", 7180062, 16746439, ILogType.ForestryLog.PLUM, ExtraTreeFruitGene.CherryPlum, null),
    Peach("Peach", "prunus", "persica", 7180062, 16721562, ILogType.ForestryLog.PLUM, ExtraTreeFruitGene.Peach, null),
    Nectarine("Nectarine", "prunus", "nectarina", 7180062, 16721562, ILogType.ForestryLog.PLUM, ExtraTreeFruitGene.Nectarine, null),
    Apricot("Apricot", "prunus", "armeniaca", 7180062, 16103640, ILogType.ForestryLog.PLUM, ExtraTreeFruitGene.Apricot, null),
    Almond("Almond", "prunus", "amygdalus", 7180062, 16090304, ILogType.ForestryLog.PLUM, ExtraTreeFruitGene.Almond, null),
    WildCherry("Wild Cherry", "prunus", "avium", 7180062, 16247798, ILogType.ExtraTreeLog.Cherry, ExtraTreeFruitGene.WildCherry, null),
    SourCherry("Sour Cherry", "prunus", "cerasus", 7180062, 16247798, ILogType.ExtraTreeLog.Cherry, ExtraTreeFruitGene.SourCherry, null),
    BlackCherry("Black Cherry", "prunus", "serotina", 7180062, 16441848, ILogType.ExtraTreeLog.Cherry, ExtraTreeFruitGene.BlackCherry, null),
    Orange("Orange", "citrus", "sinensis", 8957780, 10729552, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.Orange, null),
    Manderin("Manderine", "citrus", "reticulata", 8957780, 10729552, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.Manderin, null),
    Satsuma("Satsuma", "citrus", "unshiu", 8957780, 10729552, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.Satsuma, null),
    Tangerine("Tangerine", "citrus", "tangerina", 8957780, 10729552, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.Tangerine, null),
    Lime("Lime", "citrus", "latifolia", 8957780, 10729552, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.Lime, null),
    KeyLime("Key Lime", "citrus", "aurantifolia", 8957780, 10729552, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.KeyLime, null),
    FingerLime("Finger Lime", "citrus", "australasica", 8957780, 10729552, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.FingerLime, null),
    Pomelo("Pomelo", "citrus", "maxima", 8957780, 10729552, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.Pomelo, null),
    Grapefruit("Grapefruit", "citrus", "paradisi", 8957780, 10729552, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.Grapefruit, null),
    Kumquat("Kumquat", "citrus", "margarita", 8957780, 10729552, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.Kumquat, null),
    Citron("Citron", "citrus", "medica", 8957780, 10729552, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.Citron, null),
    BuddhaHand("Buddha's Hand", "citrus", "sarcodactylus", 8957780, 10729552, ILogType.ForestryLog.CITRUS, ExtraTreeFruitGene.BuddhaHand, null),
    Banana("Banana", "musa", "sinensis", 10603918, 4515072, ILogType.ExtraTreeLog.Banana, ExtraTreeFruitGene.Banana, WorldGenBanana.class),
    RedBanana("Red Banana", "musa", "rubra", 10603918, 4515072, ILogType.ExtraTreeLog.Banana, ExtraTreeFruitGene.RedBanana, WorldGenBanana.class),
    Plantain("Plantain", "musa", "paradisiaca", 10603918, 4515072, ILogType.ExtraTreeLog.Banana, ExtraTreeFruitGene.Plantain, WorldGenBanana.class),
    Butternut("Butternut", "juglans", "cinerea", 8566156, 8576396, ILogType.ExtraTreeLog.Butternut, ExtraTreeFruitGene.Butternut, WorldGenWalnut.Butternut.class),
    Rowan("Common Rowan", "sorbus", "aucuparia", 10405787, 10414258, ILogType.ExtraTreeLog.Rowan, null, WorldGenSorbus.Rowan.class),
    Hemlock("Western Hemlock", "tsuga", "heterophylla", 6073458, 6082930, ILogType.ExtraTreeLog.Hemlock, null, WorldGenConifer.WesternHemlock.class),
    Ash("Common Ash", "fraxinus", "excelsior", 4754987, 4777003, ILogType.ExtraTreeLog.Ash, null, WorldGenAsh.CommonAsh.class),
    Alder("Common Alder", "alnus", "glutinosa", 6916659, 6925875, ILogType.ExtraTreeLog.Alder, null, WorldGenAlder.CommonAlder.class),
    Beech("Common Beech", "fagus", "sylvatica", 8626252, 8635980, ILogType.ExtraTreeLog.Beech, ExtraTreeFruitGene.Beechnut, WorldGenBeech.CommonBeech.class),
    CopperBeech("Copper Beech", "fagus", "purpurea", 8393496, 13720397, ILogType.ExtraTreeLog.Beech, ExtraTreeFruitGene.Beechnut, WorldGenBeech.CopperBeech.class),
    Aspen("Aspen", "populus", "tremula", 9096247, 9101711, ILogType.ForestryLog.POPLAR, null, WorldGenPoplar.Aspen.class),
    Yew("Common Yew", "taxus", "baccata", 9734733, 9743949, ILogType.ExtraTreeLog.Yew, null, WorldGenConifer.Yew.class),
    Cypress("Lawson Cypress", "chamaecyparis", "lawsoniana", 9030055, 9035206, ILogType.ExtraTreeLog.Cypress, null, WorldGenConifer.Cypress.class),
    DouglasFir("Douglas-fir", "pseudotsuga", "menziesii", 10073474, 10080682, ILogType.ExtraTreeLog.Fir, null, WorldGenFir.DouglasFir.class),
    Hazel("Common Hazel", "Corylus", "avellana", 10204498, 10215762, ILogType.ExtraTreeLog.Hazel, ExtraTreeFruitGene.Hazelnut, WorldGenTree3.Hazel.class),
    Sycamore("Sycamore Fig", "ficus", "sycomorus", 10528047, 11851100, ILogType.ExtraTreeLog.Fig, ExtraTreeFruitGene.Fig, WorldGenTree3.Sycamore.class),
    Whitebeam("Whitebeam", "sorbus", "aria", 12242585, 7505471, ILogType.ExtraTreeLog.Whitebeam, null, WorldGenSorbus.Whitebeam.class),
    Hawthorn("Common Hawthorn", "crataegus", "monogyna", 7055434, 10008443, ILogType.ExtraTreeLog.Hawthorn, null, WorldGenTree3.Hawthorn.class),
    Pecan("Pecan", "carya", "illinoinensis", 8762996, 2906139, ILogType.ExtraTreeLog.Hickory, ExtraTreeFruitGene.Pecan, WorldGenTree3.Pecan.class),
    Elm("Common Elm", "ulmus", "procera", 8163400, 8175176, ILogType.ExtraTreeLog.Elm, null, WorldGenTree3.Elm.class),
    Elder("Elderberry", "sambucus", "nigra", 11450483, 14739389, ILogType.ExtraTreeLog.Elder, ExtraTreeFruitGene.Elderberry, WorldGenTree3.Elder.class),
    Holly("Common Holly", "ilex", "aquifolium", 2444108, 7246468, ILogType.ExtraTreeLog.Holly, null, WorldGenHolly.Holly.class),
    Hornbeam("Common Hornbeam", "carpinus", "betulus", 9873179, 9887003, ILogType.ExtraTreeLog.Hornbeam, null, WorldGenTree3.Hornbeam.class),
    Sallow("Great Sallow", "salix", "caprea", 11449123, 12053541, ILogType.ForestryLog.WILLOW, null, WorldGenTree3.Sallow.class),
    AcornOak("Acorn Oak", "quercus", "robur", 6714174, 10396209, ILogType.VanillaLog.Oak, ExtraTreeFruitGene.Acorn, WorldGenTree3.AcornOak.class),
    Fir("Silver Fir", "abies", "alba", 7306272, 7328032, ILogType.ExtraTreeLog.Fir, null, WorldGenFir.SilverFir.class),
    Cedar("Great Cedar", "cedrus", "libani", 9806704, 9824368, ILogType.ExtraTreeLog.Cedar, null, WorldGenConifer.Cedar.class),
    Olive("Olive", "olea", "europaea", 3950644, 3950644, ILogType.ExtraTreeLog.Olive, ExtraTreeFruitGene.Olive, WorldGenTree2.Olive.class),
    RedMaple("Red Maple", "acer", "ubrum", 15216151, 15216151, ILogType.ForestryLog.MAPLE, null, WorldGenMaple.RedMaple.class),
    BalsamFir("Balsam Fir", "abies", "balsamea", 7643260, 7643260, ILogType.ExtraTreeLog.Fir, null, WorldGenFir.BalsamFir.class),
    LoblollyPine("Loblolly Pine", "pinus", "taeda", 7309895, 7309895, ILogType.ForestryLog.PINE, null, WorldGenConifer.LoblollyPine.class),
    Sweetgum("Sweetgum", "liquidambar", "styraciflua", 9144162, 9144162, ILogType.ExtraTreeLog.Sweetgum, null, WorldGenTree2.Sweetgum.class),
    Locust("Black Locust", "robinia", "pseudoacacia", 8942336, 8942336, ILogType.ExtraTreeLog.Locust, null, WorldGenTree2.Locust.class),
    Pear("Cultivated Pear", "pyrus", "communis", 6195238, 6195238, ILogType.ExtraTreeLog.Pear, ExtraTreeFruitGene.Pear, WorldGenTree2.Pear.class),
    OsangeOsange("Osange-Orange", "maclura", "pomifera", 6847056, 6847056, ILogType.ExtraTreeLog.Maclura, ExtraTreeFruitGene.OsangeOsange, WorldGenJungle.OsangeOsange.class),
    OldFustic("Old Fustic", "maclura", "tinctoria", 6847056, 6847056, ILogType.ExtraTreeLog.Maclura, null, WorldGenJungle.OldFustic.class),
    Brazilwood("Brazilwood", "caesalpinia", "echinata", 6321241, 6321241, ILogType.ExtraTreeLog.Brazilwood, null, WorldGenJungle.Brazilwood.class),
    Logwood("Logwood", "haematoxylum", "campechianum", 8953707, 8953707, ILogType.ExtraTreeLog.Logwood, null, WorldGenJungle.Logwood.class),
    Rosewood("Rosewood", "dalbergia", "latifolia", 8887074, 8887074, ILogType.ExtraTreeLog.Rosewood, null, WorldGenJungle.Rosewood.class),
    Purpleheart("Purpleheart", "peltogyne", "spp.", 7835477, 7835477, ILogType.ExtraTreeLog.Purpleheart, null, WorldGenJungle.Purpleheart.class),
    Iroko("Iroko", "milicia", "excelsa", 11520108, 11520108, ILogType.ExtraTreeLog.Iroko, null, WorldGenTree2.Iroko.class),
    Gingko("Ginkgo", "ginkgo", "biloba", 7444049, 7444049, ILogType.ExtraTreeLog.Gingko, ExtraTreeFruitGene.GingkoNut, WorldGenTree2.Gingko.class),
    Brazilnut("Brazil Nut", "bertholletia", "excelsa", 8163195, 8163195, ILogType.VanillaLog.Jungle, ExtraTreeFruitGene.BrazilNut, WorldGenJungle.BrazilNut.class),
    RoseGum("Rose Gum", "eucalyptus", "grandis", 10265176, 10265176, ILogType.ExtraTreeLog.Eucalyptus, null, WorldGenEucalyptus.RoseGum.class),
    SwampGum("Swamp Gum", "eucalyptus", "grandis", 10667654, 10667654, ILogType.ExtraTreeLog.Eucalyptus2, null, WorldGenEucalyptus.SwampGum.class),
    Box("Boxwood", "boxus", "sempervirens", 7510381, 7510381, ILogType.ExtraTreeLog.Box, null, WorldGenTree2.Box.class),
    Clove("Clove", "syzygium", "aromaticum", 8028703, 8028703, ILogType.ExtraTreeLog.Syzgium, ExtraTreeFruitGene.Clove, WorldGenTree2.Clove.class),
    Coffee("Coffee", "coffea", "arabica", 7311461, 7311461, ILogType.VanillaLog.Jungle, ExtraTreeFruitGene.Coffee, WorldGenJungle.Coffee.class),
    MonkeyPuzzle("Monkey Puzzle", "araucaria", "araucana", 5726552, 5726552, ILogType.ForestryLog.PINE, null, WorldGenConifer.MonkeyPuzzle.class),
    RainbowGum("Rainbow Gum", "eucalyptus", "deglupta", 12054565, 12054565, ILogType.ExtraTreeLog.Eucalyptus3, null, WorldGenEucalyptus.RainbowGum.class),
    PinkIvory("Pink Ivory", "berchemia", "zeyheri", 8163673, 8163673, ILogType.ExtraTreeLog.PinkIvory, null, WorldGenTree.class),
    Blackcurrant("Blackcurrant", "ribes", "nigrum", 10934876, 10934876, null, ExtraTreeFruitGene.Blackcurrant, WorldGenShrub.Shrub.class),
    Redcurrant("Redcurrant", "ribes", "rubrum", 7646208, 7646208, null, ExtraTreeFruitGene.Redcurrant, WorldGenShrub.Shrub.class),
    Blackberry("Blackberry", "rubus", "fruticosus", 9617755, 9617755, null, ExtraTreeFruitGene.Blackberry, WorldGenShrub.Shrub.class),
    Raspberry("Raspberry", "rubus", "idaeus", 8632686, 8632686, null, ExtraTreeFruitGene.Raspberry, WorldGenShrub.Shrub.class),
    Blueberry("Blueberry", "vaccinium", "corymbosum", 7522128, 7522128, null, ExtraTreeFruitGene.Blueberry, WorldGenShrub.Shrub.class),
    Cranberry("Cranberry", "vaccinium", "oxycoccos", 9884025, 9884025, null, ExtraTreeFruitGene.Cranberry, WorldGenShrub.Shrub.class),
    Juniper("Juniper", "juniperus", "communis", 9482569, 9482569, null, ExtraTreeFruitGene.Juniper, WorldGenShrub.Shrub.class),
    Gooseberry("Gooseberry", "ribes", "grossularia", 7977728, 7977728, null, ExtraTreeFruitGene.Gooseberry, WorldGenShrub.Shrub.class),
    GoldenRaspberry("Golden Raspberry", "rubus", "occidentalis", 8632686, 8632686, null, ExtraTreeFruitGene.GoldenRaspberry, WorldGenShrub.Shrub.class);

    private LeafType leafType = LeafType.Normal;
    private SaplingType saplingType = SaplingType.Default;
    private String description;
    int girth = 1;
    Class<? extends WorldGenerator> gen;
    IAlleleFruit fruit = null;
    IAllele[] template;
    int color;
    String name;
    String binomial;
    String uid;
    ILogType wood;
    String branchName;
    IClassification branch;
    boolean finished = false;

    public static void init() {
        ExtraTreeSpecies[] citrusSpecies;
        ExtraTreeSpecies[] pruneSpecies;
        String bookArborist = "Arborist Manual";
        for (ExtraTreeSpecies species : ExtraTreeSpecies.values()) {
            species.preInit();
        }
        OrchardApple.setHeight(TreeHeight.Smaller);
        OrchardApple.setSappiness(Sappiness.Low);
        SweetCrabapple.setSappiness(Sappiness.Low);
        FloweringCrabapple.setSappiness(Sappiness.Average);
        PrairieCrabapple.setSappiness(Sappiness.Low);
        OrchardApple.finished();
        SweetCrabapple.finished();
        FloweringCrabapple.finished();
        PrairieCrabapple.finished();
        for (ExtraTreeSpecies species : pruneSpecies = new ExtraTreeSpecies[]{Blackthorn, CherryPlum, Almond, Apricot, Peach, Nectarine, WildCherry, SourCherry, BlackCherry}) {
            species.setSappiness(Sappiness.Low);
            IAlleleTreeSpecies citrus = (IAlleleTreeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.treePlum");
            species.setWorldGen(citrus.getGeneratorClasses()[0]);
            species.setSappiness(Sappiness.Average);
            species.saplingType = SaplingType.Fruit;
            species.finished();
        }
        Blackthorn.setHeight(TreeHeight.Smallest);
        CherryPlum.setHeight(TreeHeight.Smallest);
        Almond.setHeight(TreeHeight.Smallest);
        Apricot.setHeight(TreeHeight.Smallest);
        Peach.setHeight(TreeHeight.Smallest);
        Nectarine.setHeight(TreeHeight.Smallest);
        SourCherry.setHeight(TreeHeight.Smallest);
        WildCherry.setSappiness(Sappiness.Lower);
        SourCherry.setSappiness(Sappiness.Low);
        BlackCherry.setSappiness(Sappiness.Low);
        for (ExtraTreeSpecies species : citrusSpecies = new ExtraTreeSpecies[]{Orange, Manderin, Satsuma, Tangerine, Lime, KeyLime, FingerLime, Pomelo, Grapefruit, Kumquat, Citron, BuddhaHand}) {
            species.setSappiness(Sappiness.Low);
            species.setLeafType(LeafType.Jungle);
            species.saplingType = SaplingType.Fruit;
            IAlleleTreeSpecies citrus = (IAlleleTreeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.treeLemon");
            species.setWorldGen(citrus.getGeneratorClasses()[0]);
            species.setSappiness(Sappiness.Lower);
            species.finished();
        }
        Orange.setHeight(TreeHeight.Smallest);
        Manderin.setHeight(TreeHeight.Smallest);
        Satsuma.setHeight(TreeHeight.Smallest);
        Tangerine.setHeight(TreeHeight.Smallest);
        Lime.setHeight(TreeHeight.Smallest);
        KeyLime.setHeight(TreeHeight.Smallest);
        FingerLime.setHeight(TreeHeight.Smallest);
        Pomelo.setHeight(TreeHeight.Smallest);
        Grapefruit.setHeight(TreeHeight.Smallest);
        Kumquat.setHeight(TreeHeight.Smallest);
        Citron.setHeight(TreeHeight.Smallest);
        BuddhaHand.setHeight(TreeHeight.Smallest);
        Banana.setLeafType(LeafType.Palm);
        RedBanana.setLeafType(LeafType.Palm);
        Plantain.setLeafType(LeafType.Palm);
        Banana.setSappiness(Sappiness.Low);
        Banana.finished();
        RedBanana.setSappiness(Sappiness.Low);
        RedBanana.finished();
        Plantain.setSappiness(Sappiness.Lower);
        Plantain.finished();
        Hemlock.setLeafType(LeafType.Conifer);
        Hemlock.setSappiness(Sappiness.Lower);
        Butternut.finished();
        Butternut.setHeight(TreeHeight.Average);
        Butternut.setGirth(2);
        Rowan.finished();
        Rowan.setHeight(TreeHeight.Smaller);
        Hemlock.finished();
        Hemlock.setHeight(TreeHeight.Larger);
        Hemlock.setGirth(2);
        Ash.finished();
        Ash.setHeight(TreeHeight.Average);
        Alder.finished();
        Alder.addDescription("A common tree in wet places and marshes.", bookArborist);
        Beech.finished();
        Beech.setHeight(TreeHeight.Average);
        Beech.addDescription("An elegant tree with small inedible nuts, used in the manufacture of seed oil.", bookArborist);
        CopperBeech.finished();
        CopperBeech.setHeight(TreeHeight.Average);
        CopperBeech.addDescription("Beautiful purple brown leaves make this tree a favourite of gardeners.", bookArborist);
        Aspen.finished();
        Yew.setLeafType(LeafType.Conifer);
        Cypress.setLeafType(LeafType.Conifer);
        DouglasFir.setLeafType(LeafType.Conifer);
        Yew.setSappiness(Sappiness.Lower);
        Cypress.setSappiness(Sappiness.Lower);
        DouglasFir.setSappiness(Sappiness.Lower);
        Yew.finished();
        Cypress.finished();
        Cypress.setHeight(TreeHeight.Large);
        ExtraTreeSpecies.Cypress.saplingType = SaplingType.Poplar;
        DouglasFir.finished();
        DouglasFir.setHeight(TreeHeight.Larger);
        DouglasFir.setGirth(2);
        Hazel.finished();
        Hazel.setHeight(TreeHeight.Smaller);
        Sycamore.finished();
        Sycamore.setHeight(TreeHeight.Average);
        Whitebeam.finished();
        Hawthorn.finished();
        Hawthorn.setHeight(TreeHeight.Smaller);
        Pecan.finished();
        Pecan.setHeight(TreeHeight.Average);
        Fir.setLeafType(LeafType.Conifer);
        Cedar.setLeafType(LeafType.Conifer);
        Sallow.setLeafType(LeafType.Willow);
        Elm.setSappiness(Sappiness.Lower);
        Fir.setSappiness(Sappiness.Lower);
        Cedar.setSappiness(Sappiness.Lower);
        Elm.finished();
        Elm.setHeight(TreeHeight.Large);
        Elder.finished();
        Elder.setHeight(TreeHeight.Smaller);
        Holly.finished();
        Holly.setHeight(TreeHeight.Smaller);
        Hornbeam.finished();
        Hornbeam.setHeight(TreeHeight.Average);
        Sallow.finished();
        Sallow.setHeight(TreeHeight.Smaller);
        AcornOak.finished();
        AcornOak.setHeight(TreeHeight.Large);
        AcornOak.setGirth(2);
        Fir.finished();
        Fir.setHeight(TreeHeight.Large);
        Cedar.finished();
        Cedar.setHeight(TreeHeight.Large);
        Cedar.setGirth(2);
        RedMaple.setLeafType(LeafType.Maple);
        BalsamFir.setLeafType(LeafType.Conifer);
        LoblollyPine.setLeafType(LeafType.Conifer);
        Olive.setSappiness(Sappiness.Lower);
        BalsamFir.setSappiness(Sappiness.Lower);
        LoblollyPine.setSappiness(Sappiness.Lower);
        Sweetgum.setSappiness(Sappiness.Lower);
        Locust.setSappiness(Sappiness.Average);
        Olive.finished();
        Olive.setHeight(TreeHeight.Smaller);
        RedMaple.finished();
        BalsamFir.finished();
        LoblollyPine.finished();
        LoblollyPine.setHeight(TreeHeight.Average);
        Sweetgum.finished();
        Sweetgum.setHeight(TreeHeight.Smaller);
        Locust.finished();
        Locust.setHeight(TreeHeight.Average);
        Pear.finished();
        Pear.setHeight(TreeHeight.Smallest);
        OsangeOsange.setSappiness(Sappiness.Lower);
        OsangeOsange.setLeafType(LeafType.Jungle);
        OldFustic.setLeafType(LeafType.Jungle);
        Brazilwood.setLeafType(LeafType.Jungle);
        Logwood.setLeafType(LeafType.Jungle);
        Rosewood.setLeafType(LeafType.Jungle);
        Purpleheart.setLeafType(LeafType.Jungle);
        OsangeOsange.finished();
        OsangeOsange.setHeight(TreeHeight.Smaller);
        OldFustic.finished();
        Brazilwood.finished();
        Brazilwood.setHeight(TreeHeight.Smaller);
        Logwood.finished();
        Logwood.setHeight(TreeHeight.Smaller);
        Rosewood.finished();
        Rosewood.setHeight(TreeHeight.Average);
        Purpleheart.finished();
        Purpleheart.setHeight(TreeHeight.Average);
        RoseGum.setSappiness(Sappiness.Low);
        SwampGum.setSappiness(Sappiness.Low);
        RainbowGum.setSappiness(Sappiness.Low);
        Gingko.setLeafType(LeafType.Jungle);
        Brazilnut.setLeafType(LeafType.Jungle);
        RoseGum.setLeafType(LeafType.Jungle);
        SwampGum.setLeafType(LeafType.Jungle);
        Coffee.setLeafType(LeafType.Jungle);
        MonkeyPuzzle.setLeafType(LeafType.Conifer);
        RainbowGum.setLeafType(LeafType.Jungle);
        Iroko.finished();
        Iroko.setHeight(TreeHeight.Large);
        Gingko.finished();
        Gingko.setHeight(TreeHeight.Average);
        Brazilnut.finished();
        Brazilnut.setHeight(TreeHeight.Large);
        RoseGum.finished();
        RoseGum.setHeight(TreeHeight.Larger);
        SwampGum.finished();
        SwampGum.setHeight(TreeHeight.Largest);
        SwampGum.setGirth(2);
        Box.finished();
        Box.setHeight(TreeHeight.Smallest);
        Clove.finished();
        Clove.setHeight(TreeHeight.Smaller);
        Coffee.finished();
        Coffee.setHeight(TreeHeight.Smaller);
        MonkeyPuzzle.finished();
        MonkeyPuzzle.setHeight(TreeHeight.Large);
        MonkeyPuzzle.setGirth(2);
        RainbowGum.finished();
        RainbowGum.setHeight(TreeHeight.Average);
        PinkIvory.setHeight(TreeHeight.Small);
        PinkIvory.finished();
        Blackcurrant.setHeight(TreeHeight.Smallest);
        Redcurrant.setHeight(TreeHeight.Smallest);
        Blackberry.setHeight(TreeHeight.Smallest);
        Raspberry.setHeight(TreeHeight.Smallest);
        Blueberry.setHeight(TreeHeight.Smallest);
        Cranberry.setHeight(TreeHeight.Smallest);
        Juniper.setHeight(TreeHeight.Smallest);
        Gooseberry.setHeight(TreeHeight.Smallest);
        GoldenRaspberry.setHeight(TreeHeight.Smallest);
        Juniper.setLeafType(LeafType.Conifer);
        ExtraTreeSpecies.Blackcurrant.saplingType = SaplingType.Shrub;
        ExtraTreeSpecies.Redcurrant.saplingType = SaplingType.Shrub;
        ExtraTreeSpecies.Blackberry.saplingType = SaplingType.Shrub;
        ExtraTreeSpecies.Raspberry.saplingType = SaplingType.Shrub;
        ExtraTreeSpecies.Blueberry.saplingType = SaplingType.Shrub;
        ExtraTreeSpecies.Cranberry.saplingType = SaplingType.Shrub;
        ExtraTreeSpecies.Juniper.saplingType = SaplingType.Shrub;
        ExtraTreeSpecies.Gooseberry.saplingType = SaplingType.Shrub;
        ExtraTreeSpecies.GoldenRaspberry.saplingType = SaplingType.Shrub;
        for (ExtraTreeSpecies species : ExtraTreeSpecies.values()) {
            String scientific = species.branchName.substring(0, 1).toUpperCase() + species.branchName.substring(1).toLowerCase();
            String uid = "trees." + species.branchName.toLowerCase();
            IClassification branch = AlleleManager.alleleRegistry.getClassification("genus." + uid);
            if (branch == null) {
                branch = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.GENUS, uid, scientific);
            }
            species.branch = branch;
            species.branch.addMemberSpecies((IAlleleSpecies)species);
        }
    }

    private void addDescription(String string, String book) {
        this.description = string + "|" + book;
    }

    static final ItemStack getEBXLStack(String name) {
        try {
            Class<?> elements = Class.forName("extrabiomes.lib.Element");
            Method getElementMethod = elements.getMethod("valueOf", String.class);
            Method getItemStack = elements.getMethod("get", new Class[0]);
            Object element = getElementMethod.invoke(null, "SAPLING_AUTUMN_YELLOW");
            return (ItemStack)getItemStack.invoke(element, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setWorldGen(Class<? extends WorldGenerator> gen) {
        this.gen = gen;
    }

    private void setGirth(int i) {
        this.template[EnumTreeChromosome.GIRTH.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.i" + i + "d");
    }

    public void preInit() {
        IClassification clas;
        this.template = BinnieGenetics.getTreeRoot().getDefaultTemplate();
        this.template[0] = this;
        if (this.fruit != null) {
            this.template[EnumTreeChromosome.FRUITS.ordinal()] = this.fruit;
        }
        if ((clas = AlleleManager.alleleRegistry.getClassification("trees." + this.branch)) != null) {
            clas.addMemberSpecies((IAlleleSpecies)this);
            this.branch = clas;
        }
    }

    private ExtraTreeSpecies(String name, String branch, String binomial, int color, int polColor, ILogType wood, IAlleleFruit fruit, Class<? extends WorldGenerator> gen) {
        this.name = name;
        this.color = color;
        this.uid = this.toString().toLowerCase();
        this.wood = wood;
        this.fruit = fruit;
        this.gen = gen == null ? WorldGenTree.class : gen;
        this.branchName = branch;
        this.binomial = binomial;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public EnumTemperature getTemperature() {
        return EnumTemperature.NORMAL;
    }

    public EnumHumidity getHumidity() {
        return EnumHumidity.NORMAL;
    }

    public boolean hasEffect() {
        return false;
    }

    public boolean isSecret() {
        return false;
    }

    public boolean isCounted() {
        return true;
    }

    public String getBinomial() {
        return this.binomial;
    }

    public String getAuthority() {
        return "Binnie";
    }

    public IClassification getBranch() {
        return this.branch;
    }

    public String getUID() {
        return "extratrees.species." + this.uid;
    }

    public boolean isDominant() {
        return true;
    }

    public EnumPlantType getPlantType() {
        return EnumPlantType.Plains;
    }

    public int getGirth() {
        return this.girth;
    }

    public WorldGenerator getGenerator(ITree tree, World world, int x, int y, int z) {
        if (this.gen != null) {
            try {
                return this.gen.getConstructor(ITree.class).newInstance(tree);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return new WorldGenDefault(tree);
    }

    public Class<? extends WorldGenerator>[] getGeneratorClasses() {
        return null;
    }

    void setLeafType(LeafType type) {
        this.leafType = type;
        if (this.leafType == LeafType.Conifer) {
            this.saplingType = SaplingType.Conifer;
        }
        if (this.leafType == LeafType.Jungle) {
            this.saplingType = SaplingType.Jungle;
        }
        if (this.leafType == LeafType.Palm) {
            this.saplingType = SaplingType.Palm;
        }
    }

    public IAllele[] getTemplate() {
        return this.template;
    }

    public ArrayList<IFruitFamily> getSuitableFruit() {
        ArrayList<IFruitFamily> list = new ArrayList<IFruitFamily>();
        list.addAll(AlleleManager.alleleRegistry.getRegisteredFruitFamilies().values());
        return list;
    }

    public ILogType getLog() {
        return this.wood;
    }

    public void setHeight(TreeHeight height) {
        IAllele allele = height.getAllele();
        if (allele != null) {
            this.template[EnumTreeChromosome.HEIGHT.ordinal()] = allele;
        }
    }

    public void setSappiness(Sappiness height) {
        IAllele allele = height.getAllele();
        if (allele != null) {
            this.template[EnumTreeChromosome.SAPPINESS.ordinal()] = allele;
        }
    }

    public void setGrowthConditions(Growth growth) {
        IAllele allele = growth.getAllele();
        if (allele != null) {
            this.template[EnumTreeChromosome.GROWTH.ordinal()] = allele;
        }
    }

    public boolean isFinished() {
        return true;
    }

    public void finished() {
        this.finished = true;
    }

    public int getLeafColour(ITree tree) {
        return this.color;
    }

    public short getLeafIconIndex(ITree tree, boolean fancy) {
        if (!fancy) {
            return this.leafType.plainUID;
        }
        if (tree.getMate() != null) {
            return this.leafType.changedUID;
        }
        return this.leafType.fancyUID;
    }

    public int getIconColour(int renderPass) {
        return renderPass == 0 ? this.color : 10451021;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getGermlingIcon(EnumGermlingType type, int renderPass) {
        if (type == EnumGermlingType.POLLEN) {
            return ItemInterface.getItem((String)"pollen").func_77973_b().func_77618_c(0, renderPass);
        }
        return renderPass == 0 ? this.saplingType.icon[1] : this.saplingType.icon[0];
    }

    public IIconProvider getIconProvider() {
        return this;
    }

    public Icon getIcon(short texUID) {
        return null;
    }

    public void registerIcons(IconRegister register) {
        for (SaplingType type : SaplingType.values()) {
            type.icon = new Icon[2];
            type.icon[0] = ExtraTrees.proxy.getIcon(register, "saplings/" + type.toString().toLowerCase() + ".trunk");
            type.icon[1] = ExtraTrees.proxy.getIcon(register, "saplings/" + type.toString().toLowerCase() + ".leaves");
        }
    }

    public ITreeRoot getRoot() {
        return BinnieGenetics.getTreeRoot();
    }

    public float getResearchSuitability(ItemStack itemstack) {
        if (itemstack == null) {
            return 0.0f;
        }
        if (this.template[EnumTreeChromosome.FRUITS.ordinal()] instanceof ExtraTreeFruitGene) {
            ExtraTreeFruitGene fruit = (ExtraTreeFruitGene)this.template[EnumTreeChromosome.FRUITS.ordinal()];
            for (ItemStack stack : fruit.products.keySet()) {
                if (!stack.func_77969_a(itemstack)) continue;
                return 1.0f;
            }
        }
        if (itemstack.field_77993_c == ItemInterface.getItem((String)"honeyDrop").field_77993_c) {
            return 0.5f;
        }
        if (itemstack.field_77993_c == ItemInterface.getItem((String)"honeydew").field_77993_c) {
            return 0.7f;
        }
        if (itemstack.field_77993_c == ItemInterface.getItem((String)"beeComb").field_77993_c) {
            return 0.4f;
        }
        if (AlleleManager.alleleRegistry.isIndividual(itemstack)) {
            return 1.0f;
        }
        for (Map.Entry entry : this.getRoot().getResearchCatalysts().entrySet()) {
            if (!((ItemStack)entry.getKey()).func_77969_a(itemstack)) continue;
            return ((Float)entry.getValue()).floatValue();
        }
        return 0.0f;
    }

    public ItemStack[] getResearchBounty(World world, String researcher, IIndividual individual, int bountyLevel) {
        Collection combinations;
        ArrayList<ItemStack> bounty = new ArrayList<ItemStack>();
        ItemStack research = null;
        if (world.field_73012_v.nextFloat() < 10.0f / (float)bountyLevel && (combinations = this.getRoot().getCombinations((IAllele)this)).size() > 0) {
            IMutation[] candidates = combinations.toArray(new IMutation[0]);
            research = AlleleManager.alleleRegistry.getMutationNoteStack(researcher, candidates[world.field_73012_v.nextInt(candidates.length)]);
        }
        if (research != null) {
            bounty.add(research);
        }
        if (this.template[EnumTreeChromosome.FRUITS.ordinal()] instanceof ExtraTreeFruitGene) {
            ExtraTreeFruitGene fruit = (ExtraTreeFruitGene)this.template[EnumTreeChromosome.FRUITS.ordinal()];
            for (ItemStack stack : fruit.products.keySet()) {
                ItemStack stack2 = stack.func_77946_l();
                stack2.field_77994_a = world.field_73012_v.nextInt((int)((float)bountyLevel / 2.0f)) + 1;
                bounty.add(stack2);
            }
        }
        return bounty.toArray(new ItemStack[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public int getGermlingColour(EnumGermlingType type, int renderPass) {
        if (type == EnumGermlingType.SAPLING) {
            return renderPass == 0 ? this.getLeafColour(null) : (this.getLog() == null ? 0xFFFFFF : this.getLog().getColour());
        }
        return this.getLeafColour(null);
    }

    public int getComplexity() {
        return 1 + this.getGeneticAdvancement((IAllele)this, new ArrayList<IAllele>());
    }

    private int getGeneticAdvancement(IAllele species, ArrayList<IAllele> exclude) {
        int own = 1;
        int highest = 0;
        exclude.add(species);
        for (IMutation mutation : this.getRoot().getPaths(species, EnumBeeChromosome.SPECIES.ordinal())) {
            int otherAdvance;
            if (!exclude.contains(mutation.getAllele0()) && (otherAdvance = this.getGeneticAdvancement(mutation.getAllele0(), exclude)) > highest) {
                highest = otherAdvance;
            }
            if (exclude.contains(mutation.getAllele1()) || (otherAdvance = this.getGeneticAdvancement(mutation.getAllele1(), exclude)) <= highest) continue;
            highest = otherAdvance;
        }
        return own + (highest < 0 ? 0 : highest);
    }

    public ItemStack[] getLogStacks() {
        if (this.wood == null) {
            return new ItemStack[0];
        }
        return new ItemStack[]{this.wood.getItemStack()};
    }

    static enum Sappiness {
        Lowest,
        Lower,
        Low,
        Average,
        High,
        Higher,
        Highest;


        public IAllele getAllele() {
            return AlleleManager.alleleRegistry.getAllele("forestry.sappiness" + this.toString());
        }
    }

    static enum Growth {
        Tropical;


        public IAllele getAllele() {
            return AlleleManager.alleleRegistry.getAllele("forestry.growth" + this.toString());
        }
    }

    static enum TreeHeight {
        Smallest,
        Smaller,
        Small,
        Average,
        Large,
        Larger,
        Largest,
        Gigantic;


        public IAllele getAllele() {
            return AlleleManager.alleleRegistry.getAllele("forestry.height" + (this == Average ? "Max10" : this.toString()));
        }
    }

    public static enum SaplingType {
        Default,
        Jungle,
        Conifer,
        Fruit,
        Poplar,
        Palm,
        Shrub;

        Icon[] icon;
    }

    private static enum LeafType {
        Normal(10, 11, 12),
        Conifer(15, 16, 17),
        Jungle(20, 21, 22),
        Willow(25, 26, 27),
        Maple(30, 31, 32),
        Palm(35, 36, 37);

        public final short fancyUID;
        public final short plainUID;
        public final short changedUID;

        private LeafType(short fancyUID, short plainUID, short changedUID) {
            this.fancyUID = fancyUID;
            this.plainUID = plainUID;
            this.changedUID = changedUID;
        }
    }
}

