/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.carpentry;

import binnie.core.block.TileEntityMetadata;
import binnie.extratrees.carpentry.BlockCarpentry;
import binnie.extratrees.carpentry.CarpentryBlock;
import binnie.extratrees.carpentry.ModuleCarpentry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockCarpentryPanel
extends BlockCarpentry {
    public BlockCarpentryPanel(int id) {
        super(id);
        Block.field_71982_s[id] = true;
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
        this.func_71868_h(0);
    }

    @Override
    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        CarpentryBlock block = this.getCarpentryBlock(world, x, y, z);
        switch (block.getFacing()) {
            case DOWN: {
                this.func_71905_a(0.0f, 0.9375f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case EAST: {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 0.0625f, 1.0f, 1.0f);
                break;
            }
            case NORTH: {
                this.func_71905_a(0.0f, 0.0f, 0.9375f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case SOUTH: {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0625f);
                break;
            }
            case UP: {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
                break;
            }
            case WEST: {
                this.func_71905_a(0.9375f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
        }
    }

    public void func_71919_f() {
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
    }

    @Override
    public String getBlockName(ItemStack stack) {
        CarpentryBlock block = ModuleCarpentry.getCarpentryBlock(TileEntityMetadata.getItemDamage(stack));
        return block.getDesign().getName() + " Wooden Panel";
    }

    public AxisAlignedBB func_71872_e(World par1World, int par2, int par3, int par4) {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)par2 + this.field_72026_ch, (double)par3 + this.field_72023_ci, (double)par4 + this.field_72024_cj, (double)par2 + this.field_72021_ck, (double)par3 + this.field_72022_cl, (double)par4 + this.field_72019_cm);
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_71877_c(IBlockAccess world, int x, int y, int z, int side) {
        return super.func_71877_c(world, x, y, z, side);
    }

    @Override
    public CarpentryBlock getCarpentryBlock(IBlockAccess world, int x, int y, int z) {
        return ModuleCarpentry.getCarpentryPanel(TileEntityMetadata.getTileMetadata(world, x, y, z));
    }

    public static boolean isValidPanelPlacement(World world, int x, int y, int z, ForgeDirection facing) {
        if (facing == ForgeDirection.UNKNOWN) {
            return false;
        }
        int bx = x - facing.offsetX;
        int by = y - facing.offsetY;
        int bz = z - facing.offsetZ;
        Block block = Block.field_71973_m[world.func_72798_a(bx, by, bz)];
        if (block == null) {
            return false;
        }
        return block.isBlockSolidOnSide(world, bx, by, bz, facing);
    }

    @Override
    public int getPlacedMeta(ItemStack item, World world, int x, int y, int z, ForgeDirection clickedBlock) {
        CarpentryBlock block = ModuleCarpentry.getCarpentryPanel(TileEntityMetadata.getItemDamage(item));
        ForgeDirection facing = clickedBlock;
        boolean valid = true;
        if (!BlockCarpentryPanel.isValidPanelPlacement(world, x, y, z, facing)) {
            valid = false;
            for (ForgeDirection direction : ForgeDirection.values()) {
                if (!BlockCarpentryPanel.isValidPanelPlacement(world, x, y, z, direction)) continue;
                facing = direction;
                valid = true;
                break;
            }
        }
        if (!valid) {
            return -1;
        }
        block.setFacing(facing);
        return block.getBlockMetadata();
    }

    public void func_71863_a(World world, int x, int y, int z, int par5) {
        super.func_71863_a(world, x, y, z, par5);
        CarpentryBlock block = this.getCarpentryBlock((IBlockAccess)world, x, y, z);
        if (!BlockCarpentryPanel.isValidPanelPlacement(world, x, y, z, block.getFacing())) {
            for (ItemStack stack : this.getBlockDropped(world, x, y, z, world.func_72798_a(x, y, z), 0)) {
                this.func_71929_a(world, x, y, z, stack);
            }
            world.func_94571_i(x, y, z);
        }
    }
}

