/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.block;

import binnie.core.block.TileEntityMetadata;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.ICarpentryWood;
import binnie.extratrees.block.DoorType;
import binnie.extratrees.block.IPlankType;
import com.google.common.base.Optional;
import forestry.api.core.BlockInterface;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class PlankType {
    public static void setup() {
        for (VanillaPlanks vanillaPlanks : VanillaPlanks.values()) {
            CarpentryManager.carpentryInterface.registerCarpentryWood(vanillaPlanks.ordinal(), vanillaPlanks);
        }
        for (Enum enum_ : ExtraTreePlanks.values()) {
            CarpentryManager.carpentryInterface.registerCarpentryWood(enum_.ordinal() + 32, (ICarpentryWood)((Object)enum_));
        }
        for (Enum enum_ : ForestryPlanks.values()) {
            CarpentryManager.carpentryInterface.registerCarpentryWood(enum_.ordinal() + 128, (ICarpentryWood)((Object)enum_));
        }
        for (Enum enum_ : ExtraBiomesPlank.values()) {
            CarpentryManager.carpentryInterface.registerCarpentryWood(enum_.ordinal() + 192, (ICarpentryWood)((Object)enum_));
        }
    }

    public static IPlankType getPlank(int index) {
        ICarpentryWood wood = CarpentryManager.carpentryInterface.getCarpentryWood(index);
        if (wood instanceof IPlankType) {
            return (IPlankType)wood;
        }
        return ExtraTreePlanks.Fir;
    }

    public static int indexOf(IPlankType type) {
        int index = CarpentryManager.carpentryInterface.getCarpentryWoodIndex(type);
        return index < 0 ? 0 : index;
    }

    public static ItemStack getGate(IPlankType plank) {
        return TileEntityMetadata.getItemStack(ExtraTrees.blockGate.field_71990_ca, PlankType.indexOf(plank));
    }

    public static ItemStack getFence(IPlankType plank) {
        if (plank instanceof ForestryPlanks) {
            int ordinal;
            for (ordinal = ((ForestryPlanks)plank).ordinal(); ordinal >= 16; ordinal -= 16) {
            }
            ItemStack fence = BlockInterface.getBlock((String)("fences" + (((ForestryPlanks)plank).ordinal() / 16 + 1)));
            fence.func_77964_b(ordinal);
            return fence;
        }
        return TileEntityMetadata.getItemStack(ExtraTrees.blockFence.field_71990_ca, PlankType.indexOf(plank));
    }

    public static ItemStack getDoor(IPlankType plank, DoorType type) {
        return TileEntityMetadata.getItemStack(ExtraTrees.blockDoor.field_71990_ca, type.ordinal() * 256 + PlankType.indexOf(plank));
    }

    public static List<IPlankType> getAllPlankTypes() {
        ArrayList<IPlankType> list = new ArrayList<IPlankType>();
        for (ExtraTreePlanks extraTreePlanks : ExtraTreePlanks.values()) {
            list.add(extraTreePlanks);
        }
        for (Enum enum_ : ForestryPlanks.values()) {
            list.add((IPlankType)((Object)enum_));
        }
        for (Enum enum_ : ExtraBiomesPlank.values()) {
            list.add((IPlankType)((Object)enum_));
        }
        for (Enum enum_ : VanillaPlanks.values()) {
            list.add((IPlankType)((Object)enum_));
        }
        return list;
    }

    public static enum ExtraBiomesPlank implements IPlankType
    {
        Redwood("Redwood", 10185538),
        Fir("Scottish Fir", 8288074),
        Acacia("Excel Acacia", 12561022);

        String name;
        int color;

        private ExtraBiomesPlank(String name, int color) {
            this.name = name;
            this.color = color;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getColour() {
            return this.color;
        }

        @Override
        public ItemStack getPlank() {
            try {
                Class<?> clss = Class.forName("extrabiomes.api.Stuff");
                Block block = (Block)((Optional)clss.getField("planks").get(null)).get();
                return new ItemStack(block, 1, this.ordinal());
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public Icon getIcon() {
            if (this.getPlank() != null) {
                int meta = this.getPlank().func_77960_j();
                Block block = Block.field_71973_m[((ItemBlock)this.getPlank().func_77973_b()).func_77883_f()];
                return block.func_71858_a(2, meta);
            }
            return null;
        }
    }

    public static enum ForestryPlanks implements IPlankType
    {
        LARCH("Larch", 14131085),
        TEAK("Teak", 8223075),
        ACACIA("Acacia", 9745287),
        LIME("Lime", 13544048),
        CHESTNUT("Chestnut", 12298845),
        WENGE("Wenge", 6182474),
        BAOBAB("Baobab", 9608290),
        SEQUOIA("Sequoia", 10050135),
        KAPOK("Kapok", 8156212),
        EBONY("Ebony", 3946288),
        MAHOGANY("Mahogany", 7749432),
        BALSA("Balsa", 0xA9A299),
        WILLOW("Willow", 11710818),
        WALNUT("Walnut", 6836802),
        GREENHEART("Greenheart", 5144156),
        CHERRY("Cherry", 11895348),
        MAHOE("Mahoe", 8362154),
        POPLAR("Poplar", 13619074),
        PALM("Palm", 13271115),
        PAPAYA("Papaya", 14470005),
        PINE("Pine", 12885585),
        PLUM("Plum", 11364479),
        MAPLE("Maple", 11431211),
        CITRUS("Citrus", 10266653);

        String name;
        int color;

        private ForestryPlanks(String name, int color) {
            this.name = name;
            this.color = color;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getColour() {
            return this.color;
        }

        @Override
        public ItemStack getPlank() {
            ItemStack stack = BlockInterface.getBlock((String)("planks" + (this.ordinal() / 16 + 1)));
            return new ItemStack(stack.func_77973_b(), 1, this.ordinal() % 16);
        }

        @Override
        public Icon getIcon() {
            if (this.getPlank() != null) {
                int meta = this.getPlank().func_77960_j();
                Block block = Block.field_71973_m[((ItemBlock)this.getPlank().func_77973_b()).func_77883_f()];
                return block.func_71858_a(2, meta);
            }
            return null;
        }
    }

    public static enum VanillaPlanks implements IPlankType
    {
        OAK("Oak", 11833434),
        SPRUCE("Spruce", 8412726),
        BIRCH("Birch", 14139781),
        JUNGLE("Jungle", 11632732);

        String name;
        int color;

        private VanillaPlanks(String name, int color) {
            this.name = name;
            this.color = color;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getColour() {
            return this.color;
        }

        @Override
        public ItemStack getPlank() {
            return new ItemStack(Block.field_71988_x.field_71990_ca, 1, this.ordinal());
        }

        @Override
        public Icon getIcon() {
            if (this.getPlank() != null) {
                int meta = this.getPlank().func_77960_j();
                Block block = Block.field_71988_x;
                return block.func_71858_a(2, meta);
            }
            return null;
        }
    }

    public static enum ExtraTreePlanks implements IPlankType
    {
        Fir("Fir", 12815444),
        Cedar("Cedar", 14181940),
        Hemlock("Hemlock", 13088108),
        Cypress("Cypress", 16169052),
        Fig("Fig", 13142058),
        Beech("Beech", 14784849),
        Alder("Alder", 12092755),
        Hazel("Hazel", 13480341),
        Hornbeam("Hornbeam", 12818528),
        Box("Box", 16511430),
        Butternut("Butternut", 15510138),
        Hickory("Hickory", 14333070),
        Whitebeam("Whitebeam", 13222585),
        Elm("Elm", 15772004),
        Apple("Apple", 6305064),
        Yew("Yew", 14722426),
        Pear("Pear", 12093805),
        Hawthorn("Hawthorn", 13402978),
        Rowan("Rowan", 13610394),
        Elder("Elder", 12489337),
        Maclura("Maclura", 15970862),
        Syzgium("Syzgium", 15123393),
        Brazilwood("Brazilwood", 7487063),
        Logwood("Logwood", 10762028),
        Iroko("Iroko", 7681024),
        Locust("Locust", 12816736),
        Eucalyptus("Eucalyptus", 16165771),
        Purpleheart("Purpleheart", 5970991),
        Ash("Ash", 16107368),
        Holly("Holly", 16512743),
        Olive("Olive", 11578760),
        Sweetgum("Sweetgum", 13997656),
        Rosewood("Rosewood", 7738624),
        Gingko("Gingko", 16050106),
        PinkIvory("Pink Ivory", 15502496);

        String name;
        int color;
        Icon icon;

        private ExtraTreePlanks(String name, int color) {
            this.name = name;
            this.color = color;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getColour() {
            return this.color;
        }

        @Override
        public ItemStack getPlank() {
            return TileEntityMetadata.getItemStack(ExtraTrees.blockPlanks.field_71990_ca, this.ordinal());
        }

        public Icon loadIcon(IconRegister register) {
            this.icon = ExtraTrees.proxy.getIcon(register, "planks/" + this.toString());
            return this.icon;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }
    }
}

