/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol.drink;

import binnie.extratrees.alcohol.Glassware;
import binnie.extratrees.alcohol.drink.CocktailType;
import binnie.extratrees.alcohol.drink.DrinkType;
import binnie.extratrees.alcohol.drink.ItemDrink;
import forestry.api.core.INBTTagable;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class IDrinkType
implements INBTTagable {
    int volume = 0;
    Glassware glassware = Glassware.Pint;
    int glasswareColour = 0xFFFFFF;
    int colour = 0xFFFFFF;
    float transparency = 1.0f;
    String name = "";
    public static final String NBT_Name = "nm";
    public static final String NBT_Glassware = "gw";
    public static final String NBT_GlasswareColour = "gwc";
    public static final String NBT_Colour = "cl";
    public static final String NBT_Transparency = "tr";
    public static final String NBT_Volume = "vl";

    public int getVolume() {
        return this.volume;
    }

    public String getName() {
        return !this.isEmpty() ? (this.name.isEmpty() ? this.getDisplayName() : this.name) : "Empty " + this.glassware.getName();
    }

    protected abstract String getDisplayName();

    public void getInformation(List<String> list) {
        if (!this.isEmpty()) {
            if (this.name.isEmpty()) {
                list.add(this.glassware.getName());
            } else {
                list.add(this.getDisplayName() + ", " + this.glassware.getName());
            }
        }
    }

    public static IDrinkType getDrinkType(ItemStack stack) {
        IDrinkType type = new DrinkType();
        if (stack.func_77978_p().func_74779_i("type").equals("cocktail")) {
            type = new CocktailType();
        }
        ((IDrinkType)type).readFromNBT(stack.func_77978_p());
        return type;
    }

    public Glassware getGlassware() {
        return this.glassware;
    }

    public int getColour() {
        return this.colour;
    }

    public int getGlasswareColour() {
        return this.glasswareColour;
    }

    public float getTransparency() {
        return this.transparency;
    }

    public final boolean isEmpty() {
        return this.volume <= 0;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.name = nbt.func_74779_i(NBT_Name);
        this.glassware = Glassware.values()[nbt.func_74771_c(NBT_Glassware)];
        this.glasswareColour = nbt.func_74764_b(NBT_GlasswareColour) ? nbt.func_74762_e(NBT_GlasswareColour) : 0xFFFFFF;
        this.colour = nbt.func_74762_e(NBT_Colour);
        this.transparency = nbt.func_74764_b(NBT_Transparency) ? nbt.func_74760_g(NBT_Transparency) : 1.0f;
        this.volume = nbt.func_74765_d(NBT_Volume);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a(NBT_Name, this.name);
        nbt.func_74774_a(NBT_Glassware, (byte)this.glassware.ordinal());
        nbt.func_74768_a(NBT_GlasswareColour, this.glasswareColour);
        nbt.func_74768_a(NBT_Colour, this.colour);
        nbt.func_74776_a(NBT_Transparency, this.transparency);
        nbt.func_74777_a(NBT_Volume, (short)this.volume);
    }

    public ItemStack get(int i) {
        return ItemDrink.getCocktailItem(this, i);
    }

    public void setName(String value) {
        this.name = value;
    }
}

