/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol.drink;

import binnie.core.BinnieCore;
import binnie.extratrees.alcohol.Cocktail;
import binnie.extratrees.alcohol.Glassware;
import binnie.extratrees.alcohol.ICocktailIngredient;
import binnie.extratrees.alcohol.drink.IDrinkType;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;

public class CocktailType
extends IDrinkType {
    Map<ICocktailIngredient, Integer> ingredients = new HashMap<ICocktailIngredient, Integer>();

    public CocktailType(Glassware glassware, Cocktail cocktail) {
        this(glassware, cocktail.ingredients);
        this.name = "\u00a7l" + cocktail.name;
    }

    public CocktailType(Glassware glassware, Map<ICocktailIngredient, Integer> ingredients) {
        this.glassware = glassware;
        this.volume = glassware.getCapacity();
        for (ICocktailIngredient ingr : ingredients.keySet()) {
            if (!Cocktail.isIngredient(ingr.getIdentifier())) continue;
            this.ingredients.put(ingr, ingredients.get(ingr));
        }
        this.onAlteration();
    }

    public CocktailType() {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        NBTTagCompound ingNbt = nbt.func_74775_l("ingrs");
        for (Object o : ingNbt.func_74758_c()) {
            NBTTagInt nb = (NBTTagInt)o;
            this.ingredients.put(Cocktail.getIngredient(nb.func_74740_e()), nb.field_74748_a);
        }
    }

    private void onAlteration() {
        if (this.ingredients.size() == 0) {
            this.colour = 0xFFFFFF;
            this.transparency = 1.0f;
        } else {
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            float total = 0.0f;
            float alpha = 0.0f;
            float alphaTot = 0.0f;
            for (Map.Entry<ICocktailIngredient, Integer> entry : this.ingredients.entrySet()) {
                int c = entry.getKey().getColour();
                float mult = entry.getKey().getTransparency() * entry.getValue();
                total += mult;
                Color col = new Color(c);
                r += (float)col.getRed() * mult;
                g += (float)col.getGreen() * mult;
                b += (float)col.getBlue() * mult;
                alpha += mult;
                alphaTot += (float)entry.getValue().intValue();
            }
            Color col = new Color((int)(r /= total), (int)(g /= total), (int)(b /= total));
            this.colour = col.getRGB();
            this.transparency = (alpha /= alphaTot) / 255.0f;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        NBTTagCompound ingNbt = new NBTTagCompound();
        for (Map.Entry<ICocktailIngredient, Integer> ing : this.ingredients.entrySet()) {
            if (ing.getKey() == null) continue;
            ingNbt.func_74768_a(ing.getKey().getIdentifier(), ing.getValue().intValue());
        }
        nbt.func_74766_a("ingrs", ingNbt);
        nbt.func_74778_a("type", "cocktail");
    }

    @Override
    public void getInformation(List<String> par3List) {
        super.getInformation(par3List);
        if (BinnieCore.proxy.isShiftDown()) {
            for (Map.Entry<ICocktailIngredient, Integer> entry : this.ingredients.entrySet()) {
                par3List.add(entry.getValue() + " Part" + (entry.getValue() > 1 ? "s " : " ") + entry.getKey().getName());
            }
        } else {
            par3List.add("Hold shift to see contents");
        }
    }

    @Override
    public String getDisplayName() {
        return "Cocktail";
    }
}

