/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol;

import binnie.core.liquid.IFluidType;
import binnie.core.liquid.LiquidContainer;
import binnie.core.liquid.LiquidManager;
import binnie.extratrees.alcohol.ICocktailLiquid;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.Icon;
import net.minecraftforge.fluids.FluidStack;

public enum Liqueur implements IFluidType,
ICocktailLiquid
{
    Almond("Almond", 14966063, 0.3),
    Orange("Orange", 16353536, 0.4),
    Banana("Banana", 16302592, 0.5),
    Chocolate("Chocolate", 12667680, 0.3),
    Mint("Mint", 2737788, 0.4),
    Hazelnut("Hazelnut", 15570987, 0.3),
    Cinnamon("Cinnamon", 0xE55000, 0.3),
    Coffee("Coffee", 9847577, 0.4),
    Melon("Melon", 11584049, 0.4),
    Anise("Anise", 14344681, 0.3),
    Peach("Peach", 16684384, 0.4),
    Lemon("Lemon", 16311405, 0.4),
    Herbal("Herbal", 16700673, 0.3),
    Cherry("Cherry", 14096641, 0.5),
    Blackcurrant("Blackcurrant", 6962541, 0.5),
    Blackberry("Blackberry", 6837581, 0.5),
    Raspberry("Raspberry", 10158848, 0.5);

    String name;
    String ident;
    Icon icon;
    int colour;
    float transparency;

    private void addFlavour(String oreDict) {
    }

    private Liqueur(String name, int colour, double transparency) {
        this(name + " Liqueur", "liqueur" + name, colour, transparency);
    }

    private Liqueur(String name, String ident, int colour, double transparency) {
        this.name = name;
        this.ident = ident;
        this.colour = colour;
        this.transparency = (float)transparency;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean canBePlacedInContainer(LiquidContainer container) {
        return true;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void registerIcon(IconRegister register) {
        this.icon = LiquidManager.loadLiquidIcon(register, this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIdentifier() {
        return "binnie." + this.ident;
    }

    @Override
    public int getColour() {
        return this.colour;
    }

    @Override
    public FluidStack get(int amount) {
        return LiquidManager.getLiquidStack(this.getIdentifier(), amount);
    }

    @Override
    public int getTransparency() {
        return (int)(Math.min(1.0, (double)this.transparency + 0.3) * 255.0);
    }

    @Override
    public String getTooltip(int ratio) {
        return ratio + " Part" + (ratio > 1 ? "s " : " ") + this.getName();
    }

    static {
        Almond.addFlavour("cropAlmond");
        Orange.addFlavour("cropOrange");
        Banana.addFlavour("cropBanana");
        Chocolate.addFlavour("cropCocoa");
        Mint.addFlavour("cropMint");
        Hazelnut.addFlavour("cropHazelnut");
        Cinnamon.addFlavour("cropCinnamon");
        Coffee.addFlavour("cropCoffee");
        Melon.addFlavour("cropMelon");
        Anise.addFlavour("cropAnise");
        Peach.addFlavour("cropPeach");
        Lemon.addFlavour("cropLemon");
        Herbal.addFlavour("cropHerbal");
        Cherry.addFlavour("cropCherry");
        Blackcurrant.addFlavour("cropBlackcurrant");
        Blackberry.addFlavour("cropBlackberry");
        Raspberry.addFlavour("cropRaspberry");
    }
}

