/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.worldgen;

import binnie.core.genetics.BinnieGenetics;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IHiveDrop;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IIndividual;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class HiveDrop
implements IHiveDrop {
    private IAllele[] template;
    private ArrayList<ItemStack> additional = new ArrayList();
    private int chance;

    public HiveDrop(IAlleleBeeSpecies species, int chance) {
        this(BinnieGenetics.getBeeRoot().getTemplate(species.getUID()), new ItemStack[0], chance);
    }

    public HiveDrop(IAllele[] template, ItemStack[] bonus, int chance) {
        if (template == null) {
            template = BinnieGenetics.getBeeRoot().getDefaultTemplate();
        }
        this.template = template;
        this.chance = chance;
        for (ItemStack stack : bonus) {
            this.additional.add(stack);
        }
    }

    public ItemStack getPrincess(World world, int x, int y, int z, int fortune) {
        return BinnieGenetics.getBeeRoot().getMemberStack((IIndividual)BinnieGenetics.getBeeRoot().getBee(world, BinnieGenetics.getBeeRoot().templateAsGenome(this.template)), EnumBeeType.PRINCESS.ordinal());
    }

    public ArrayList<ItemStack> getDrones(World world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(BinnieGenetics.getBeeRoot().getMemberStack((IIndividual)BinnieGenetics.getBeeRoot().templateAsIndividual(this.template), EnumBeeType.DRONE.ordinal()));
        return ret;
    }

    public ArrayList<ItemStack> getAdditional(World world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (ItemStack stack : this.additional) {
            ret.add(stack.func_77946_l());
        }
        return ret;
    }

    public int getChance(World world, int x, int y, int z) {
        return this.chance;
    }
}

