/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.worldgen;

import binnie.extrabees.ExtraBees;
import binnie.extrabees.worldgen.EnumHiveType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.IHiveDrop;
import forestry.api.core.Tabs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class BlockExtraBeeHive
extends Block {
    Icon[][] icons;

    public BlockExtraBeeHive(int par1) {
        super(par1, ExtraBees.materialBeehive);
        this.func_71900_a(0.2f);
        this.func_71848_c(1.0f);
        this.func_71907_b(true);
        this.func_71864_b("hive");
        this.func_71849_a(Tabs.tabApiculture);
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        for (int i = 0; i < 4; ++i) {
            itemList.add(new ItemStack((Block)this, 1, i));
        }
    }

    public Icon func_71858_a(int side, int metadata) {
        if (metadata >= EnumHiveType.values().length) {
            return null;
        }
        if (side < 2) {
            return this.icons[metadata][1];
        }
        return this.icons[metadata][0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
        this.icons = new Icon[EnumHiveType.values().length][2];
        for (EnumHiveType hive : EnumHiveType.values()) {
            this.icons[hive.ordinal()][0] = ExtraBees.proxy.getIcon(register, "hive/" + hive.toString().toLowerCase() + ".0");
            this.icons[hive.ordinal()][1] = ExtraBees.proxy.getIcon(register, "hive/" + hive.toString().toLowerCase() + ".1");
        }
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        List<IHiveDrop> dropList = EnumHiveType.values()[metadata].drops;
        Collections.shuffle(dropList);
        int tries = 0;
        boolean hasPrincess = false;
        block0: while (tries <= 10 && !hasPrincess) {
            ++tries;
            for (IHiveDrop drop : dropList) {
                if (world.field_73012_v.nextInt(100) >= drop.getChance(world, x, y, z)) continue;
                ret.add(drop.getPrincess(world, x, y, z, fortune));
                hasPrincess = true;
                continue block0;
            }
        }
        for (IHiveDrop drop : dropList) {
            if (world.field_73012_v.nextInt(100) >= drop.getChance(world, x, y, z)) continue;
            ret.addAll(drop.getDrones(world, x, y, z, fortune));
            break;
        }
        for (IHiveDrop drop : dropList) {
            if (world.field_73012_v.nextInt(100) >= drop.getChance(world, x, y, z)) continue;
            ret.addAll(drop.getAdditional(world, x, y, z, fortune));
            break;
        }
        return ret;
    }

    public void addCreativeItems(ArrayList itemList) {
        for (int i = 0; i < 4; ++i) {
            itemList.add(new ItemStack((Block)this, 1, i));
        }
    }
}

