/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.machines.logic;

import binnie.core.BinnieCore;
import binnie.core.genetics.BinnieGenetics;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.core.ItemInterface;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IFlowerProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class LogicAcclimatiser {
    static Set<ItemStack> acclimatiserItems = new HashSet<ItemStack>();
    static Map<ItemStack, Float> temperatureItems = new HashMap<ItemStack, Float>();
    static Map<ItemStack, Float> humidityItems = new HashMap<ItemStack, Float>();
    static Map<ItemStack, IAlleleFlowers> flowerItems = new HashMap<ItemStack, IAlleleFlowers>();

    public static void addTemperatureItem(ItemStack itemstack, float amount) {
        if (itemstack == null) {
            return;
        }
        if (acclimatiserItems.add(itemstack)) {
            // empty if block
        }
        temperatureItems.put(itemstack, Float.valueOf(amount));
    }

    public static void addFlowerItem(ItemStack itemstack, IAlleleFlowers allele) {
        if (itemstack == null) {
            return;
        }
        if (acclimatiserItems.add(itemstack)) {
            // empty if block
        }
        flowerItems.put(itemstack, allele);
    }

    public static void addHumidityItem(ItemStack itemstack, float amount) {
        if (itemstack == null) {
            return;
        }
        if (acclimatiserItems.add(itemstack)) {
            // empty if block
        }
        humidityItems.put(itemstack, Float.valueOf(amount));
    }

    public static boolean isAcclimatiserItem(ItemStack item) {
        if (item == null) {
            return false;
        }
        for (ItemStack stack : acclimatiserItems) {
            if (!stack.func_77969_a(item)) continue;
            return true;
        }
        return false;
    }

    public static float getTemperatureEffect(ItemStack item) {
        for (ItemStack stack : temperatureItems.keySet()) {
            if (!stack.func_77969_a(item)) continue;
            return temperatureItems.get(stack).floatValue();
        }
        return 0.0f;
    }

    public static float getHumidityEffect(ItemStack item) {
        for (ItemStack stack : humidityItems.keySet()) {
            if (!stack.func_77969_a(item)) continue;
            return humidityItems.get(stack).floatValue();
        }
        return 0.0f;
    }

    public static IAlleleFlowers getFlowerAllele(ItemStack item) {
        for (ItemStack stack : flowerItems.keySet()) {
            if (!stack.func_77969_a(item)) continue;
            return flowerItems.get(stack);
        }
        return null;
    }

    public static void postInit() {
        LogicAcclimatiser.addTemperatureItem(new ItemStack(Item.field_77722_bw), 0.5f);
        LogicAcclimatiser.addTemperatureItem(new ItemStack(Item.field_77731_bo), 0.75f);
        LogicAcclimatiser.addTemperatureItem(new ItemStack(Item.field_77775_ay), 0.75f);
        LogicAcclimatiser.addTemperatureItem(new ItemStack(Item.field_77768_aD), -0.15f);
        LogicAcclimatiser.addTemperatureItem(new ItemStack(Block.field_72036_aT), -0.75f);
        LogicAcclimatiser.addHumidityItem(new ItemStack(Item.field_77786_ax), 0.75f);
        LogicAcclimatiser.addHumidityItem(new ItemStack(Block.field_71939_E), -0.15f);
        LogicAcclimatiser.addTemperatureItem(ItemInterface.getItem((String)"canLava"), 0.75f);
        LogicAcclimatiser.addTemperatureItem(ItemInterface.getItem((String)"refractoryLava"), 0.75f);
        LogicAcclimatiser.addHumidityItem(ItemInterface.getItem((String)"canWater"), 0.75f);
        LogicAcclimatiser.addHumidityItem(ItemInterface.getItem((String)"refractoryWater"), 0.75f);
        LogicAcclimatiser.addHumidityItem(ItemInterface.getItem((String)"waxCapsuleWater"), 0.75f);
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            ItemStack[] flowers;
            if (!(allele instanceof IAlleleFlowers) || (flowers = ((IAlleleFlowers)allele).getProvider().getItemStacks()) == null) continue;
            for (ItemStack item : flowers) {
                LogicAcclimatiser.addFlowerItem(item, (IAlleleFlowers)allele);
            }
        }
    }

    public static Type getType(ItemStack itemStack) {
        if (LogicAcclimatiser.getFlowerAllele(itemStack) != null) {
            return Type.Flower;
        }
        if (LogicAcclimatiser.getTemperatureEffect(itemStack) != 0.0f) {
            return Type.Temperature;
        }
        return Type.Humidity;
    }

    public static boolean canAcclimatise(ItemStack beeStack, ItemStack itemStack) {
        if (beeStack == null || itemStack == null) {
            return false;
        }
        if (!LogicAcclimatiser.isAcclimatiserItem(itemStack)) {
            return false;
        }
        Type type = LogicAcclimatiser.getType(itemStack);
        IBee bee = BinnieGenetics.getBeeRoot().getMember(beeStack);
        IBeeGenome genome = bee.getGenome();
        int[] temperatureTolerance = LogicAcclimatiser.toleranceToInt(genome.getToleranceTemp());
        int[] humidityTolerance = LogicAcclimatiser.toleranceToInt(genome.getToleranceHumid());
        switch (type) {
            case Temperature: {
                float effect = LogicAcclimatiser.getTemperatureEffect(itemStack);
                if (effect > 0.0f && temperatureTolerance[1] < 5) {
                    return true;
                }
                return effect < 0.0f && temperatureTolerance[0] > -5;
            }
            case Humidity: {
                float effect = LogicAcclimatiser.getHumidityEffect(itemStack);
                if (effect > 0.0f && humidityTolerance[1] < 5) {
                    return true;
                }
                return effect < 0.0f && humidityTolerance[0] > -5;
            }
            case Flower: {
                IFlowerProvider b;
                if (LogicAcclimatiser.getFlowerAllele(itemStack) == null) break;
                IFlowerProvider a = LogicAcclimatiser.getFlowerAllele(itemStack).getProvider();
                return a != (b = genome.getFlowerProvider());
            }
        }
        return false;
    }

    public static void alterAllele(ItemStack beeStack, EnumBeeChromosome chromosome, int allele, String UID) {
        if (beeStack == null) {
            return;
        }
        int chromsomeID = chromosome.ordinal() >= EnumBeeChromosome.HUMIDITY.ordinal() ? chromosome.ordinal() - 1 : chromosome.ordinal();
        NBTTagCompound beeNBT = beeStack.func_77978_p();
        NBTTagCompound genomeNBT = beeNBT.func_74775_l("Genome");
        NBTTagList chromosomes = genomeNBT.func_74761_m("Chromosomes");
        NBTTagCompound chromosomeNBT = (NBTTagCompound)chromosomes.func_74743_b(chromsomeID);
        chromosomeNBT.func_74778_a("UID" + allele, UID);
        beeStack.func_77982_d(beeNBT);
    }

    public static void acclimatise(World worldObj, ItemStack beeStack, ItemStack itemStack) {
        if (!BinnieCore.proxy.isDebug() && worldObj.field_73012_v.nextFloat() > 0.2f) {
            return;
        }
        Random rand = new Random();
        if (beeStack == null || itemStack == null) {
            return;
        }
        if (!LogicAcclimatiser.isAcclimatiserItem(itemStack)) {
            return;
        }
        Type type = LogicAcclimatiser.getType(itemStack);
        IBee bee = BinnieGenetics.getBeeRoot().getMember(beeStack);
        IBeeGenome genome = bee.getGenome();
        int[] temperatureTolerance = LogicAcclimatiser.toleranceToInt(genome.getToleranceTemp());
        int[] humidityTolerance = LogicAcclimatiser.toleranceToInt(genome.getToleranceHumid());
        switch (type) {
            case Temperature: 
            case Humidity: {
                float effect;
                float f = effect = type == Type.Humidity ? LogicAcclimatiser.getHumidityEffect(itemStack) : LogicAcclimatiser.getTemperatureEffect(itemStack);
                if (!BinnieCore.proxy.isDebug() && worldObj.field_73012_v.nextFloat() > Math.abs(effect)) {
                    return;
                }
                int[] range = LogicAcclimatiser.alterTolerance(type == Type.Humidity ? humidityTolerance : temperatureTolerance, effect);
                if (!BinnieCore.proxy.isDebug() && worldObj.field_73012_v.nextFloat() > 1.0f / (-((float)range[0]) + (float)range[1])) {
                    return;
                }
                IAllele allele = LogicAcclimatiser.toleranceToAllele(LogicAcclimatiser.rangeToTolerance(range));
                LogicAcclimatiser.alterAllele(beeStack, type == Type.Humidity ? EnumBeeChromosome.HUMIDITY_TOLERANCE : EnumBeeChromosome.TEMPERATURE_TOLERANCE, 0, allele.getUID());
                LogicAcclimatiser.alterAllele(beeStack, type == Type.Humidity ? EnumBeeChromosome.HUMIDITY_TOLERANCE : EnumBeeChromosome.TEMPERATURE_TOLERANCE, 1, allele.getUID());
            }
            case Flower: {
                if (LogicAcclimatiser.getFlowerAllele(itemStack) == null) {
                    return;
                }
                IAllele primary = genome.getChromosomes()[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()].getPrimaryAllele();
                IAllele secondary = genome.getChromosomes()[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()].getPrimaryAllele();
                IAlleleFlowers flowerPrimary = (IAlleleFlowers)primary;
                IAlleleFlowers flowerSecondary = (IAlleleFlowers)secondary;
                IAlleleFlowers itemFlower = LogicAcclimatiser.getFlowerAllele(itemStack);
                if (flowerPrimary != itemFlower && rand.nextDouble() < LogicAcclimatiser.getFlowerChance()) {
                    flowerPrimary = itemFlower;
                }
                if (flowerSecondary != itemFlower && rand.nextDouble() < LogicAcclimatiser.getFlowerChance()) {
                    flowerSecondary = itemFlower;
                }
                LogicAcclimatiser.alterAllele(beeStack, EnumBeeChromosome.FLOWER_PROVIDER, 0, flowerPrimary.getUID());
                LogicAcclimatiser.alterAllele(beeStack, EnumBeeChromosome.FLOWER_PROVIDER, 1, flowerSecondary.getUID());
            }
        }
    }

    private static int[] alterTolerance(int[] is, float effect) {
        if (effect < 0.0f) {
            return new int[]{is[0] - 1, is[1]};
        }
        return new int[]{is[0], is[1] + 1};
    }

    private static double getFlowerChance() {
        if (BinnieCore.proxy.isDebug()) {
            return 2.0;
        }
        return 0.5;
    }

    public static IAllele[] getAlleles(IChromosome chromosome) {
        return new IAllele[]{chromosome.getPrimaryAllele(), chromosome.getSecondaryAllele()};
    }

    public static int[] toleranceToInt(EnumTolerance tolerance) {
        switch (tolerance) {
            case DOWN_5: {
                return new int[]{-5, 0};
            }
            case DOWN_4: {
                return new int[]{-4, 0};
            }
            case DOWN_3: {
                return new int[]{-3, 0};
            }
            case DOWN_2: {
                return new int[]{-2, 0};
            }
            case DOWN_1: {
                return new int[]{-1, 0};
            }
            case UP_1: {
                return new int[]{0, 1};
            }
            case UP_2: {
                return new int[]{0, 2};
            }
            case UP_3: {
                return new int[]{0, 3};
            }
            case UP_4: {
                return new int[]{0, 4};
            }
            case UP_5: {
                return new int[]{0, 5};
            }
            case BOTH_1: {
                return new int[]{-1, 1};
            }
            case BOTH_2: {
                return new int[]{-2, 2};
            }
            case BOTH_3: {
                return new int[]{-3, 3};
            }
            case BOTH_4: {
                return new int[]{-4, 4};
            }
            case BOTH_5: {
                return new int[]{-5, 5};
            }
        }
        return new int[]{0, 0};
    }

    public static EnumTolerance rangeToTolerance(int[] range) {
        if (range[0] < -5) {
            range[0] = -5;
        }
        if (range[1] > 5) {
            range[1] = 5;
        }
        EnumTolerance[] up = new EnumTolerance[]{EnumTolerance.NONE, EnumTolerance.UP_1, EnumTolerance.UP_2, EnumTolerance.UP_3, EnumTolerance.UP_4, EnumTolerance.UP_5};
        EnumTolerance[] down = new EnumTolerance[]{EnumTolerance.NONE, EnumTolerance.DOWN_1, EnumTolerance.DOWN_2, EnumTolerance.DOWN_3, EnumTolerance.DOWN_4, EnumTolerance.DOWN_5};
        EnumTolerance[] both = new EnumTolerance[]{EnumTolerance.NONE, EnumTolerance.BOTH_1, EnumTolerance.BOTH_2, EnumTolerance.BOTH_3, EnumTolerance.BOTH_4, EnumTolerance.BOTH_5};
        if (range[0] == 0) {
            return up[range[1]];
        }
        if (range[1] == 0) {
            return down[-range[0]];
        }
        int avg = (int)((float)(-range[0] + range[1]) / 2.0f + 0.6f);
        return both[avg];
    }

    public static IAllele toleranceToAllele(EnumTolerance tolerance) {
        switch (tolerance) {
            case DOWN_5: {
                return AlleleManager.alleleRegistry.getAllele("forestry.toleranceDown5");
            }
            case DOWN_4: {
                return AlleleManager.alleleRegistry.getAllele("forestry.toleranceDown4");
            }
            case DOWN_3: {
                return AlleleManager.alleleRegistry.getAllele("forestry.toleranceDown3");
            }
            case DOWN_2: {
                return AlleleManager.alleleRegistry.getAllele("forestry.toleranceDown2");
            }
            case DOWN_1: {
                return AlleleManager.alleleRegistry.getAllele("forestry.toleranceDown1");
            }
            case UP_1: {
                return AlleleManager.alleleRegistry.getAllele("forestry.toleranceUp1");
            }
            case UP_2: {
                return AlleleManager.alleleRegistry.getAllele("forestry.toleranceUp2");
            }
            case UP_3: {
                return AlleleManager.alleleRegistry.getAllele("forestry.toleranceUp3");
            }
            case UP_4: {
                return AlleleManager.alleleRegistry.getAllele("forestry.toleranceUp4");
            }
            case UP_5: {
                return AlleleManager.alleleRegistry.getAllele("forestry.toleranceUp5");
            }
            case BOTH_1: {
                return AlleleManager.alleleRegistry.getAllele("forestry.toleranceBoth1");
            }
            case BOTH_2: {
                return AlleleManager.alleleRegistry.getAllele("forestry.toleranceBoth2");
            }
            case BOTH_3: {
                return AlleleManager.alleleRegistry.getAllele("forestry.toleranceBoth3");
            }
            case BOTH_4: {
                return AlleleManager.alleleRegistry.getAllele("forestry.toleranceBoth4");
            }
            case BOTH_5: {
                return AlleleManager.alleleRegistry.getAllele("forestry.toleranceBoth5");
            }
        }
        return AlleleManager.alleleRegistry.getAllele("forestry.toleranceNone");
    }

    static enum Type {
        Temperature,
        Humidity,
        Flower;

    }
}

