/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.liquids;

import binnie.core.BinnieCore;
import binnie.core.liquid.LiquidManager;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.liquids.ItemCast;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.ItemInterface;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class ItemMoltenMetal
extends Item {
    public static int ITEM_ID;
    static int ingotAmount;
    static int blockAmount;
    static int nineblockAmount;

    public int func_82790_a(ItemStack itemStack, int par2) {
        return MoltenMetal.values()[itemStack.func_77960_j()].getColour();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister register) {
        this.field_77791_bV = ExtraBees.proxy.getIcon(register, "liquids/molten");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < MoltenMetal.values().length; ++i) {
            par3List.add(new ItemStack(this.field_77779_bT, 1, i));
        }
    }

    public String func_77628_j(ItemStack itemStack) {
        if (itemStack == null) {
            return "Molten Metal";
        }
        return "Molten " + MoltenMetal.values()[itemStack.func_77960_j()].toString();
    }

    public ItemMoltenMetal(int id) {
        super(id);
        ITEM_ID = this.field_77779_bT;
        this.field_77787_bX = true;
        this.func_77637_a(CreativeTabs.field_78035_l);
        this.func_77655_b("moltenMetal");
    }

    public static void setupMoltenLiquids() {
        block13: for (MoltenMetal liquid : MoltenMetal.values()) {
            BinnieCore.proxy.registerLiquid(liquid.getMoltenName(), ITEM_ID, liquid.ordinal());
            ItemStack tinGear = ItemInterface.getItem((String)"gearTin");
            ItemStack copperGear = ItemInterface.getItem((String)"gearCopper");
            ItemStack bronzeGear = ItemInterface.getItem((String)"gearBronze");
            ItemStack stoneGear = new ItemStack(Block.field_71978_w);
            ItemStack ironGear = new ItemStack(Item.field_77703_o);
            ItemStack goldGear = new ItemStack(Item.field_77717_p);
            ItemStack diamondGear = new ItemStack(Item.field_77702_n);
            try {
                stoneGear = new ItemStack((Item)Class.forName("buildcraft.BuildCraftCore").getField("stoneGearItem").get(null));
                ironGear = new ItemStack((Item)Class.forName("buildcraft.BuildCraftCore").getField("ironGearItem").get(null));
                goldGear = new ItemStack((Item)Class.forName("buildcraft.BuildCraftCore").getField("goldGearItem").get(null));
                diamondGear = new ItemStack((Item)Class.forName("buildcraft.BuildCraftCore").getField("diamondGearItem").get(null));
            }
            catch (Exception ex) {
                FMLLog.fine((String)"No BuildCraft gears found.", (Object[])new Object[0]);
                return;
            }
            switch (liquid) {
                case Iron: {
                    liquid.addFabricatorRecipe(new ItemStack(Item.field_77703_o), ingotAmount);
                    liquid.addFabricatorRecipe(new ItemStack(Block.field_72083_ai), nineblockAmount);
                    liquid.addCastRecipe(new ItemStack((Item)Item.field_77812_ad), ItemCast.CastType.Helmet);
                    liquid.addCastRecipe(new ItemStack((Item)Item.field_77822_ae), ItemCast.CastType.Chestplate);
                    liquid.addCastRecipe(new ItemStack((Item)Item.field_77824_af), ItemCast.CastType.Legging);
                    liquid.addCastRecipe(new ItemStack((Item)Item.field_77818_ag), ItemCast.CastType.Boots);
                    liquid.addCastRecipe(new ItemStack(Item.field_77708_h), ItemCast.CastType.Axe);
                    liquid.addCastRecipe(new ItemStack(Item.field_77696_g), ItemCast.CastType.Pickaxe);
                    liquid.addCastRecipe(new ItemStack(Item.field_77695_f), ItemCast.CastType.Shovel);
                    liquid.addCastRecipe(new ItemStack(Item.field_77689_P), ItemCast.CastType.Hoe);
                    liquid.addCastRecipe(new ItemStack(Block.field_72083_ai), ItemCast.CastType.Block);
                    liquid.addGearRecipe(ironGear, stoneGear);
                    continue block13;
                }
                case Bronze: {
                    for (ItemStack ingot : OreDictionary.getOres((String)"ingotBronze")) {
                        liquid.addFabricatorRecipe(ingot, ingotAmount);
                    }
                    liquid.addCastRecipe(ItemInterface.getItem((String)"bronzePickaxe"), ItemCast.CastType.Pickaxe);
                    liquid.addCastRecipe(ItemInterface.getItem((String)"bronzeShovel"), ItemCast.CastType.Shovel);
                    liquid.addGearRecipe(bronzeGear, stoneGear);
                    continue block13;
                }
                case Copper: {
                    for (ItemStack ingot : OreDictionary.getOres((String)"ingotCopper")) {
                        liquid.addFabricatorRecipe(ingot, ingotAmount);
                    }
                    liquid.addGearRecipe(copperGear, stoneGear);
                    continue block13;
                }
                case Diamond: {
                    liquid.addFabricatorRecipe(new ItemStack(Item.field_77702_n), ingotAmount);
                    liquid.addFabricatorRecipe(new ItemStack(Block.field_72071_ax), nineblockAmount);
                    liquid.addCastRecipe(new ItemStack((Item)Item.field_77820_ah), ItemCast.CastType.Helmet);
                    liquid.addCastRecipe(new ItemStack((Item)Item.field_77798_ai), ItemCast.CastType.Chestplate);
                    liquid.addCastRecipe(new ItemStack((Item)Item.field_77800_aj), ItemCast.CastType.Legging);
                    liquid.addCastRecipe(new ItemStack((Item)Item.field_77794_ak), ItemCast.CastType.Boots);
                    liquid.addCastRecipe(new ItemStack(Item.field_77675_C), ItemCast.CastType.Axe);
                    liquid.addCastRecipe(new ItemStack(Item.field_77674_B), ItemCast.CastType.Pickaxe);
                    liquid.addCastRecipe(new ItemStack(Item.field_77673_A), ItemCast.CastType.Shovel);
                    liquid.addCastRecipe(new ItemStack(Item.field_77688_Q), ItemCast.CastType.Hoe);
                    liquid.addCastRecipe(new ItemStack(Block.field_72071_ax), ItemCast.CastType.Block);
                    liquid.addGearRecipe(diamondGear, goldGear);
                    continue block13;
                }
                case Emerald: {
                    liquid.addFabricatorRecipe(new ItemStack(Item.field_77817_bH), ingotAmount);
                    liquid.addFabricatorRecipe(new ItemStack(Block.field_72076_bV), nineblockAmount);
                    continue block13;
                }
                case Gold: {
                    liquid.addFabricatorRecipe(new ItemStack(Item.field_77717_p), ingotAmount);
                    liquid.addFabricatorRecipe(new ItemStack(Block.field_72105_ah), nineblockAmount);
                    liquid.addCastRecipe(new ItemStack((Item)Item.field_77796_al), ItemCast.CastType.Helmet);
                    liquid.addCastRecipe(new ItemStack((Item)Item.field_77806_am), ItemCast.CastType.Chestplate);
                    liquid.addCastRecipe(new ItemStack((Item)Item.field_77808_an), ItemCast.CastType.Legging);
                    liquid.addCastRecipe(new ItemStack((Item)Item.field_77802_ao), ItemCast.CastType.Boots);
                    liquid.addCastRecipe(new ItemStack(Item.field_77682_J), ItemCast.CastType.Axe);
                    liquid.addCastRecipe(new ItemStack(Item.field_77681_I), ItemCast.CastType.Pickaxe);
                    liquid.addCastRecipe(new ItemStack(Item.field_77680_H), ItemCast.CastType.Shovel);
                    liquid.addCastRecipe(new ItemStack(Item.field_77691_R), ItemCast.CastType.Hoe);
                    liquid.addCastRecipe(new ItemStack(Block.field_72105_ah), ItemCast.CastType.Block);
                    liquid.addGearRecipe(goldGear, ironGear);
                    continue block13;
                }
                case Obsidian: {
                    liquid.addFabricatorRecipe(new ItemStack(Block.field_72089_ap), blockAmount);
                    continue block13;
                }
                case Silver: {
                    for (ItemStack ingot : OreDictionary.getOres((String)"ingotSilver")) {
                        liquid.addFabricatorRecipe(ingot, ingotAmount);
                    }
                    continue block13;
                }
                case Tin: {
                    for (ItemStack ingot : OreDictionary.getOres((String)"ingotTin")) {
                        liquid.addFabricatorRecipe(ingot, ingotAmount);
                    }
                    liquid.addGearRecipe(tinGear, stoneGear);
                    continue block13;
                }
            }
        }
    }

    static {
        ingotAmount = 100;
        blockAmount = 400;
        nineblockAmount = 900;
    }

    public static enum MoltenMetal {
        Iron(150, 150, 150, 2000, 0.7f),
        Copper(210, 141, 77, 1400, 0.8f),
        Tin(192, 221, 233, 250, 0.9f),
        Bronze(207, 167, 56, 1200, 0.8f),
        Silver(192, 204, 217, 1200, 0.8f),
        Gold(235, 235, 20, 1400, 0.8f),
        Diamond(140, 235, 226, 4500, 0.6f),
        Emerald(23, 221, 98, 2800, 0.7f),
        Obsidian(56, 48, 80, 1400, 0.8f);

        public int red;
        public int blue;
        public int green;
        public int mp;
        public float mult;

        private MoltenMetal(int r, int g, int b, int mp, float m) {
            this.red = r;
            this.green = g;
            this.blue = b;
            this.mult = m;
            this.mp = mp;
        }

        public int getColour() {
            return this.red * 256 * 256 + this.green * 256 + this.blue;
        }

        public void addGearRecipe(ItemStack gear, ItemStack gearBase) {
        }

        public void addCastRecipe(ItemStack item, ItemCast.CastType type) {
        }

        public FluidStack getLiquidStack(int amount) {
            return LiquidManager.getLiquidStack(this.getMoltenName(), amount);
        }

        public void addFabricatorRecipe(ItemStack item, int amount) {
        }

        String getMoltenName() {
            return "molten" + this.toString();
        }
    }
}

