/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics.effect;

import binnie.core.liquid.LiquidManager;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.genetics.EnumExtraBeeFlowers;
import binnie.extrabees.genetics.effect.EntityBeeLightning;
import binnie.extrabees.genetics.effect.FireworkCreator;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cpw.mods.fml.common.FMLLog;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IArmorApiarist;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IEffectData;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public enum EnumExtraBeeEffect implements IAlleleBeeEffect
{
    ECTOPLASM("Ectoplasm"),
    ACID("Acidic"),
    SPAWN_ZOMBIE("Zombies"),
    SPAWN_SKELETON("Skeletons"),
    SPAWN_CREEPER("Creepers"),
    LIGHTNING("Lightning"),
    RADIOACTIVE("Unstable"),
    METEOR("Meteor"),
    HUNGER("Hunger"),
    FOOD("Nourishment"),
    BLINDNESS("Darkness"),
    CONFUSION("Confusion"),
    FIREWORKS("Fireworks"),
    FESTIVAL("Festival"),
    BIRTHDAY("Birthday"),
    TELEPORT("Teleport"),
    GRAVITY("Gravity"),
    THIEF("Antigravity"),
    WITHER("Wither"),
    WATER("Water"),
    SLOW("Slowness"),
    BonemalSapling("Growth"),
    BonemealFruit("Ripening"),
    BonemealMushroom("Mushroom"),
    Power("Power");

    String fx = "";
    public boolean combinable;
    public String name;
    public boolean dominant;
    public int id;
    private String uid;
    public static Method FX;
    static List<Birthday> birthdays;

    private EnumExtraBeeEffect(String name) {
        this.name = name;
        this.uid = this.toString().toLowerCase();
        this.combinable = false;
        name = "??? Effect";
        this.dominant = true;
    }

    public static void doInit() {
        FMLLog.getLogger().fine("Trying to implement forestry hive fx...");
        try {
            FX = Class.forName("forestry.apiculture.ProxyApiculture").getMethod("addBeeHiveFX", String.class, World.class, Double.TYPE, Double.TYPE, Double.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            FMLLog.getLogger().fine("Succeeded.");
        }
        catch (Exception ex) {
            FMLLog.getLogger().fine("Failed: " + ex.getMessage());
        }
        BLINDNESS.setFX("blindness");
        FOOD.setFX("food");
        GRAVITY.setFX("gravity");
        THIEF.setFX("gravity");
        TELEPORT.setFX("gravity");
        LIGHTNING.setFX("lightning");
        METEOR.setFX("meteor");
        RADIOACTIVE.setFX("radioactive");
        WATER.setFX("water");
        WITHER.setFX("wither");
        for (EnumExtraBeeEffect effect : EnumExtraBeeEffect.values()) {
            effect.register();
        }
    }

    private void setFX(String string) {
        this.fx = "particles/" + string;
    }

    public void register() {
        AlleleManager.alleleRegistry.registerAllele((IAllele)this);
    }

    public boolean isCombinable() {
        return this.combinable;
    }

    public IEffectData validateStorage(IEffectData storedData) {
        return storedData;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public void spawnMob(World world, int x, int y, int z, String name) {
        if (this.anyPlayerInRange(world, x, y, z, 16)) {
            double var1 = (float)x + world.field_73012_v.nextFloat();
            double var3 = (float)y + world.field_73012_v.nextFloat();
            double var5 = (float)z + world.field_73012_v.nextFloat();
            world.func_72869_a("smoke", var1, var3, var5, 0.0, 0.0, 0.0);
            world.func_72869_a("flame", var1, var3, var5, 0.0, 0.0, 0.0);
            EntityLiving var9 = (EntityLiving)EntityList.func_75620_a((String)name, (World)world);
            if (var9 == null) {
                return;
            }
            int var10 = world.func_72872_a(var9.getClass(), AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b(8.0, 4.0, 8.0)).size();
            if (var10 >= 6) {
                return;
            }
            if (var9 != null) {
                double var11 = (double)x + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * 4.0;
                double var13 = y + world.field_73012_v.nextInt(3) - 1;
                double var15 = (double)z + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * 4.0;
                var9.func_70012_b(var11, var13, var15, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (var9.func_70601_bi()) {
                    world.func_72838_d((Entity)var9);
                    world.func_72926_e(2004, x, y, z, 0);
                    var9.func_70656_aK();
                }
            }
        }
    }

    private boolean anyPlayerInRange(World world, int x, int y, int z, int distance) {
        return world.func_72977_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, (double)distance) != null;
    }

    public static void doAcid(World world, int x, int y, int z) {
        int id = world.func_72798_a(x, y, z);
        if (id == Block.field_71978_w.field_71990_ca || id == Block.field_71981_t.field_71990_ca) {
            world.func_72832_d(x, y, z, Block.field_71940_F.field_71990_ca, 0, 0);
        } else if (id == Block.field_71979_v.field_71990_ca | id == Block.field_71980_u.field_71990_ca) {
            world.func_72832_d(x, y, z, Block.field_71939_E.field_71990_ca, 0, 0);
        }
    }

    public String getUID() {
        return "extrabees.effect." + this.uid;
    }

    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        int xHouse = housing.getXCoord();
        int yHouse = housing.getYCoord();
        int zHouse = housing.getZCoord();
        int[] area = this.getModifiedArea(genome, housing);
        int xd = 1 + area[0] / 2;
        int yd = 1 + area[1] / 2;
        int zd = 1 + area[2] / 2;
        int x1 = xHouse - xd + world.field_73012_v.nextInt(2 * xd + 1);
        int y1 = yHouse - yd + world.field_73012_v.nextInt(2 * yd + 1);
        int z1 = zHouse - zd + world.field_73012_v.nextInt(2 * zd + 1);
        switch (this) {
            case ECTOPLASM: {
                if (world.field_73012_v.nextInt(100) >= 4) break;
                if (world.func_72799_c(x1, y1, z1) && (world.func_72809_s(x1, y1 - 1, z1) || world.func_72798_a(x1, y1 - 1, z1) == ExtraBees.ectoplasm.field_71990_ca)) {
                    world.func_72832_d(x1, y1, z1, ExtraBees.ectoplasm.field_71990_ca, 0, 0);
                }
                return null;
            }
            case ACID: {
                if (world.field_73012_v.nextInt(100) >= 6) break;
                EnumExtraBeeEffect.doAcid(world, x1, y1, z1);
                break;
            }
            case SPAWN_ZOMBIE: {
                if (world.field_73012_v.nextInt(200) >= 2) break;
                this.spawnMob(world, x1, y1, z1, "Zombie");
                break;
            }
            case SPAWN_SKELETON: {
                if (world.field_73012_v.nextInt(200) >= 2) break;
                this.spawnMob(world, x1, y1, z1, "Skeleton");
                break;
            }
            case SPAWN_CREEPER: {
                if (world.field_73012_v.nextInt(200) >= 2) break;
                this.spawnMob(world, x1, y1, z1, "Creeper");
                break;
            }
            case LIGHTNING: {
                if (world.field_73012_v.nextInt(100) >= 1 || !world.func_72937_j(x1, y1, z1) || !(world instanceof WorldServer)) break;
                ((WorldServer)world).func_72942_c((Entity)new EntityBeeLightning(world, x1, y1, z1));
                break;
            }
            case METEOR: {
                if (world.field_73012_v.nextInt(100) >= 1 || !world.func_72937_j(x1, y1, z1)) break;
                ((WorldServer)world).func_72838_d((Entity)new EntitySmallFireball(world, (double)x1, (double)(y1 + 64), (double)z1, 0.0, -0.6, 0.0));
                break;
            }
            case RADIOACTIVE: {
                for (EntityLivingBase entity : this.getEntities(EntityLivingBase.class, genome, housing)) {
                    int damage = 4;
                    if (entity instanceof EntityPlayer) {
                        int count = EnumExtraBeeEffect.wearsItems((EntityPlayer)entity);
                        if (count > 3) continue;
                        if (count > 2) {
                            damage = 1;
                        } else if (count > 1) {
                            damage = 2;
                        } else if (count > 0) {
                            damage = 3;
                        }
                    }
                    entity.func_70097_a(DamageSource.field_76377_j, (float)damage);
                }
                break;
            }
            case FOOD: {
                for (EntityLivingBase entity : this.getEntities(EntityLivingBase.class, genome, housing)) {
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer player = (EntityPlayer)entity;
                    player.func_71024_bL().func_75122_a(2, 0.2f);
                }
                break;
            }
            case HUNGER: {
                for (EntityLivingBase entity : this.getEntities(EntityLivingBase.class, genome, housing)) {
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer player = (EntityPlayer)entity;
                    if (world.field_73012_v.nextInt(4) < EnumExtraBeeEffect.wearsItems(player)) continue;
                    player.func_71024_bL().func_75113_a(4.0f);
                    player.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 100));
                }
                break;
            }
            case BLINDNESS: {
                for (EntityLivingBase entity : this.getEntities(EntityLivingBase.class, genome, housing)) {
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer player = (EntityPlayer)entity;
                    if (world.field_73012_v.nextInt(4) < EnumExtraBeeEffect.wearsItems(player)) continue;
                    player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 200));
                }
                break;
            }
            case SLOW: {
                for (EntityLivingBase entity : this.getEntities(EntityLivingBase.class, genome, housing)) {
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer player = (EntityPlayer)entity;
                    if (world.field_73012_v.nextInt(4) < EnumExtraBeeEffect.wearsItems(player)) continue;
                    player.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 200));
                }
                break;
            }
            case CONFUSION: {
                for (EntityLivingBase entity : this.getEntities(EntityLivingBase.class, genome, housing)) {
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer player = (EntityPlayer)entity;
                    if (world.field_73012_v.nextInt(4) < EnumExtraBeeEffect.wearsItems(player)) continue;
                    player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 200));
                }
                break;
            }
            case BIRTHDAY: 
            case FESTIVAL: 
            case FIREWORKS: {
                if (world.field_73012_v.nextInt(this == FIREWORKS ? 8 : 12) >= 1) break;
                FireworkCreator.Firework firework = new FireworkCreator.Firework();
                block25 : switch (this) {
                    case BIRTHDAY: {
                        firework.setShape(FireworkCreator.Shape.Star);
                        firework.addColor(0xFFDD00);
                        for (Birthday birthday : birthdays) {
                            if (!birthday.isToday()) continue;
                            firework.addColor(0xFF0000);
                            firework.addColor(65280);
                            firework.addColor(255);
                            firework.setTrail();
                            break block25;
                        }
                        break;
                    }
                    case FESTIVAL: {
                        break;
                    }
                    case FIREWORKS: {
                        firework.setShape(FireworkCreator.Shape.Ball);
                        firework.addColor(genome.getPrimary().getIconColour(0));
                        firework.addColor(genome.getPrimary().getIconColour(0));
                        firework.addColor(genome.getPrimary().getIconColour(1));
                        firework.addColor(genome.getSecondary().getIconColour(0));
                        firework.addColor(genome.getSecondary().getIconColour(0));
                        firework.addColor(genome.getPrimary().getIconColour(1));
                        firework.setTrail();
                        break;
                    }
                }
                EntityFireworkRocket var11 = new EntityFireworkRocket(world, (double)x1, (double)y1, (double)z1, firework.getFirework());
                if (!world.func_72937_j(x1, y1, z1)) break;
                ((WorldServer)world).func_72838_d((Entity)var11);
                break;
            }
            case GRAVITY: {
                List<Entity> entities2 = this.getEntities(Entity.class, genome, housing);
                for (Entity entity : entities2) {
                    double dz;
                    double dy;
                    double dx;
                    float entityStrength = 1.0f;
                    if (entity instanceof EntityPlayer) {
                        entityStrength *= 100.0f;
                    }
                    if ((dx = (double)x1 - entity.field_70165_t) * dx + (dy = (double)y1 - entity.field_70163_u) * dy + (dz = (double)z1 - entity.field_70161_v) * dz < 2.0) {
                        return null;
                    }
                    double strength = 0.5 / (dx * dx + dy * dy + dz * dz) * (double)entityStrength;
                    entity.func_70024_g(dx * strength, dy * strength, dz * strength);
                }
                break;
            }
            case THIEF: {
                List<EntityPlayer> entities3 = this.getEntities(EntityPlayer.class, genome, housing);
                for (EntityPlayer entity : entities3) {
                    double dx = (double)x1 - entity.field_70165_t;
                    double dy = (double)y1 - entity.field_70163_u;
                    double dz = (double)z1 - entity.field_70161_v;
                    if (dx * dx + dy * dy + dz * dz < 2.0) {
                        return null;
                    }
                    double strength = 0.5 / (dx * dx + dy * dy + dz * dz);
                    entity.func_70024_g(-dx * strength, -dy * strength, -dz * strength);
                }
                break;
            }
            case TELEPORT: {
                if (world.field_73012_v.nextInt(80) > 1) {
                    return null;
                }
                List<Entity> entities = this.getEntities(Entity.class, genome, housing);
                if (entities.size() == 0) {
                    return null;
                }
                Entity entity = entities.get(world.field_73012_v.nextInt(entities.size()));
                if (!(entity instanceof EntityLiving)) {
                    return null;
                }
                float jumpDist = 5.0f;
                if (y1 < 4) {
                    y1 = 4;
                }
                if (!world.func_72799_c(x1, y1, z1) || !world.func_72799_c(x1, y1 + 1, z1)) {
                    return null;
                }
                ((EntityLiving)entity).func_70634_a((double)x1, (double)y1, (double)z1);
                ((EntityLiving)entity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 160, 10));
                break;
            }
            case WATER: {
                if (world.field_73012_v.nextInt(120) > 1) {
                    return null;
                }
                TileEntity tile = world.func_72796_p(x1, y1, z1);
                if (!(tile instanceof IFluidHandler)) break;
                ((IFluidHandler)tile).fill(ForgeDirection.UP, LiquidManager.getLiquidStack("water", 100), true);
                break;
            }
            case BonemalSapling: {
                if (world.field_73012_v.nextInt(20) > 1) {
                    return null;
                }
                if (!EnumExtraBeeFlowers.Sapling.isAcceptedFlower(world, null, x1, y1, z1)) break;
                ItemDye.applyBonemeal((ItemStack)new ItemStack(Block.field_71979_v, 1), (World)world, (int)x1, (int)y1, (int)z1, null);
                break;
            }
            case BonemealFruit: {
                if (world.field_73012_v.nextInt(20) > 1) {
                    return null;
                }
                if (!EnumExtraBeeFlowers.Fruit.isAcceptedFlower(world, null, x1, y1, z1)) break;
                ItemDye.applyBonemeal((ItemStack)new ItemStack(Block.field_71979_v, 1), (World)world, (int)x1, (int)y1, (int)z1, null);
                break;
            }
            case BonemealMushroom: {
                if (world.field_73012_v.nextInt(20) > 1) {
                    return null;
                }
                if (world.func_72798_a(x1, y1, z1) != Block.field_72109_af.field_71990_ca && world.func_72798_a(x1, y1, z1) != Block.field_72103_ag.field_71990_ca) break;
                ItemDye.applyBonemeal((ItemStack)new ItemStack(Block.field_71979_v, 1), (World)world, (int)x1, (int)y1, (int)z1, null);
                break;
            }
            case Power: {
                TileEntity tile2 = world.func_72796_p(x1, y1, z1);
                if (!(tile2 instanceof IPowerReceptor) || ((IPowerReceptor)tile2).getPowerReceiver(ForgeDirection.getOrientation((int)0)) == null) break;
                ((IPowerReceptor)tile2).getPowerReceiver(ForgeDirection.getOrientation((int)0)).receiveEnergy(PowerHandler.Type.MACHINE, 0.5f, ForgeDirection.getOrientation((int)0));
                break;
            }
            case WITHER: {
                break;
            }
        }
        return null;
    }

    protected int[] getModifiedArea(IBeeGenome genome, IBeeHousing housing) {
        int[] area = genome.getTerritory();
        area[0] = (int)((float)area[0] * (housing.getTerritoryModifier(genome, 1.0f) * 3.0f));
        area[1] = (int)((float)area[1] * (housing.getTerritoryModifier(genome, 1.0f) * 3.0f));
        area[2] = (int)((float)area[2] * (housing.getTerritoryModifier(genome, 1.0f) * 3.0f));
        if (area[0] < 1) {
            area[0] = 1;
        }
        if (area[1] < 1) {
            area[1] = 1;
        }
        if (area[2] < 1) {
            area[2] = 1;
        }
        return area;
    }

    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        int x = housing.getXCoord();
        int y = housing.getYCoord();
        int z = housing.getZCoord();
        int[] area = this.getModifiedArea(genome, housing);
        try {
            if (this.fx.length() == 0 || world.field_73012_v.nextBoolean()) {
                FX.invoke(null, "particles/swarm_bee", world, x, y, z, genome.getPrimary().getIconColour(0), area[0], area[1], area[2]);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return storedData;
    }

    public String getFX() {
        return this.fx;
    }

    public <T extends Entity> List<T> getEntities(Class<T> eClass, IBeeGenome genome, IBeeHousing housing) {
        int[] area = genome.getTerritory();
        int[] offset = new int[]{-Math.round(area[0] / 2), -Math.round(area[1] / 2), -Math.round(area[2] / 2)};
        int[] min = new int[]{housing.getXCoord() + offset[0], housing.getYCoord() + offset[1], housing.getZCoord() + offset[2]};
        int[] max = new int[]{housing.getXCoord() + offset[0] + area[0], housing.getYCoord() + offset[1] + area[1], housing.getZCoord() + offset[2] + area[2]};
        AxisAlignedBB box = AxisAlignedBB.func_72332_a().func_72299_a((double)min[0], (double)min[1], (double)min[2], (double)max[0], (double)max[1], (double)max[2]);
        return housing.getWorld().func_72872_a(eClass, box);
    }

    public static boolean wearsHelmet(EntityPlayer player) {
        ItemStack armorItem = player.field_71071_by.field_70460_b[3];
        return armorItem != null && armorItem.func_77973_b() instanceof IArmorApiarist;
    }

    public static boolean wearsChest(EntityPlayer player) {
        ItemStack armorItem = player.field_71071_by.field_70460_b[2];
        return armorItem != null && armorItem.func_77973_b() instanceof IArmorApiarist;
    }

    public static boolean wearsLegs(EntityPlayer player) {
        ItemStack armorItem = player.field_71071_by.field_70460_b[1];
        return armorItem != null && armorItem.func_77973_b() instanceof IArmorApiarist;
    }

    public static boolean wearsBoots(EntityPlayer player) {
        ItemStack armorItem = player.field_71071_by.field_70460_b[0];
        return armorItem != null && armorItem.func_77973_b() instanceof IArmorApiarist;
    }

    public static int wearsItems(EntityPlayer player) {
        int count = 0;
        if (EnumExtraBeeEffect.wearsHelmet(player)) {
            ++count;
        }
        if (EnumExtraBeeEffect.wearsChest(player)) {
            ++count;
        }
        if (EnumExtraBeeEffect.wearsLegs(player)) {
            ++count;
        }
        if (EnumExtraBeeEffect.wearsBoots(player)) {
            ++count;
        }
        return count;
    }

    static {
        birthdays = new ArrayList<Birthday>();
        birthdays.add(new Birthday(3, 10, "Binnie"));
    }

    public static class Birthday {
        int day;
        int month;
        String name;

        public boolean isToday() {
            return Calendar.getInstance().get(5) == this.month && Calendar.getInstance().get(2) == this.day;
        }

        public String getName() {
            return this.name;
        }

        private Birthday(int day, int month, String name) {
            this.day = day;
            this.month = month + 1;
            this.name = name;
        }
    }
}

