/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics;

import binnie.core.BinnieCore;
import binnie.core.genetics.BinnieGenetics;
import binnie.core.item.IItemEnum;
import binnie.extrabees.genetics.EnumExtraBeeFlowers;
import binnie.extrabees.genetics.effect.EnumExtraBeeEffect;
import binnie.extrabees.products.EnumHoneyComb;
import binnie.extrabees.products.ItemHoneyComb;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IIconProvider;
import forestry.api.core.ItemInterface;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public enum EnumExtraBeeSpecies implements IAlleleBeeSpecies,
IIconProvider
{
    ARID("Arid", "aridus", 12511316),
    BARREN("Barren", "infelix", 14733923),
    DESOLATE("Desolate", "desolo", 13744272),
    GNAWING("Gnawing", "apica", 15234224),
    ROTTEN("Decaying", "caries", 12574902),
    BONE("Skeletal", "os", 15330792),
    CREEPER("Creepy", "erepo", 2942485),
    DECOMPOSING("Decomposing", "aegrus", 5388049),
    ROCK("Rocky", "saxum", 0xA8A8A8),
    STONE("Tolerant", "lapis", 0x757575),
    GRANITE("Robust", "granum", 0x695555),
    MINERAL("Resilient", "minerale", 7239037),
    COPPER("Corroded", "cuprous", 13722376),
    TIN("Tarnished", "stannus", 0xBDB1BD),
    IRON("Rusty", "ferrous", 11038808),
    LEAD("Leaden", "plumbous", 11373483),
    ZINC("Galvanized", "spelta", 15592447),
    TITANIUM("Impregnable", "titania", 11578083),
    BRONZE("Resolute", "pyropus", 13926677),
    BRASS("Brazen", "braza", 16768343),
    STEEL("Fortified", "stela", 0x333238),
    TUNGSTATE("Invincible", "wolfram", 1249812),
    GOLD("Glittering", "aureus", 15125515),
    SILVER("Shining", "argentus", 0xDBDBDB),
    ELECTRUM("Precious", "electra", 16247708),
    PLATINUM("Valuable", "platina", 0xDBDBDB),
    LAPIS("Lapis", "lazuli", 4009179),
    SODALITE("Sodalite", "soda", 1396717),
    PYRITE("Pyrite", "pyrus", 14919481),
    BAUXITE("Bauxite", "bauxus", 10249472),
    CINNABAR("Cinnabar", "cinna", 4665867),
    SPHALERITE("Sphalerite", "spahleri", 14406941),
    EMERALD("Emerald", "emerala", 1900291),
    RUBY("Ruby", "ruba", 0xD60000),
    SAPPHIRE("Sapphire", "saphhira", 673791),
    OLIVINE("Olivine", "olivia", 8060779),
    DIAMOND("Diamond", "diama", 8371706),
    UNSTABLE("Unstable", "levis", 4099124),
    NUCLEAR("Nuclear", "nucleus", 4312111),
    RADIOACTIVE("Radioactive", "fervens", 2031360),
    ANCIENT("Ancient", "antiquus", 15915919),
    PRIMEVAL("Primeval", "priscus", 11773563),
    PREHISTORIC("Prehistoric", "pristinus", 7232064),
    RELIC("Relic", "sapiens", 5062166),
    COAL("Fossilised", "carbo", 8025672),
    RESIN("Resinous", "lacrima", 10908443),
    OIL("Oily", "lubricus", 5719920),
    PEAT("Preserved", "peatus", 9185802),
    DISTILLED("Distilled", "distilli", 0x356356),
    FUEL("Refined", "refina", 16760835),
    CREOSOTE("Tarry", "creosota", 9936403),
    LATEX("Elastic", "latex", 4803134),
    WATER("Water", "aqua", 9741055),
    RIVER("River", "flumen", 8631252),
    OCEAN("Ocean", "mare", 1912493),
    INK("Stained", "atramentum", 922695),
    GROWING("Growing", "tyrelli", 6024152),
    THRIVING("Thriving", "thriva", 3466109),
    BLOOMING("Blooming", "blooma", 704308),
    SWEET("Sweetened", "mellitus", 16536049),
    SUGAR("Sugary", "dulcis", 15127520),
    RIPENING("Ripening", "ripa", 11716445),
    FRUIT("Fruity", "pomum", 14375030),
    ALCOHOL("Fermented", "vinum", 15239777),
    FARM("Farmed", "ager", 7723872),
    MILK("Bovine", "lacteus", 0xE3E8E8),
    COFFEE("Caffeinated", "arabica", 9199152),
    CITRUS("Citrus", "citrus", 16444501),
    MINT("Minty", "minty", 7206760),
    SWAMP("Damp", "paludis", 3500339),
    BOGGY("Boggy", "lama", 7887913),
    FUNGAL("Fungal", "boletus", 13722112),
    MARBLE("Marbled", "marbla", 14076367),
    ROMAN("Gothic", "roman", 11373488),
    GREEK("Renaissance", "greco", 8735882),
    CLASSICAL("Classical", "classica", 8592780),
    BASALT("Embittered", "aceri", 9202025),
    TEMPERED("Furious", "iratus", 0x8A4848),
    ANGRY("Furious", "iratus", 8396575),
    VOLCANIC("Volcanic", "volcano", 5049356),
    MALICIOUS("Malicious", "acerbus", 7875191),
    INFECTIOUS("Infectious", "contagio", 12070581),
    VIRULENT("Virulent", "morbus", 15733740),
    VISCOUS("Viscous", "liquidus", 608014),
    GLUTINOUS("Glutinous", "glutina", 1936423),
    STICKY("Sticky", "lentesco", 1565480),
    CORROSIVE("Corrosive", "corrumpo", 4873227),
    CAUSTIC("Caustic", "torrens", 8691997),
    ACIDIC("Acidic", "acidus", 12644374),
    EXCITED("Excited", "excita", 0xFF4545),
    ENERGETIC("Energetic", "energia", 15218119),
    ECSTATIC("Ecstatic", "ecstatica", 11482600),
    ARTIC("Frigid", "artica", 11395296),
    FREEZING("Absolute", "glacia", 8119267),
    SHADOW("Shadowed", "shadowa", 0x595959),
    DARKENED("Darkened", "darka", 0x332E33),
    ABYSS("Abyssal", "abyssba", 2164769),
    RED("Maroon", "rubra", 0xFF0000),
    YELLOW("Saffron", "fulvus", 0xFFDD00),
    BLUE("Prussian", "caeruleus", 8959),
    GREEN("Natural", "prasinus", 39168),
    BLACK("Ebony", "niger", 0x575757),
    WHITE("Bleached", "albus", 0xFFFFFF),
    BROWN("Sepia", "fuscus", 6042895),
    ORANGE("Amber", "flammeus", 16751872),
    CYAN("Turquoise", "cyana", 65509),
    PURPLE("Indigo", "purpureus", 11403519),
    GRAY("Slate", "ravus", 0xBABABA),
    LIGHTBLUE("Azure", "aqua", 40447),
    PINK("Lavender", "rosaceus", 16744671),
    LIMEGREEN("Lime", "lima", 65288),
    MAGENTA("Fuchsia", "fuchsia", 0xFF00CC),
    LIGHTGRAY("Ashen", "canus", 0xC9C9C9),
    CELEBRATORY("Celebratory", "celeba", 16386666),
    JADED("Jaded", "jadeca", 16386666),
    GLOWSTONE("Glowering", "glowia", 14730779),
    HAZARDOUS("Hazardous", "infensus", 11562024),
    NICKEL("Lustered", "claro", 16768764),
    INVAR("Lustrous", "invara", 13625551),
    QUANTUM("Quantum", "quanta", 3655131),
    SPATIAL("Spatial", "spatia", 4987872),
    UNUSUAL("Abnormal", "daniella", 5874874);

    private String name = "";
    private String description = "";
    private int primaryColor = 0xFFFFFF;
    private int secondaryColor = 16768022;
    private EnumTemperature temperature = EnumTemperature.NORMAL;
    private EnumHumidity humidity = EnumHumidity.NORMAL;
    private boolean hasEffect = false;
    private boolean isSecret = true;
    private boolean isCounted = true;
    private String binomial = "";
    private IClassification branch = null;
    private String uid = "";
    private Achievement achievement = null;
    private boolean dominant = true;
    private HashMap<ItemStack, Integer> products = new LinkedHashMap<ItemStack, Integer>();
    private HashMap<ItemStack, Integer> specialties = new LinkedHashMap<ItemStack, Integer>();
    private IAllele[] template;
    boolean active = true;
    @SideOnly(value=Side.CLIENT)
    private Icon[][] icons;
    boolean nocturnal = false;

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void addDescription(String description, String author) {
        this.description = description + "|" + author;
    }

    public EnumTemperature getTemperature() {
        return this.temperature;
    }

    public EnumHumidity getHumidity() {
        return this.humidity;
    }

    public boolean hasEffect() {
        return this.hasEffect;
    }

    public boolean isSecret() {
        return this.isSecret;
    }

    public boolean isCounted() {
        return this.isCounted;
    }

    public String getBinomial() {
        return this.binomial;
    }

    public String getAuthority() {
        return "Binnie";
    }

    public IClassification getBranch() {
        return this.branch;
    }

    public String getUID() {
        return "extrabees.species." + this.uid;
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public HashMap<ItemStack, Integer> getProducts() {
        return this.products;
    }

    public HashMap<ItemStack, Integer> getSpecialty() {
        return this.specialties;
    }

    private EnumExtraBeeSpecies(String name, String binomial, int colour) {
        this.name = name;
        this.uid = this.toString().toLowerCase();
        this.binomial = binomial;
        this.primaryColor = colour;
    }

    public void init() {
        this.template = EnumExtraBeeSpecies.getDefaultTemplate();
    }

    public void register() {
        BinnieGenetics.getBeeRoot().registerTemplate(this.getTemplate());
        AlleleManager.alleleRegistry.registerAllele((IAllele)this);
        if (!this.active) {
            AlleleManager.alleleRegistry.blacklistAllele(this.getUID());
        }
    }

    public void addProduct(ItemStack product, int chance) {
        if (product == null) {
            this.active = false;
        } else {
            this.products.put(product, chance);
        }
    }

    public void addProduct(IItemEnum product, int chance) {
        if (product.isActive()) {
            this.addProduct(product.get(1), chance);
        } else {
            this.active = false;
        }
    }

    public void addSpecialty(ItemStack product, int chance) {
        if (product == null) {
            this.active = false;
        } else {
            this.specialties.put(product, chance);
        }
    }

    public void addSpecialty(IItemEnum product, int chance) {
        if (product.isActive()) {
            this.addSpecialty(product.get(1), chance);
        } else {
            this.active = false;
        }
    }

    public void setHumidity(EnumHumidity humidity) {
        this.humidity = humidity;
    }

    public void setTemperature(EnumTemperature temperature) {
        this.temperature = temperature;
    }

    public static IAllele[] getDefaultTemplate() {
        return BinnieGenetics.getBeeRoot().getDefaultTemplate();
    }

    public IAllele[] getTemplate() {
        this.template[EnumBeeChromosome.SPECIES.ordinal()] = this;
        return this.template;
    }

    public void importVanillaTemplate(String uid) {
        String text = uid.substring(0, 1).toUpperCase() + uid.substring(1).toLowerCase();
        IAllele[] vanilla = BinnieGenetics.getBeeRoot().getTemplate("forestry.species" + text);
        if (vanilla != null) {
            this.importTemplate(vanilla);
        } else {
            FMLLog.getLogger().warning("Couldn't find vanilla template - forestry.species" + text);
        }
    }

    public void importTemplate(EnumExtraBeeSpecies species) {
        this.importTemplate(species.getTemplate());
    }

    public void importTemplate(IAllele[] template) {
        this.template = (IAllele[])template.clone();
        this.setHumidity(((IAlleleSpecies)template[0]).getHumidity());
        this.setTemperature(((IAlleleSpecies)template[0]).getTemperature());
        this.setSecondaryColor(((IAlleleSpecies)template[0]).getIconColour(1));
        this.template[EnumBeeChromosome.SPECIES.ordinal()] = this;
    }

    public void recessive() {
        this.dominant = false;
    }

    public void setIsSecret(boolean secret) {
        this.isSecret = secret;
    }

    public void setHasEffect(boolean effect) {
        this.hasEffect = effect;
    }

    public void setSecondaryColor(int colour) {
        this.secondaryColor = colour;
    }

    public static void doInit() {
        for (EnumExtraBeeSpecies species : EnumExtraBeeSpecies.values()) {
            species.init();
        }
        AlleleManager.alleleRegistry.blacklistAllele(BRONZE.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(BRASS.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(STEEL.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(ELECTRUM.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(SODALITE.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(PYRITE.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(BAUXITE.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(CINNABAR.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(SPHALERITE.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(OLIVINE.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(MARBLE.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(ROMAN.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(GREEK.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(CLASSICAL.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(INVAR.getUID());
        AlleleManager.alleleRegistry.blacklistAllele(ANGRY.getUID());
        int aridBody = 13362036;
        int rockBody = 0x999999;
        int endBody = 0xD9DE9E;
        ARID.importVanillaTemplate("modest");
        ARID.addProduct(EnumHoneyComb.BARREN, 30);
        ARID.setHumidity(EnumHumidity.ARID);
        ARID.setFlowerProvider(EnumExtraBeeFlowers.DEAD.getUID());
        ARID.setTemperatureTolerance(Tolerance.Up1);
        ARID.setSecondaryColor(aridBody);
        BARREN.importTemplate(ARID);
        BARREN.setFertility(Fertility.Low);
        BARREN.addProduct(EnumHoneyComb.BARREN, 30);
        DESOLATE.addProduct(EnumHoneyComb.BARREN, 30);
        DESOLATE.importTemplate(BARREN);
        DESOLATE.setEffect(EnumExtraBeeEffect.HUNGER.getUID());
        DESOLATE.recessive();
        GNAWING.importTemplate(BARREN);
        GNAWING.setFlowerProvider(EnumExtraBeeFlowers.WOOD.getUID());
        GNAWING.addProduct(EnumHoneyComb.BARREN, 25);
        GNAWING.addSpecialty(EnumHoneyComb.SAWDUST, 25);
        ROTTEN.importTemplate(DESOLATE);
        ROTTEN.setNocturnal();
        ROTTEN.setCaveDwelling();
        ROTTEN.setTolerantFlyer();
        ROTTEN.setEffect(EnumExtraBeeEffect.SPAWN_ZOMBIE.getUID());
        ROTTEN.addProduct(EnumHoneyComb.BARREN, 30);
        ROTTEN.addSpecialty(EnumHoneyComb.ROTTEN, 10);
        BONE.importTemplate(ROTTEN);
        BONE.addProduct(EnumHoneyComb.BARREN, 30);
        BONE.addSpecialty(EnumHoneyComb.BONE, 10);
        BONE.setEffect(EnumExtraBeeEffect.SPAWN_SKELETON.getUID());
        CREEPER.importTemplate(ROTTEN);
        CREEPER.setAllDay();
        CREEPER.addProduct(EnumHoneyComb.BARREN, 30);
        CREEPER.addSpecialty(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.POWDERY), 8);
        CREEPER.setEffect(EnumExtraBeeEffect.SPAWN_CREEPER.getUID());
        DECOMPOSING.importTemplate(BARREN);
        DECOMPOSING.addProduct(EnumHoneyComb.BARREN, 30);
        DECOMPOSING.addSpecialty(EnumHoneyComb.COMPOST, 8);
        ROCK.addProduct(EnumHoneyComb.STONE, 30);
        ROCK.setIsSecret(false);
        ROCK.setAllDay();
        ROCK.setCaveDwelling();
        ROCK.setTolerantFlyer();
        ROCK.setTemperatureTolerance(Tolerance.Both1);
        ROCK.setHumidityTolerance(Tolerance.Both1);
        ROCK.setFlowerProvider(EnumExtraBeeFlowers.ROCK.getUID());
        ROCK.setFertility(Fertility.Low);
        ROCK.setLifespan(Lifespan.Short);
        ROCK.setSecondaryColor(rockBody);
        STONE.addProduct(EnumHoneyComb.STONE, 30);
        STONE.importTemplate(ROCK);
        STONE.recessive();
        STONE.setSecondaryColor(rockBody);
        GRANITE.addProduct(EnumHoneyComb.STONE, 30);
        GRANITE.importTemplate(STONE);
        GRANITE.setTemperatureTolerance(Tolerance.Both2);
        GRANITE.setHumidityTolerance(Tolerance.Both2);
        GRANITE.setSecondaryColor(rockBody);
        MINERAL.addProduct(EnumHoneyComb.STONE, 30);
        MINERAL.importTemplate(GRANITE);
        MINERAL.setSecondaryColor(rockBody);
        COPPER.addProduct(EnumHoneyComb.STONE, 20);
        COPPER.addSpecialty(EnumHoneyComb.COPPER, 6);
        COPPER.importTemplate(MINERAL);
        COPPER.setSecondaryColor(rockBody);
        TIN.addProduct(EnumHoneyComb.STONE, 20);
        TIN.addSpecialty(EnumHoneyComb.TIN, 6);
        TIN.importTemplate(MINERAL);
        TIN.setSecondaryColor(rockBody);
        IRON.addProduct(EnumHoneyComb.STONE, 20);
        IRON.addSpecialty(EnumHoneyComb.IRON, 5);
        IRON.importTemplate(MINERAL);
        IRON.recessive();
        IRON.setSecondaryColor(rockBody);
        LEAD.addProduct(EnumHoneyComb.STONE, 20);
        LEAD.addSpecialty(EnumHoneyComb.LEAD, 5);
        LEAD.importTemplate(MINERAL);
        LEAD.setSecondaryColor(rockBody);
        NICKEL.addProduct(EnumHoneyComb.STONE, 20);
        NICKEL.addSpecialty(EnumHoneyComb.NICKEL, 5);
        NICKEL.importTemplate(MINERAL);
        NICKEL.setSecondaryColor(rockBody);
        ZINC.addProduct(EnumHoneyComb.STONE, 20);
        ZINC.addSpecialty(EnumHoneyComb.ZINC, 5);
        ZINC.importTemplate(MINERAL);
        ZINC.setSecondaryColor(rockBody);
        TITANIUM.addProduct(EnumHoneyComb.STONE, 20);
        TITANIUM.addSpecialty(EnumHoneyComb.TITANIUM, 2);
        TITANIUM.importTemplate(MINERAL);
        TITANIUM.setSecondaryColor(rockBody);
        TUNGSTATE.addProduct(EnumHoneyComb.STONE, 20);
        TUNGSTATE.addSpecialty(EnumHoneyComb.TUNGSTEN, 1);
        TUNGSTATE.importTemplate(MINERAL);
        TUNGSTATE.setSecondaryColor(rockBody);
        GOLD.addProduct(EnumHoneyComb.STONE, 20);
        GOLD.addSpecialty(EnumHoneyComb.GOLD, 2);
        GOLD.importTemplate(MINERAL);
        GOLD.setSecondaryColor(rockBody);
        SILVER.addProduct(EnumHoneyComb.STONE, 20);
        SILVER.addSpecialty(EnumHoneyComb.SILVER, 2);
        SILVER.importTemplate(MINERAL);
        SILVER.recessive();
        SILVER.recessive();
        SILVER.setSecondaryColor(rockBody);
        PLATINUM.addProduct(EnumHoneyComb.STONE, 20);
        PLATINUM.addSpecialty(EnumHoneyComb.PLATINUM, 1);
        PLATINUM.importTemplate(MINERAL);
        PLATINUM.recessive();
        PLATINUM.setSecondaryColor(rockBody);
        LAPIS.addProduct(EnumHoneyComb.STONE, 20);
        LAPIS.addSpecialty(EnumHoneyComb.LAPIS, 5);
        LAPIS.importTemplate(MINERAL);
        LAPIS.setSecondaryColor(rockBody);
        EMERALD.addProduct(EnumHoneyComb.STONE, 20);
        EMERALD.addSpecialty(EnumHoneyComb.EMERALD, 4);
        EMERALD.importTemplate(MINERAL);
        EMERALD.setSecondaryColor(rockBody);
        RUBY.addProduct(EnumHoneyComb.STONE, 20);
        RUBY.addSpecialty(EnumHoneyComb.RUBY, 3);
        RUBY.importTemplate(MINERAL);
        RUBY.setSecondaryColor(rockBody);
        SAPPHIRE.addProduct(EnumHoneyComb.STONE, 20);
        SAPPHIRE.addSpecialty(EnumHoneyComb.SAPPHIRE, 3);
        SAPPHIRE.importTemplate(MINERAL);
        SAPPHIRE.setSecondaryColor(rockBody);
        DIAMOND.addProduct(EnumHoneyComb.STONE, 20);
        DIAMOND.addSpecialty(EnumHoneyComb.DIAMOND, 1);
        DIAMOND.importTemplate(MINERAL);
        DIAMOND.setSecondaryColor(rockBody);
        UNSTABLE.importTemplate(MINERAL);
        UNSTABLE.addProduct(EnumHoneyComb.BARREN, 20);
        UNSTABLE.setEffect(EnumExtraBeeEffect.RADIOACTIVE.getUID());
        UNSTABLE.setFertility(Fertility.Low);
        UNSTABLE.setLifespan(Lifespan.Shortest);
        UNSTABLE.recessive();
        NUCLEAR.importTemplate(UNSTABLE);
        NUCLEAR.addProduct(EnumHoneyComb.BARREN, 20);
        NUCLEAR.recessive();
        RADIOACTIVE.importTemplate(NUCLEAR);
        RADIOACTIVE.addProduct(EnumHoneyComb.BARREN, 20);
        RADIOACTIVE.addSpecialty(EnumHoneyComb.URANIUM, 2);
        RADIOACTIVE.setHasEffect(true);
        RADIOACTIVE.recessive();
        ANCIENT.importVanillaTemplate("Noble");
        ANCIENT.addProduct(EnumHoneyComb.OLD, 30);
        ANCIENT.setLifespan(Lifespan.Elongated);
        PRIMEVAL.importTemplate(ANCIENT);
        PRIMEVAL.addProduct(EnumHoneyComb.OLD, 30);
        PRIMEVAL.setLifespan(Lifespan.Long);
        PREHISTORIC.importTemplate(ANCIENT);
        PREHISTORIC.addProduct(EnumHoneyComb.OLD, 30);
        PREHISTORIC.setLifespan(Lifespan.Longer);
        PREHISTORIC.setFertility(Fertility.Low);
        PREHISTORIC.recessive();
        RELIC.importTemplate(ANCIENT);
        RELIC.addProduct(EnumHoneyComb.OLD, 30);
        RELIC.setHasEffect(true);
        RELIC.setLifespan(Lifespan.Longest);
        COAL.importTemplate(ANCIENT);
        COAL.setLifespan(Lifespan.Normal);
        COAL.addProduct(EnumHoneyComb.OLD, 20);
        COAL.addSpecialty(EnumHoneyComb.COAL, 8);
        RESIN.importTemplate(COAL);
        RESIN.addProduct(EnumHoneyComb.OLD, 20);
        RESIN.addSpecialty(EnumHoneyComb.RESIN, 5);
        RESIN.recessive();
        OIL.importTemplate(COAL);
        OIL.addProduct(EnumHoneyComb.OLD, 20);
        OIL.addSpecialty(EnumHoneyComb.OIL, 5);
        PEAT.importTemplate(COAL);
        PEAT.addProduct(EnumHoneyComb.OLD, 20);
        PEAT.addSpecialty(EnumHoneyComb.PEAT, 8);
        DISTILLED.importTemplate(OIL);
        DISTILLED.addProduct(EnumHoneyComb.OIL, 10);
        DISTILLED.recessive();
        FUEL.importTemplate(OIL);
        FUEL.addProduct(EnumHoneyComb.OIL, 10);
        FUEL.addSpecialty(EnumHoneyComb.FUEL, 4);
        FUEL.setHasEffect(true);
        CREOSOTE.importTemplate(COAL);
        CREOSOTE.addProduct(EnumHoneyComb.COAL, 10);
        CREOSOTE.addSpecialty(EnumHoneyComb.CREOSOTE, 7);
        CREOSOTE.setHasEffect(true);
        LATEX.importTemplate(RESIN);
        LATEX.addProduct(EnumHoneyComb.RESIN, 10);
        LATEX.addSpecialty(EnumHoneyComb.LATEX, 5);
        LATEX.setHasEffect(true);
        WATER.addProduct(EnumHoneyComb.WATER, 30);
        WATER.setIsSecret(false);
        WATER.setTolerantFlyer();
        WATER.setHumidityTolerance(Tolerance.Both1);
        WATER.setFlowerProvider(EnumExtraBeeFlowers.WATER.getUID());
        WATER.setFlowering(Flowering.Slow);
        WATER.setEffect(EnumExtraBeeEffect.WATER.getUID());
        WATER.setHumidity(EnumHumidity.DAMP);
        RIVER.importTemplate(WATER);
        RIVER.addProduct(EnumHoneyComb.WATER, 30);
        RIVER.addSpecialty(EnumHoneyComb.CLAY, 20);
        RIVER.importTemplate(WATER);
        OCEAN.importTemplate(WATER);
        OCEAN.addProduct(EnumHoneyComb.WATER, 30);
        OCEAN.importTemplate(WATER);
        OCEAN.recessive();
        INK.importTemplate(OCEAN);
        INK.addProduct(EnumHoneyComb.WATER, 30);
        INK.addSpecialty(new ItemStack(Item.field_77756_aW, 1, 0), 10);
        GROWING.importVanillaTemplate("Forest");
        GROWING.addProduct(ItemHoneyComb.EnumVanillaType.HONEY.get(), 35);
        GROWING.setFlowering(Flowering.Average);
        GROWING.setFlowerProvider(EnumExtraBeeFlowers.LEAVES.getUID());
        THRIVING.importTemplate(GROWING);
        THRIVING.addProduct(ItemHoneyComb.EnumVanillaType.HONEY.get(), 35);
        THRIVING.setFlowering(Flowering.Fast);
        BLOOMING.importTemplate(THRIVING);
        BLOOMING.setFlowering(Flowering.Fastest);
        BLOOMING.addProduct(ItemHoneyComb.EnumVanillaType.HONEY.get(), 35);
        BLOOMING.setFlowerProvider(EnumExtraBeeFlowers.Sapling.getUID());
        BLOOMING.setEffect(EnumExtraBeeEffect.BonemalSapling.getUID());
        SWEET.importVanillaTemplate("Rural");
        SWEET.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.HONEY), 40);
        SWEET.addProduct(new ItemStack(Item.field_77747_aY, 1, 0), 10);
        SWEET.setFlowerProvider(EnumExtraBeeFlowers.SUGAR.getUID());
        SUGAR.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.HONEY), 40);
        SUGAR.addProduct(new ItemStack(Item.field_77747_aY, 1, 0), 20);
        SUGAR.importTemplate(SWEET);
        RIPENING.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.HONEY), 30);
        RIPENING.addProduct(new ItemStack(Item.field_77747_aY, 1, 0), 10);
        RIPENING.addSpecialty(EnumHoneyComb.FRUIT, 10);
        RIPENING.setFlowerProvider(EnumExtraBeeFlowers.Fruit.getUID());
        RIPENING.importTemplate(SUGAR);
        FRUIT.importTemplate(RIPENING);
        FRUIT.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.HONEY), 30);
        FRUIT.addProduct(new ItemStack(Item.field_77747_aY, 1, 0), 15);
        FRUIT.addSpecialty(EnumHoneyComb.FRUIT, 20);
        FRUIT.setEffect(EnumExtraBeeEffect.BonemealFruit.getUID());
        FRUIT.setHasEffect(true);
        ALCOHOL.importTemplate(SWEET);
        ALCOHOL.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.WHEATEN), 30);
        ALCOHOL.addSpecialty(EnumHoneyComb.ALCOHOL, 10);
        ALCOHOL.setEffect("forestry.effectDrunkard");
        ALCOHOL.recessive();
        FARM.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.WHEATEN), 30);
        FARM.addSpecialty(EnumHoneyComb.SEED, 10);
        FARM.importVanillaTemplate("rural");
        MILK.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.WHEATEN), 30);
        MILK.addSpecialty(EnumHoneyComb.MILK, 10);
        MILK.importVanillaTemplate("rural");
        COFFEE.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.WHEATEN), 30);
        COFFEE.addSpecialty(EnumHoneyComb.COFFEE, 8);
        COFFEE.importVanillaTemplate("rural");
        CITRUS.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.WHEATEN), 30);
        CITRUS.addSpecialty(EnumHoneyComb.CITRUS, 10);
        CITRUS.importVanillaTemplate("rural");
        MINT.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.WHEATEN), 30);
        MINT.addSpecialty(EnumHoneyComb.MINT, 10);
        MINT.importVanillaTemplate("rural");
        SWAMP.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.MOSSY), 30);
        SWAMP.importVanillaTemplate("marshy");
        SWAMP.setHumidity(EnumHumidity.DAMP);
        SWAMP.setEffect(EnumExtraBeeEffect.SLOW.getUID());
        BOGGY.importTemplate(SWAMP);
        BOGGY.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.MOSSY), 30);
        BOGGY.importTemplate(SWAMP);
        BOGGY.recessive();
        FUNGAL.importTemplate(BOGGY);
        FUNGAL.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.MOSSY), 30);
        FUNGAL.addSpecialty(EnumHoneyComb.FUNGAL, 15);
        FUNGAL.importTemplate(BOGGY);
        FUNGAL.setEffect(EnumExtraBeeEffect.BonemealMushroom.getUID());
        FUNGAL.setHasEffect(true);
        MARBLE.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.HONEY), 30);
        MARBLE.importVanillaTemplate("noble");
        ROMAN.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.HONEY), 30);
        ROMAN.importTemplate(MARBLE);
        GREEK.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.HONEY), 30);
        GREEK.recessive();
        GREEK.importTemplate(ROMAN);
        CLASSICAL.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.HONEY), 30);
        CLASSICAL.addSpecialty(ItemInterface.getItem((String)"royalJelly"), 25);
        CLASSICAL.setHasEffect(true);
        CLASSICAL.importTemplate(GREEK);
        BASALT.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SIMMERING), 25);
        BASALT.importVanillaTemplate("sinister");
        BASALT.setEffect("forestry.effectAggressive");
        BASALT.setSecondaryColor(10101539);
        BASALT.setHumidity(EnumHumidity.ARID);
        BASALT.setTemperature(EnumTemperature.HELLISH);
        TEMPERED.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SIMMERING), 25);
        TEMPERED.importTemplate(BASALT);
        TEMPERED.setEffect(EnumExtraBeeEffect.METEOR.getUID());
        TEMPERED.recessive();
        TEMPERED.setSecondaryColor(10101539);
        ANGRY.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SIMMERING), 25);
        ANGRY.importTemplate(TEMPERED);
        ANGRY.setSecondaryColor(10101539);
        VOLCANIC.importTemplate(TEMPERED);
        VOLCANIC.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SIMMERING), 25);
        VOLCANIC.addSpecialty(EnumHoneyComb.BLAZE, 10);
        VOLCANIC.setHasEffect(true);
        VOLCANIC.setSecondaryColor(10101539);
        MALICIOUS.importVanillaTemplate("tropical");
        MALICIOUS.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SILKY), 25);
        MALICIOUS.setSecondaryColor(431972);
        MALICIOUS.setHumidity(EnumHumidity.DAMP);
        MALICIOUS.setTemperature(EnumTemperature.WARM);
        INFECTIOUS.importTemplate(MALICIOUS);
        INFECTIOUS.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SILKY), 25);
        INFECTIOUS.setFlowering(Flowering.Slow);
        INFECTIOUS.setSecondaryColor(431972);
        VIRULENT.importTemplate(INFECTIOUS);
        VIRULENT.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SILKY), 25);
        VIRULENT.addSpecialty(EnumHoneyComb.VENOMOUS, 12);
        VIRULENT.setFlowering(Flowering.Average);
        VIRULENT.recessive();
        VIRULENT.setHasEffect(true);
        VIRULENT.setSecondaryColor(431972);
        VISCOUS.importVanillaTemplate("tropical");
        VISCOUS.setEffect(EnumExtraBeeEffect.ECTOPLASM.getUID());
        VISCOUS.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SILKY), 25);
        VISCOUS.setSecondaryColor(431972);
        VISCOUS.setHumidity(EnumHumidity.DAMP);
        VISCOUS.setSpeed(Speed.Slow);
        VISCOUS.setTemperature(EnumTemperature.WARM);
        GLUTINOUS.importTemplate(VISCOUS);
        GLUTINOUS.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SILKY), 25);
        GLUTINOUS.setSpeed(Speed.Norm);
        GLUTINOUS.setSecondaryColor(431972);
        STICKY.importTemplate(GLUTINOUS);
        STICKY.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SILKY), 25);
        STICKY.addSpecialty(EnumHoneyComb.SLIME, 12);
        STICKY.setSpeed(Speed.Fast);
        STICKY.setHasEffect(true);
        STICKY.setSecondaryColor(431972);
        CORROSIVE.importTemplate(STICKY);
        CORROSIVE.setHumidity(EnumHumidity.DAMP);
        CORROSIVE.setTemperature(EnumTemperature.WARM);
        CORROSIVE.setEffect(EnumExtraBeeEffect.ACID.getUID());
        CORROSIVE.setFlowering(Flowering.Average);
        CORROSIVE.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SILKY), 20);
        CORROSIVE.recessive();
        CORROSIVE.setSecondaryColor(431972);
        CAUSTIC.importTemplate(CORROSIVE);
        CAUSTIC.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SILKY), 25);
        CAUSTIC.addSpecialty(EnumHoneyComb.ACIDIC, 3);
        CAUSTIC.setSecondaryColor(431972);
        ACIDIC.importTemplate(CAUSTIC);
        ACIDIC.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.SILKY), 20);
        ACIDIC.addSpecialty(EnumHoneyComb.ACIDIC, 16);
        ACIDIC.setHasEffect(true);
        ACIDIC.setSecondaryColor(431972);
        EXCITED.setEffect(EnumExtraBeeEffect.LIGHTNING.getUID());
        EXCITED.addProduct(EnumHoneyComb.REDSTONE, 10);
        EXCITED.setCaveDwelling();
        EXCITED.setFlowerProvider(EnumExtraBeeFlowers.REDSTONE.getUID());
        ENERGETIC.importTemplate(EXCITED);
        ENERGETIC.setEffect(EnumExtraBeeEffect.LIGHTNING.getUID());
        ENERGETIC.addProduct(EnumHoneyComb.REDSTONE, 12);
        ENERGETIC.recessive();
        ECSTATIC.importTemplate(ENERGETIC);
        ECSTATIC.setEffect(EnumExtraBeeEffect.Power.getUID());
        ECSTATIC.addProduct(EnumHoneyComb.REDSTONE, 20);
        ECSTATIC.addSpecialty(EnumHoneyComb.IC2ENERGY, 8);
        ECSTATIC.setHasEffect(true);
        ARTIC.importVanillaTemplate("wintry");
        ARTIC.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.FROZEN), 25);
        ARTIC.setTemperature(EnumTemperature.ICY);
        ARTIC.setSecondaryColor(14349811);
        FREEZING.importTemplate(ARTIC);
        FREEZING.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.FROZEN), 20);
        FREEZING.addSpecialty(EnumHoneyComb.GLACIAL, 10);
        FREEZING.setSecondaryColor(14349811);
        SHADOW.importTemplate(BASALT);
        SHADOW.setNocturnal();
        SHADOW.addProduct(EnumHoneyComb.SHADOW, 5);
        SHADOW.setEffect(EnumExtraBeeEffect.BLINDNESS.getUID());
        SHADOW.setAllDay(false);
        SHADOW.recessive();
        SHADOW.setSecondaryColor(0x333333);
        DARKENED.addProduct(EnumHoneyComb.SHADOW, 10);
        DARKENED.setNocturnal();
        DARKENED.importTemplate(SHADOW);
        DARKENED.setSecondaryColor(0x333333);
        ABYSS.importTemplate(DARKENED);
        ABYSS.setNocturnal();
        ABYSS.addProduct(EnumHoneyComb.SHADOW, 25);
        ABYSS.setEffect(EnumExtraBeeEffect.WITHER.getUID());
        ABYSS.setHasEffect(true);
        ABYSS.setSecondaryColor(0x333333);
        CELEBRATORY.importVanillaTemplate("festive");
        CELEBRATORY.setEffect(EnumExtraBeeEffect.FIREWORKS.getUID());
        GLOWSTONE.importTemplate(BASALT);
        GLOWSTONE.addProduct(EnumHoneyComb.GLOWSTONE, 15);
        GLOWSTONE.setSecondaryColor(10101539);
        HAZARDOUS.importVanillaTemplate("Austere");
        HAZARDOUS.addProduct(EnumHoneyComb.SALTPETER, 12);
        JADED.importVanillaTemplate("imperial");
        JADED.setFertility(Fertility.Maximum);
        JADED.setFlowering(Flowering.Maximum);
        JADED.setTerritory(Territory.Largest);
        JADED.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.HONEY), 30);
        JADED.addSpecialty(ItemInterface.getItem((String)"pollen"), 20);
        JADED.setHasEffect(true);
        JADED.setSecondaryColor(14453483);
        UNUSUAL.importVanillaTemplate("ended");
        UNUSUAL.setEffect(EnumExtraBeeEffect.GRAVITY.getUID());
        UNUSUAL.setSecondaryColor(12231403);
        UNUSUAL.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.QUARTZ), 25);
        SPATIAL.importTemplate(UNUSUAL);
        SPATIAL.setEffect(EnumExtraBeeEffect.GRAVITY.getUID());
        SPATIAL.setSecondaryColor(10768076);
        SPATIAL.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.QUARTZ), 25);
        SPATIAL.addSpecialty(EnumHoneyComb.CERTUS, 5);
        QUANTUM.importTemplate(QUANTUM);
        QUANTUM.setEffect(EnumExtraBeeEffect.TELEPORT.getUID());
        QUANTUM.setSecondaryColor(13963227);
        QUANTUM.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.QUARTZ), 25);
        QUANTUM.addSpecialty(EnumHoneyComb.CERTUS, 15);
        QUANTUM.addSpecialty(EnumHoneyComb.ENDERPEARL, 15);
        JADED.addSpecialty(EnumHoneyComb.PURPLE, 15);
        EnumExtraBeeSpecies.JADED.isCounted = false;
        for (EnumExtraBeeSpecies species : EnumExtraBeeSpecies.values()) {
            if (!species.isActive()) {
                AlleleManager.alleleRegistry.blacklistAllele(species.getUID());
            }
            for (EnumBeeChromosome chromo : EnumBeeChromosome.values()) {
                IAllele allele;
                if (chromo == EnumBeeChromosome.HUMIDITY || (allele = species.template[chromo.ordinal()]) != null && chromo.getAlleleClass().isInstance(allele)) continue;
                throw new RuntimeException(species.getName() + " has an invalid " + chromo.toString() + " chromosome!");
            }
        }
        String bookBinnie = "Apiarist Manual";
        String bookSengir = "Beekeeping 101";
        String bookMyst = "Apinomicon";
        String authorBinnie = "Binnie, Apiarist";
        String authorJaded = "Jadedcat, Apiarist";
        String authorMyst = "Mysterious Apiarist";
        ARID.addDescription("Fond of dry landscapes, their combs are quite waxy and contain less honey.", bookBinnie);
        BARREN.addDescription("Preferring deserts, they can live their entire lives without seeing flowers of any kind.", bookBinnie);
        DESOLATE.addDescription("They thrive in blasted wastelands where other life simply withers away.", bookBinnie);
        ROTTEN.addDescription("These bees have an ususual attraction to dead, rotting meat and will store it in their combs. The smell also attracts other unsavoury types.", bookBinnie);
        BONE.addDescription("Largely unable to defend their hives in the wild, they attract other creatures to guard their homes.", bookBinnie);
        CREEPER.addDescription("You're sure to get a bang out of these bees.", authorBinnie);
        ROCK.addDescription("If only I could find them Rolling Bees, then I might get some good music.", authorMyst);
        STONE.addDescription("Part of their hive is made out of stone and use less wax than before.", bookBinnie);
        GRANITE.addDescription("Capable of burrowing through solid rock, they have an extraordinary affinity for minerals hidden in rocks.", bookBinnie);
        MINERAL.addDescription("Generations of breeding Rocky bees and their offspring has resulted in offspring that have begun to consume minerals as part of their diet.", bookBinnie);
        MILK.addDescription("\"Moo. I mean, Bzzz.\"", "Confused Bee");
        MARBLE.addDescription("\"Whoa, these bees are chiseled!\"", authorMyst);
        ROMAN.addDescription("I came, I saw, I conquered Punett squares.", "Sengir Ceasar");
        GREEK.addDescription("To bee or not to bee.", "Beekeeper's conundrum");
        BASALT.addDescription("It is unknown how they first arrived in the Nether, but its influence has made them aggresive.", bookBinnie);
        TEMPERED.addDescription("An unusual mutation has activated recessive genes that cause high levels of anger in this bee.", bookBinnie);
        ANGRY.addDescription("Increasing levels of fury have caused them to find another outlet for thier aggression.", bookBinnie);
        VOLCANIC.addDescription("At some point during their evolution, they seem to have acquired traits from Blazes.", bookBinnie);
        ALCOHOL.addDescription("Go home bee, you're drunk.", authorJaded);
        EXCITED.addDescription("Redstone acts as a source of extra energy for these bees.", bookBinnie);
        ENERGETIC.addDescription("Oh my god. Something happened. House on fire, house on fire.", "Generikb, Panicked Apiarist");
        ECSTATIC.addDescription("After accumulating excessive static electricity from Redstone, they produce powerful lightning arcs. Use caution, and maybe a lightning rod.", bookBinnie);
        COPPER.addDescription("These are infamous for causing power issues by gnawing on the copper wires in walls.", bookBinnie);
        TIN.addDescription("Their bodies have a metallic coating, which they shed and incorporate into their combs.", bookBinnie);
        IRON.addDescription("Oh, rusty bees. Do I need a tetanus shot?", authorJaded);
        LEAD.addDescription("\"It should be easy to turn these into gold!\"", "Pahimar, Alchemist");
        COFFEE.addDescription("The only drawback is that they don't actually brew the coffee for you.", bookBinnie);
        PLATINUM.addDescription("Ohhhhh, look how shiny this bee is.", authorJaded);
        EMERALD.addDescription("Look at this bee, it's even shinier!", authorJaded);
        DIAMOND.addDescription("Oh my god, this is definitely the shiniest bee!", authorJaded);
        RED.addDescription("Don't let them sting you,  or you may be seeing red.", bookBinnie);
        YELLOW.addDescription("They're dyeing to brighten your day with their honey.", bookBinnie);
        BLUE.addDescription("\"Cheer up, bee. You're looking a little blue.\"", authorMyst);
        GREEN.addDescription("Perhaps it is an attempt at camoflauge, but these bees have begun producing dyes that match the colour of leaves and grass.", bookBinnie);
        JADED.addDescription("I bred all the bees and all I got is some bloody purple dye!", "Jaded, Sengir's Chosen");
        for (int i = 0; i < 16; ++i) {
            EnumExtraBeeSpecies species = EnumExtraBeeSpecies.values()[RED.ordinal() + i];
            EnumHoneyComb comb = EnumHoneyComb.values()[EnumHoneyComb.RED.ordinal() + i];
            species.addProduct(ItemHoneyComb.getVanillaItem(ItemHoneyComb.EnumVanillaType.HONEY), 75);
            species.addSpecialty(comb, 25);
            species.setSecondaryColor(9240320);
        }
        for (EnumExtraBeeSpecies species : EnumExtraBeeSpecies.values()) {
            species.register();
        }
    }

    public static IAlleleBeeSpecies getVanilla(String name) {
        return (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.species" + name);
    }

    public static IAllele[] getVanillaTemplate(String uid) {
        String text = uid.substring(0, 1).toUpperCase() + uid.substring(1).toLowerCase();
        return BinnieGenetics.getBeeRoot().getTemplate("forestry.species" + text);
    }

    void setBranch(IClassification branch) {
        this.branch = branch;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isJubilant(World world, int biomeid, int x, int y, int z) {
        return true;
    }

    public boolean isJubilant(IBeeGenome genome, IBeeHousing housing) {
        return true;
    }

    public int getIconColour(int renderPass) {
        return renderPass == 0 ? this.primaryColor : (renderPass == 1 ? this.secondaryColor : 0xFFFFFF);
    }

    public IIconProvider getIconProvider() {
        return this;
    }

    public Icon getIcon(short texUID) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister register) {
        String iconType = "default";
        String mod = "forestry";
        if (this == JADED) {
            iconType = "jaded";
            mod = "extrabees";
        }
        this.icons = new Icon[EnumBeeType.values().length][3];
        Icon body1 = BinnieCore.proxy.getIcon(register, mod, "bees/" + iconType + "/body1");
        for (int i = 0; i < EnumBeeType.values().length; ++i) {
            if (EnumBeeType.values()[i] == EnumBeeType.NONE) continue;
            this.icons[i][0] = BinnieCore.proxy.getIcon(register, mod, "bees/" + iconType + "/" + EnumBeeType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".outline");
            this.icons[i][1] = EnumBeeType.values()[i] != EnumBeeType.LARVAE ? body1 : BinnieCore.proxy.getIcon(register, mod, "bees/" + iconType + "/" + EnumBeeType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".body");
            this.icons[i][2] = BinnieCore.proxy.getIcon(register, mod, "bees/" + iconType + "/" + EnumBeeType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".body2");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(EnumBeeType type, int renderPass) {
        return this.icons[type.ordinal()][renderPass];
    }

    public IBeeRoot getRoot() {
        return BinnieGenetics.getBeeRoot();
    }

    public boolean isNocturnal() {
        return this.nocturnal;
    }

    public void setNocturnal() {
        this.nocturnal = true;
    }

    public void setAllDay() {
        this.setAllDay(true);
    }

    public void setAllDay(boolean allDay) {
        this.template[EnumBeeChromosome.NOCTURNAL.ordinal()] = allDay ? AlleleManager.alleleRegistry.getAllele("forestry.boolTrue") : AlleleManager.alleleRegistry.getAllele("forestry.boolFalse");
    }

    public void setCaveDwelling() {
        this.template[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.boolTrue");
    }

    public void setTolerantFlyer() {
        this.template[EnumBeeChromosome.TOLERANT_FLYER.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.boolTrue");
    }

    public void setFlowerProvider(String uid) {
        IAllele allele = AlleleManager.alleleRegistry.getAllele(uid);
        if (allele instanceof IAlleleFlowers) {
            this.template[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = allele;
        }
    }

    public void setEffect(String uid) {
        IAllele allele = AlleleManager.alleleRegistry.getAllele(uid);
        if (allele instanceof IAlleleBeeEffect) {
            this.template[EnumBeeChromosome.EFFECT.ordinal()] = AlleleManager.alleleRegistry.getAllele(uid);
        }
    }

    private void setFertility(Fertility fert) {
        this.template[EnumBeeChromosome.FERTILITY.ordinal()] = AlleleManager.alleleRegistry.getAllele(fert.getUID());
    }

    private void setLifespan(Lifespan fert) {
        this.template[EnumBeeChromosome.LIFESPAN.ordinal()] = AlleleManager.alleleRegistry.getAllele(fert.getUID());
    }

    private void setSpeed(Speed fert) {
        this.template[EnumBeeChromosome.SPEED.ordinal()] = AlleleManager.alleleRegistry.getAllele(fert.getUID());
    }

    private void setTerritory(Territory fert) {
        this.template[EnumBeeChromosome.TERRITORY.ordinal()] = AlleleManager.alleleRegistry.getAllele(fert.getUID());
    }

    private void setFlowering(Flowering fert) {
        this.template[EnumBeeChromosome.FLOWERING.ordinal()] = AlleleManager.alleleRegistry.getAllele(fert.getUID());
    }

    private void setHumidityTolerance(Tolerance fert) {
        this.template[EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()] = AlleleManager.alleleRegistry.getAllele(fert.getUID());
    }

    private void setTemperatureTolerance(Tolerance both1) {
        this.template[EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()] = AlleleManager.alleleRegistry.getAllele(both1.getUID());
    }

    public float getResearchSuitability(ItemStack itemstack) {
        if (itemstack == null) {
            return 0.0f;
        }
        for (ItemStack itemStack : this.products.keySet()) {
            if (!itemStack.func_77969_a(itemstack)) continue;
            return 1.0f;
        }
        for (ItemStack itemStack : this.specialties.keySet()) {
            if (!itemStack.func_77969_a(itemstack)) continue;
            return 1.0f;
        }
        if (itemstack.field_77993_c == Item.field_77729_bt.field_77779_bT) {
            return 0.9f;
        }
        if (itemstack.field_77993_c == ItemInterface.getItem((String)"honeyDrop").field_77993_c) {
            return 0.5f;
        }
        if (itemstack.field_77993_c == ItemInterface.getItem((String)"honeydew").field_77993_c) {
            return 0.7f;
        }
        if (itemstack.field_77993_c == ItemInterface.getItem((String)"beeComb").field_77993_c) {
            return 0.4f;
        }
        if (AlleleManager.alleleRegistry.isIndividual(itemstack)) {
            return 1.0f;
        }
        for (Map.Entry entry : this.getRoot().getResearchCatalysts().entrySet()) {
            if (!((ItemStack)entry.getKey()).func_77969_a(itemstack)) continue;
            return ((Float)entry.getValue()).floatValue();
        }
        return 0.0f;
    }

    public ItemStack[] getResearchBounty(World world, String researcher, IIndividual individual, int bountyLevel) {
        ItemStack stack2;
        Collection combinations;
        ArrayList<ItemStack> bounty = new ArrayList<ItemStack>();
        ItemStack research = null;
        if (world.field_73012_v.nextFloat() < 10.0f / (float)bountyLevel && (combinations = this.getRoot().getCombinations((IAllele)this)).size() > 0) {
            IMutation[] candidates = combinations.toArray(new IMutation[0]);
            research = AlleleManager.alleleRegistry.getMutationNoteStack(researcher, candidates[world.field_73012_v.nextInt(candidates.length)]);
        }
        if (research != null) {
            bounty.add(research);
        }
        if (bountyLevel > 10) {
            for (ItemStack stack : this.specialties.keySet()) {
                stack2 = stack.func_77946_l();
                stack2.field_77994_a = world.field_73012_v.nextInt((int)((float)bountyLevel / 2.0f)) + 1;
                bounty.add(stack2);
            }
        }
        for (ItemStack stack : this.products.keySet()) {
            stack2 = stack.func_77946_l();
            stack2.field_77994_a = world.field_73012_v.nextInt((int)((float)bountyLevel / 2.0f)) + 1;
            bounty.add(stack2);
        }
        return bounty.toArray(new ItemStack[0]);
    }

    public String getEntityTexture() {
        return "/gfx/forestry/entities/bees/honeyBee.png";
    }

    public int getComplexity() {
        return 1 + this.getGeneticAdvancement((IAllele)this, new ArrayList<IAllele>());
    }

    private int getGeneticAdvancement(IAllele species, ArrayList<IAllele> exclude) {
        int own = 1;
        int highest = 0;
        exclude.add(species);
        for (IMutation mutation : this.getRoot().getPaths(species, EnumBeeChromosome.SPECIES.ordinal())) {
            int otherAdvance;
            if (!exclude.contains(mutation.getAllele0()) && (otherAdvance = this.getGeneticAdvancement(mutation.getAllele0(), exclude)) > highest) {
                highest = otherAdvance;
            }
            if (exclude.contains(mutation.getAllele1()) || (otherAdvance = this.getGeneticAdvancement(mutation.getAllele1(), exclude)) <= highest) continue;
            highest = otherAdvance;
        }
        return own + (highest < 0 ? 0 : highest);
    }

    public static enum Tolerance {
        None("No"),
        Both1("Both 1"),
        Both2("Both 2"),
        Both3("Both 3"),
        Both4("Both 4"),
        Both5("Both 5"),
        Up1("Up 1"),
        Up2("Up 2"),
        Up3("Up 3"),
        Up4("Up 4"),
        Up5("Up 5"),
        Down1("Down 1"),
        Down2("Down 2"),
        Down3("Down 3"),
        Down4("Down 4"),
        Down5("Down 5");

        String name;

        private Tolerance(String name) {
            this.name = name;
        }

        public String getUID() {
            return "forestry.tolerance" + this.toString();
        }

        public String getName(String type) {
            return this.name + " " + type + " Tol.";
        }
    }

    public static enum Territory {
        Default,
        Large,
        Larger,
        Largest;


        public String getUID() {
            return "forestry.territory" + this.toString();
        }

        public String getName() {
            return this.toString() + " Territory";
        }
    }

    public static enum Flowering {
        Slowest,
        Slower,
        Slow,
        Average,
        Fast,
        Faster,
        Fastest,
        Maximum;


        public String getUID() {
            return "forestry.flowering" + this.toString();
        }

        public String getName() {
            return this.toString() + " Flowering";
        }
    }

    public static enum Fertility {
        Low,
        Normal,
        High,
        Maximum;


        public String getUID() {
            return "forestry.fertility" + this.toString();
        }

        public String getName() {
            return this.toString() + " Fertility";
        }
    }

    public static enum Speed {
        Slowest,
        Slower,
        Slow,
        Norm,
        Fast,
        Faster,
        Fastest;


        public String getUID() {
            return "forestry.speed" + this.toString();
        }

        public String getName() {
            String name = this.toString();
            if (this == Norm) {
                name = name + "al";
            }
            return name + " Productivity";
        }
    }

    public static enum Lifespan {
        Shortest,
        Shorter,
        Short,
        Shortened,
        Normal,
        Elongated,
        Long,
        Longer,
        Longest;


        public String getUID() {
            return "forestry.lifespan" + this.toString();
        }

        public String getName() {
            return this.toString() + " Lifespan";
        }
    }
}

