/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.core;

import binnie.core.item.IItemMisc;
import binnie.core.liquid.LiquidManager;
import binnie.extrabees.ExtraBees;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.ItemInterface;
import forestry.api.recipes.RecipeManagers;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.oredict.OreDictionary;

public enum ExtraBeeItems implements IItemMisc
{
    ScentedGear("Scented Gear", "scentedGear"),
    DiamondShard("Diamond Fragment", "diamondShard"),
    EmeraldShard("Emerald Fragment", "emeraldShard"),
    RubyShard("Ruby Fragment", "rubyShard"),
    SapphireShard("Sapphire Fragment", "sapphireShard"),
    LapisShard("Lapis Fragment", "lapisShard"),
    IronDust("Iron Grains", "ironDust"),
    GoldDust("Gold Grains", "goldDust"),
    SilverDust("Silver Grains", "silverDust"),
    PlatinumDust("Platinum Grains", "platinumDust"),
    CopperDust("Copper Grains", "copperDust"),
    TinDust("Tin Grains", "tinDust"),
    NickelDust("Nickel Grains", "nickelDust"),
    LeadDust("Lead Grains", "leadDust"),
    ZincDust("Zinc Grains", "zincDust"),
    TitaniumDust("Titanium Grains", "titaniumDust"),
    TungstenDust("Tungsten Grains", "tungstenDust"),
    UraniumDust("Radioactive Fragments", "radioactiveDust"),
    CoalDust("Coal Grains", "coalDust"),
    RedDye("Red Dye", "dyeRed"),
    YellowDye("Yellow Dye", "dyeYellow"),
    BlueDye("Blue Dye", "dyeBlue"),
    GreenDye("Green Dye", "dyeGreen"),
    WhiteDye("White Dye", "dyeWhite"),
    BlackDye("Black Dye", "dyeBlack"),
    BrownDye("Brown Dye", "dyeBrown"),
    clayDust("Clay Dust", "clayDust");

    String name;
    String iconPath;
    Icon icon;
    String metalString = null;
    String gemString = null;

    public static void init() {
        OreDictionary.registerOre((String)"dyeRed", (ItemStack)RedDye.get(1));
        OreDictionary.registerOre((String)"dyeYellow", (ItemStack)YellowDye.get(1));
        OreDictionary.registerOre((String)"dyeBlue", (ItemStack)BlueDye.get(1));
        OreDictionary.registerOre((String)"dyeGreen", (ItemStack)GreenDye.get(1));
        OreDictionary.registerOre((String)"dyeBlack", (ItemStack)BlackDye.get(1));
        OreDictionary.registerOre((String)"dyeWhite", (ItemStack)WhiteDye.get(1));
        OreDictionary.registerOre((String)"dyeBrown", (ItemStack)BrownDye.get(1));
    }

    public static void postInit() {
        ItemStack lapisShard = LapisShard.get(1);
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Item.field_77756_aW, 1, 4), (Object[])new Object[]{lapisShard, lapisShard, lapisShard, lapisShard});
        for (ExtraBeeItems item : ExtraBeeItems.values()) {
            if (item.metalString != null) {
                ItemStack dust = null;
                ItemStack ingot = null;
                if (!OreDictionary.getOres((String)("ingot" + item.metalString)).isEmpty()) {
                    ingot = (ItemStack)OreDictionary.getOres((String)("ingot" + item.metalString)).get(0);
                }
                if (!OreDictionary.getOres((String)("dust" + item.metalString)).isEmpty()) {
                    dust = (ItemStack)OreDictionary.getOres((String)("dust" + item.metalString)).get(0);
                }
                ItemStack input = item.get(1);
                if (dust != null) {
                    GameRegistry.addShapelessRecipe((ItemStack)dust, (Object[])new Object[]{input, input, input, input});
                } else if (ingot != null) {
                    GameRegistry.addShapelessRecipe((ItemStack)ingot, (Object[])new Object[]{input, input, input, input, input, input, input, input, input});
                }
            }
            if (item.gemString == null) continue;
            ItemStack gem = null;
            if (!OreDictionary.getOres((String)("gem" + item.gemString)).isEmpty()) {
                gem = (ItemStack)OreDictionary.getOres((String)("gem" + item.gemString)).get(0);
            }
            ItemStack input = item.get(1);
            if (gem == null) continue;
            GameRegistry.addShapelessRecipe((ItemStack)gem, (Object[])new Object[]{input, input, input, input, input, input, input, input, input});
        }
        Item woodGear = null;
        try {
            woodGear = (Item)Class.forName("buildcraft.BuildCraftCore").getField("woodenGearItem").get(null);
        }
        catch (Exception e) {
            // empty catch block
        }
        ItemStack gear = new ItemStack(Block.field_71988_x, 1);
        if (woodGear != null) {
            gear = new ItemStack(woodGear, 1);
        }
        RecipeManagers.carpenterManager.addRecipe(100, LiquidManager.getLiquidStack("honey", 500), null, ScentedGear.get(1), new Object[]{" j ", "bgb", " p ", Character.valueOf('j'), ItemInterface.getItem((String)"royalJelly"), Character.valueOf('b'), ItemInterface.getItem((String)"beeswax"), Character.valueOf('p'), ItemInterface.getItem((String)"pollen"), Character.valueOf('g'), gear});
    }

    private ExtraBeeItems(String name, String iconPath) {
        this.name = name;
        this.iconPath = iconPath;
    }

    private void setGem(String string) {
        this.gemString = string;
    }

    private void setMetal(String string) {
        this.metalString = string;
    }

    @Override
    public boolean isActive() {
        if (this.metalString != null) {
            return !OreDictionary.getOres((String)("ingot" + this.metalString)).isEmpty() || !OreDictionary.getOres((String)("dust" + this.metalString)).isEmpty();
        }
        if (this.gemString != null) {
            return !OreDictionary.getOres((String)("gem" + this.gemString)).isEmpty();
        }
        return true;
    }

    @Override
    public Icon getIcon(ItemStack stack) {
        return this.icon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister register) {
        this.icon = ExtraBees.proxy.getIcon(register, "misc/" + this.iconPath);
    }

    @Override
    public void addInformation(List par3List) {
    }

    @Override
    public String getName(ItemStack stack) {
        return this.name;
    }

    @Override
    public ItemStack get(int i) {
        return new ItemStack(ExtraBees.itemMisc, i, this.ordinal());
    }

    static {
        TinDust.setMetal("Tin");
        ZincDust.setMetal("Zinc");
        CopperDust.setMetal("Copper");
        IronDust.setMetal("Iron");
        NickelDust.setMetal("Nickel");
        LeadDust.setMetal("Lead");
        SilverDust.setMetal("Silver");
        GoldDust.setMetal("Gold");
        PlatinumDust.setMetal("Platinum");
        TungstenDust.setMetal("Tungsten");
        TitaniumDust.setMetal("Titanium");
        DiamondShard.setGem("Diamond");
        EmeraldShard.setGem("Emerald");
        RubyShard.setGem("Ruby");
        SapphireShard.setGem("Sapphire");
    }
}

