/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.apiary.machine;

import binnie.core.machines.Machine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.inventory.ValidatorIcon;
import binnie.craftgui.minecraft.IMachineInformation;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.apiary.ComponentBeeModifier;
import binnie.extrabees.apiary.ComponentExtraBeeGUI;
import binnie.extrabees.apiary.machine.AlvearyMachine;
import binnie.extrabees.core.ExtraBeeGUID;
import binnie.extrabees.core.ExtraBeeTexture;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class AlvearyMutator {
    public static int slotMutator = 0;
    static Map<ItemStack, Float> mutations = new HashMap<ItemStack, Float>();

    public static boolean isMutationItem(ItemStack item) {
        return AlvearyMutator.getMutationMult(item) > 0.0f;
    }

    public static float getMutationMult(ItemStack item) {
        if (item == null) {
            return 1.0f;
        }
        for (ItemStack comp : mutations.keySet()) {
            if (!ItemStack.func_77970_a((ItemStack)item, (ItemStack)comp) || !item.func_77969_a(comp)) continue;
            return mutations.get(comp).floatValue();
        }
        return 1.0f;
    }

    public static void addMutationItem(ItemStack item, float chance) {
        mutations.put(item, Float.valueOf(chance));
    }

    public static class ComponentMutatorModifier
    extends ComponentBeeModifier
    implements IBeeModifier,
    IBeeListener {
        public ComponentMutatorModifier(Machine machine) {
            super(machine);
        }

        @Override
        public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
            if (this.getUtil().isSlotEmpty(slotMutator)) {
                return 1.0f;
            }
            float mult = AlvearyMutator.getMutationMult(this.getUtil().getStack(slotMutator));
            return Math.min(mult, 15.0f / currentModifier);
        }

        @Override
        public void onPostQueenDeath(IBee queen) {
            this.getUtil().decreaseStack(slotMutator, 1);
        }
    }

    public static class SlotValidatorMutator
    extends SlotValidator {
        public SlotValidatorMutator() {
            super(new ValidatorIcon(ExtraBees.instance, "validator/mutator.0", "validator/mutator.1"));
        }

        @Override
        public boolean isValid(ItemStack itemStack) {
            return AlvearyMutator.isMutationItem(itemStack);
        }

        @Override
        public String getTooltip() {
            return "Mutagenic Agents";
        }
    }

    public static class PackageAlvearyMutator
    extends AlvearyMachine.AlvearyPackage
    implements IMachineInformation {
        public PackageAlvearyMutator() {
            super("mutator", "Mutator", ExtraBeeTexture.AlvearyMutator.getTexture());
        }

        @Override
        public void createMachine(Machine machine) {
            new ComponentExtraBeeGUI(machine, ExtraBeeGUID.AlvearyMutator);
            ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
            inventory.addSlot(slotMutator, "Mutator Slot");
            inventory.getSlot(slotMutator).setValidator(new SlotValidatorMutator());
            new ComponentMutatorModifier(machine);
        }

        @Override
        public String getInformation() {
            return "The Mutator uses certain items in order to encourage bee mutation.";
        }
    }
}

