/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.minecraft;

import binnie.craftgui.controls.core.Control;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventWidget;
import binnie.craftgui.events.core.EventHandler;
import binnie.craftgui.minecraft.ControlItemDisplay;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.resource.minecraft.CraftGUITexture;
import net.minecraft.item.ItemStack;

public abstract class ControlSlotBase
extends Control
implements ITooltip {
    ControlItemDisplay itemDisplay;

    public ControlSlotBase(IWidget parent, int x, int y) {
        this(parent, x, y, 18);
    }

    public ControlSlotBase(IWidget parent, int x, int y, int size) {
        super(parent, x, y, size, size);
        this.addAttribute(Attribute.MouseOver);
        this.itemDisplay = new ControlItemDisplay(this, 1, 1, size - 2);
    }

    @EventHandler(origin=EventHandler.Origin.Self)
    public void onResize(EventWidget.ChangeSize event) {
        if (this.itemDisplay != null) {
            this.itemDisplay.setSize(this.getSize().sub(new Vector2f(2.0f, 2.0f)));
        }
    }

    @Override
    public void onRenderBackground() {
        int size = (int)this.getSize().x();
        this.getRenderer().renderTexture((Object)CraftGUITexture.Slot, this.getArea());
        if (this.getSuperParent().getMousedOverWidget() == this) {
            this.getRenderer().renderGradientRect(new Area(new Vector2f(1.0f, 1.0f), this.getArea().size().sub(new Vector2f(2.0f, 2.0f))), -2130706433, -2130706433);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.itemDisplay.setItemStack(this.getItemStack());
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        ItemStack item = this.getItemStack();
        if (item == null) {
            return;
        }
        if (tooltip.getType() == Tooltip.Type.Help) {
            return;
        }
        tooltip.add(item.func_82840_a(((Window)this.getSuperParent()).getPlayer(), false));
    }

    public abstract ItemStack getItemStack();
}

