/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.extratrees.kitchen;

import binnie.core.IBinnieMod;
import binnie.craftgui.controls.ControlTextEdit;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.events.EventValueChanged;
import binnie.craftgui.events.core.EventHandler;
import binnie.craftgui.extratrees.kitchen.ControlCocktailIngredient;
import binnie.craftgui.extratrees.kitchen.ControlDropDownMenu;
import binnie.craftgui.extratrees.kitchen.ControlDropdownButton;
import binnie.craftgui.extratrees.kitchen.ControlSlotCocktail;
import binnie.craftgui.extratrees.kitchen.ControlSlotFluid;
import binnie.craftgui.extratrees.kitchen.ControlSlotGlassware;
import binnie.craftgui.minecraft.MinecraftGUI;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.window.Panel;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.alcohol.Alcohol;
import binnie.extratrees.alcohol.Cocktail;
import binnie.extratrees.alcohol.Glassware;
import binnie.extratrees.alcohol.ICocktailIngredient;
import binnie.extratrees.alcohol.Juice;
import binnie.extratrees.alcohol.Liqueur;
import binnie.extratrees.alcohol.Spirit;
import binnie.extratrees.alcohol.drink.CocktailType;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraftforge.fluids.FluidStack;

public class WindowBar
extends Window {
    Map<ICocktailIngredient, Integer> currentIngredients = new HashMap<ICocktailIngredient, Integer>();
    int totalFluidAmount = 0;
    Glassware glassware = Glassware.Cocktail;
    ControlTextEdit cocktailName;
    public Panel ingredientsPanel;
    ControlSlotCocktail preview;

    public WindowBar(EntityPlayer player, IInventory inventory, Side side) {
        super(340.0f, 192.0f, player, inventory, side);
    }

    @Override
    protected IBinnieMod getMod() {
        return ExtraTrees.instance;
    }

    @Override
    protected String getName() {
        return "Bar";
    }

    @EventHandler(origin=EventHandler.Origin.Any)
    public void onValueChanged(EventValueChanged event) {
        if (event.isOrigin(this.cocktailName)) {
            this.updateCocktail();
        }
    }

    @EventHandler(origin=EventHandler.Origin.Any)
    public void onGenericClick(EventMouse.Down event) {
        if (event.getOrigin() instanceof ControlSlotGlassware) {
            this.glassware = ((ControlSlotGlassware)event.getOrigin()).getValue();
        }
        ICocktailIngredient ingr = null;
        if (event.getOrigin() instanceof ControlSlotFluid) {
            FluidStack fluid = ((ControlSlotFluid)event.getOrigin()).getFluidStack();
            ingr = Cocktail.getIngredient(fluid.getFluid().getName());
        } else if (event.getOrigin() instanceof ControlCocktailIngredient) {
            ingr = ((ControlCocktailIngredient)event.getOrigin()).ingredient;
        } else if (event.getOrigin().getParent() instanceof ControlCocktailIngredient) {
            ingr = ((ControlCocktailIngredient)event.getOrigin().getParent()).ingredient;
        }
        if (ingr != null) {
            if (event.getButton() == 0) {
                if (this.currentIngredients.containsKey(ingr)) {
                    this.currentIngredients.put(ingr, this.currentIngredients.get(ingr) + 1);
                } else {
                    this.currentIngredients.put(ingr, 1);
                }
            } else if (this.currentIngredients.containsKey(ingr)) {
                if (this.currentIngredients.get(ingr) == 1) {
                    this.currentIngredients.remove(ingr);
                } else {
                    this.currentIngredients.put(ingr, this.currentIngredients.get(ingr) - 1);
                }
            }
        }
        this.updateCocktail();
    }

    public void updateCocktail() {
        CocktailType cocktail = new CocktailType(this.glassware, this.currentIngredients);
        if (!this.cocktailName.getValue().isEmpty()) {
            cocktail.setName(this.cocktailName.getValue());
        }
        this.preview.setValue(cocktail);
        this.ingredientsPanel.deleteAllChildren();
        int y = 1;
        for (Map.Entry<ICocktailIngredient, Integer> ingr2 : this.currentIngredients.entrySet()) {
            new ControlCocktailIngredient(this.ingredientsPanel, 1.0f, y).setValue(ingr2.getKey(), ingr2.getValue());
            y += 14;
        }
    }

    @Override
    public void initialize() {
        this.setTitle("Bar");
        this.preview = new ControlSlotCocktail((IWidget)this, 20, 50, null);
        this.preview.setSize(new Vector2f(72.0f, 72.0f));
        CocktailType cocktail = new CocktailType(Glassware.Pint, Cocktail.Cosmopolitan);
        this.preview.setValue(cocktail);
        this.cocktailName = new ControlTextEdit(this, 172.0f, 24.0f, 130.0f, 16.0f);
        this.ingredientsPanel = new Panel(this, 100.0f, 50.0f, 202.0f, 82.0f, MinecraftGUI.PanelType.Black);
        int x = 12;
        int y = 24;
        new ControlDropdownButton(this, x, y, 74.0f, 18.0f, "Glassware"){

            @Override
            public ControlDropDownMenu createDropDownMenu() {
                Glassware[] glassware = Glassware.values();
                int height = 1 + glassware.length / 4;
                ControlDropDownMenu menu = new ControlDropDownMenu(this, 0.0f, this.getSize().y(), this.getSize().x(), 56.0f);
                int x = 0;
                int y = 0;
                for (Glassware glass : Glassware.values()) {
                    ControlSlotGlassware control = new ControlSlotGlassware((IWidget)menu, 1 + x, 1 + y, glass);
                    control.setCroppedZone(menu, menu.getArea());
                    if ((x += 18) < 72) continue;
                    x = 0;
                    y += 18;
                }
                return menu;
            }
        };
        new ControlDropdownButton(this, x + 72 + 8, y, 74.0f, 18.0f, "Liquids"){

            @Override
            public ControlDropDownMenu createDropDownMenu() {
                ControlDropDownMenu menu = new ControlDropDownMenu(this, 0.0f, this.getSize().y(), this.getSize().x(), 90.0f);
                int by = 0;
                new ControlDropdownButton(menu, 0.0f, by, 74.0f, 18.0f, "Juices"){

                    @Override
                    public ControlDropDownMenu createDropDownMenu() {
                        Juice[] glassware = Juice.values();
                        int height = 1 + glassware.length / 4;
                        ControlDropDownMenu menu = new ControlDropDownMenu(this, this.getSize().x(), -this.getPosition().y(), this.getSize().x(), 18 * height + 2);
                        int x = 0;
                        int y = 0;
                        for (Juice glass : Juice.values()) {
                            ControlSlotFluid control = new ControlSlotFluid(menu, 1 + x, 1 + y, glass.get(1));
                            control.setCroppedZone(menu, menu.getArea());
                            if ((x += 18) < 72) continue;
                            x = 0;
                            y += 18;
                        }
                        return menu;
                    }
                };
                new ControlDropdownButton(menu, 0.0f, by += 18, 74.0f, 18.0f, "Alcohol"){

                    @Override
                    public ControlDropDownMenu createDropDownMenu() {
                        Alcohol[] glassware = Alcohol.values();
                        int height = 1 + glassware.length / 4;
                        ControlDropDownMenu menu = new ControlDropDownMenu(this, this.getSize().x(), -this.getPosition().y(), this.getSize().x(), 18 * height + 2);
                        int x = 0;
                        int y = 0;
                        for (Alcohol glass : Alcohol.values()) {
                            ControlSlotFluid control = new ControlSlotFluid(menu, 1 + x, 1 + y, glass.get(1));
                            control.setCroppedZone(menu, menu.getArea());
                            if ((x += 18) < 72) continue;
                            x = 0;
                            y += 18;
                        }
                        return menu;
                    }
                };
                new ControlDropdownButton(menu, 0.0f, by += 18, 74.0f, 18.0f, "Spirits"){

                    @Override
                    public ControlDropDownMenu createDropDownMenu() {
                        Spirit[] glassware = Spirit.values();
                        int height = 1 + glassware.length / 4;
                        ControlDropDownMenu menu = new ControlDropDownMenu(this, this.getSize().x(), -this.getPosition().y(), this.getSize().x(), 18 * height + 2);
                        int x = 0;
                        int y = 0;
                        for (Spirit glass : Spirit.values()) {
                            ControlSlotFluid control = new ControlSlotFluid(menu, 1 + x, 1 + y, glass.get(1));
                            control.setCroppedZone(menu, menu.getArea());
                            if ((x += 18) < 72) continue;
                            x = 0;
                            y += 18;
                        }
                        return menu;
                    }
                };
                new ControlDropdownButton(menu, 0.0f, by += 18, 74.0f, 18.0f, "Liqueurs"){

                    @Override
                    public ControlDropDownMenu createDropDownMenu() {
                        Liqueur[] glassware = Liqueur.values();
                        int height = 1 + glassware.length / 4;
                        ControlDropDownMenu menu = new ControlDropDownMenu(this, this.getSize().x(), -this.getPosition().y(), this.getSize().x(), 18 * height + 2);
                        int x = 0;
                        int y = 0;
                        for (Liqueur glass : Liqueur.values()) {
                            ControlSlotFluid control = new ControlSlotFluid(menu, 1 + x, 1 + y, glass.get(1));
                            control.setCroppedZone(menu, menu.getArea());
                            if ((x += 18) < 72) continue;
                            x = 0;
                            y += 18;
                        }
                        return menu;
                    }
                };
                return menu;
            }
        };
    }

    public static Window create(EntityPlayer player, IInventory inventory, Side side) {
        return new WindowBar(player, inventory, side);
    }
}

