/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.extratrees.dictionary;

import binnie.core.IBinnieMod;
import binnie.core.machines.Machine;
import binnie.craftgui.core.geometry.Direction;
import binnie.craftgui.extratrees.dictionary.ControlFruitPressProgress;
import binnie.craftgui.minecraft.ControlEnergyBar;
import binnie.craftgui.minecraft.ControlErrorState;
import binnie.craftgui.minecraft.ControlLiquidTank;
import binnie.craftgui.minecraft.ControlPlayerInventory;
import binnie.craftgui.minecraft.ControlSlot;
import binnie.craftgui.minecraft.CustomSlot;
import binnie.craftgui.minecraft.Window;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.machines.FruitPress;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;

public class WindowFruitPress
extends Window {
    public WindowFruitPress(EntityPlayer player, IInventory inventory, Side side) {
        super(194.0f, 192.0f, player, inventory, side);
    }

    @Override
    protected IBinnieMod getMod() {
        return ExtraTrees.instance;
    }

    @Override
    protected String getName() {
        return "FruitPress";
    }

    @Override
    public void initialize() {
        this.setTitle("Fruit Press");
        new ControlSlot(this, 24, 52).create(this.getInventory(), FruitPress.slotFruit);
        new ControlLiquidTank(this, 99, 32).setTankID(FruitPress.tankWater);
        new ControlEnergyBar(this, 154, 32, 16, 60, Direction.Upwards);
        new ControlPlayerInventory(this);
        new ControlErrorState(this, 128.0f, 54.0f);
        new ControlFruitPressProgress(this, 62.0f, 24.0f);
        ((Window)this.getSuperParent()).getContainer().newSlot(new CustomSlot(this.getInventory(), FruitPress.slotCurrent, 0, 0));
    }

    public static Window create(EntityPlayer player, IInventory inventory, Side side) {
        return new WindowFruitPress(player, inventory, side);
    }

    @Override
    public void recieveNBT(Side side, EntityPlayer player, NBTTagCompound action) {
        FruitPress.ComponentFruitPressLogic logic = Machine.getInterface(FruitPress.ComponentFruitPressLogic.class, this.getInventory());
        super.recieveNBT(side, player, action);
        if (side == Side.SERVER && action.func_74740_e().equals("fruitpress-click")) {
            if (logic.canWork() == null && logic.canProgress() == null) {
                logic.alterProgress(2.0f);
            } else if (side == Side.SERVER && action.func_74740_e().equals("clear-fruit")) {
                logic.setProgress(0.0f);
                this.getInventory().func_70299_a(FruitPress.slotCurrent, null);
            }
        }
    }
}

