/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.extratrees.dictionary;

import binnie.core.machines.Machine;
import binnie.core.machines.power.IProcess;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.core.geometry.Direction;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.events.core.EventHandler;
import binnie.craftgui.minecraft.ControlProgress;
import binnie.craftgui.minecraft.ControlProgressBase;
import binnie.craftgui.minecraft.IRendererMinecraft;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.resource.ITexture;
import binnie.craftgui.resource.minecraft.StandardTexture;
import binnie.extratrees.core.ExtraTreeTexture;
import binnie.extratrees.machines.Distillery;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class ControlDistilleryProgress
extends ControlProgressBase
implements ITooltip {
    static ITexture DistilleryBase = new StandardTexture(43, 0, 58, 66, ExtraTreeTexture.Gui);
    static ITexture DistilleryOverlay = new StandardTexture(139, 0, 18, 66, ExtraTreeTexture.Gui);
    static ITexture LiquidFlow = new StandardTexture(101, 0, 38, 66, ExtraTreeTexture.Gui);
    static ITexture Output = new StandardTexture(68, 66, 17, 7, ExtraTreeTexture.Gui);
    float progress = 0.0f;

    @Override
    public void onUpdate() {
        IProcess process = Machine.getInterface(IProcess.class, Window.get(this).getInventory());
        if (process == null) {
            return;
        }
        this.progress = process.getProgress() / 100.0f;
    }

    @Override
    public void onRenderBackground() {
        this.getRenderer().renderTexture((Object)DistilleryBase, new Vector2f(0.0f, 0.0f));
        this.getRenderer().renderSubTexture(LiquidFlow, new Area(18.0f, 0.0f, 38.0f, 66.0f), Direction.Right, this.progress);
        Distillery.ComponentDistilleryLogic component = Machine.getInterface(Distillery.ComponentDistilleryLogic.class, Window.get(this).getInventory());
        FluidStack stack = null;
        if (component != null) {
            stack = component.currentFluid;
        }
        if (stack != null) {
            for (int y = 0; y < 4; ++y) {
                this.renderFluid(stack, new Vector2f(1.0f, 1 + y * 16));
            }
        }
    }

    @Override
    public void onRenderForeground() {
        int level = Machine.getInterface(Distillery.ComponentDistilleryLogic.class, (Object)Window.get((IWidget)this).getInventory()).level;
        this.getRenderer().renderTexture((Object)Output, new Vector2f(47.0f, 14 + level * 15));
        this.getRenderer().renderTexture((Object)DistilleryOverlay, new Vector2f(0.0f, 0.0f));
    }

    protected ControlDistilleryProgress(IWidget parent, float x, float y) {
        super(parent, x, y, 58.0f, 66.0f);
        this.addAttribute(Attribute.MouseOver);
    }

    @EventHandler(origin=EventHandler.Origin.Self)
    public void onClick(EventMouse.Down event) {
        int distillationLevel = -1;
        if (new Area(45.0f, 8.0f, 19.0f, 11.0f).contains(this.getRelativeMousePosition())) {
            distillationLevel = 0;
        } else if (new Area(45.0f, 23.0f, 19.0f, 11.0f).contains(this.getRelativeMousePosition())) {
            distillationLevel = 1;
        } else if (new Area(45.0f, 38.0f, 19.0f, 11.0f).contains(this.getRelativeMousePosition())) {
            distillationLevel = 2;
        }
        if (distillationLevel >= 0) {
            NBTTagCompound nbt = new NBTTagCompound("change-still-level");
            nbt.func_74774_a("lvl", (byte)distillationLevel);
            Window.get(this).sendClientAction(nbt);
        }
    }

    public void renderFluid(FluidStack fluid, Vector2f pos) {
        int hex = fluid.getFluid().getColor();
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        Icon icon = fluid.getFluid().getIcon();
        GL11.glColor4f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.getRenderer().subRenderer(IRendererMinecraft.class).renderBlockIcon(pos, fluid.getFluid().getIcon());
        GL11.glDisable((int)3042);
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        Distillery.ComponentDistilleryLogic process = Machine.getInterface(Distillery.ComponentDistilleryLogic.class, Window.get(this).getInventory());
        if (tooltip.getType() == Tooltip.Type.Help && process != null) {
            tooltip.add("Distillery");
            if (process.currentFluid == null) {
                tooltip.add("Empty");
            } else {
                tooltip.add(process.getTooltip() + " (" + (int)process.getProgress() + "%)");
            }
            float eff = process.getEfficiency();
            if (eff == 0.0f) {
                tooltip.add("Time Left: Infinite");
            } else {
                tooltip.add("Time Left: " + ControlProgress.convertTime((int)((1.0f - this.progress) * (float)process.getProcessLength() / eff)));
            }
            tooltip.add("Total Time: " + ControlProgress.convertTime(process.getProcessLength()));
            tooltip.add("Energy Cost: " + process.getProcessEnergy() + " MJ");
        }
    }
}

