/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.extratrees.dictionary;

import binnie.core.machines.Machine;
import binnie.core.machines.power.IProcess;
import binnie.core.util.ItemStackSet;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.events.core.EventHandler;
import binnie.craftgui.minecraft.ControlProgress;
import binnie.craftgui.minecraft.ControlProgressBase;
import binnie.craftgui.minecraft.IRendererMinecraft;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.resource.ITexture;
import binnie.craftgui.resource.minecraft.StandardTexture;
import binnie.extratrees.core.ExtraTreeTexture;
import binnie.extratrees.machines.Brewery;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class ControlBreweryProgress
extends ControlProgressBase
implements ITooltip {
    static ITexture Brewery = new StandardTexture(0, 69, 34, 39, ExtraTreeTexture.Gui);
    static ITexture BreweryOverlay = new StandardTexture(34, 69, 34, 39, ExtraTreeTexture.Gui);
    float progress = 0.0f;

    @Override
    public void onUpdate() {
        IProcess process = Machine.getInterface(IProcess.class, Window.get(this).getInventory());
        if (process == null) {
            return;
        }
        this.progress = process.getProgress() / 100.0f;
    }

    @Override
    public void onRenderBackground() {
        this.getRenderer().renderTexture((Object)Brewery, new Vector2f(0.0f, 0.0f));
        Brewery.ComponentBreweryLogic logic = Machine.getInterface(Brewery.ComponentBreweryLogic.class, Window.get(this).getInventory());
        if (logic.currentCrafting == null) {
            return;
        }
        if (logic.currentCrafting.currentInput == null) {
            return;
        }
        int fermentedHeight = (int)(32.0f * logic.getProgress() / 100.0f);
        this.getRenderer().limitArea(new Area(new Vector2f(1.0f, 6.0f).add(this.getAbsolutePosition()), new Vector2f(32.0f, 32 - fermentedHeight)));
        GL11.glEnable((int)3089);
        this.renderFluid(logic.currentCrafting.currentInput, new Vector2f(1.0f, 6.0f));
        this.renderFluid(logic.currentCrafting.currentInput, new Vector2f(17.0f, 6.0f));
        this.renderFluid(logic.currentCrafting.currentInput, new Vector2f(1.0f, 22.0f));
        this.renderFluid(logic.currentCrafting.currentInput, new Vector2f(17.0f, 22.0f));
        GL11.glDisable((int)3089);
        this.getRenderer().limitArea(new Area(new Vector2f(1.0f, 38 - fermentedHeight).add(this.getAbsolutePosition()), new Vector2f(32.0f, fermentedHeight)));
        GL11.glEnable((int)3089);
        this.renderFluid(binnie.extratrees.machines.Brewery.getOutput(logic.currentCrafting), new Vector2f(1.0f, 6.0f));
        this.renderFluid(binnie.extratrees.machines.Brewery.getOutput(logic.currentCrafting), new Vector2f(17.0f, 6.0f));
        this.renderFluid(binnie.extratrees.machines.Brewery.getOutput(logic.currentCrafting), new Vector2f(1.0f, 22.0f));
        this.renderFluid(binnie.extratrees.machines.Brewery.getOutput(logic.currentCrafting), new Vector2f(17.0f, 22.0f));
        GL11.glDisable((int)3089);
        ItemStackSet stacks = new ItemStackSet();
        for (ItemStack stack : logic.currentCrafting.inputs) {
            stacks.add(stack);
        }
        stacks.add(logic.currentCrafting.ingr);
        int x = 1;
        int y = 6;
        for (ItemStack stack : stacks) {
            this.getRenderer(IRendererMinecraft.class).renderItem(new Vector2f(x, y), stack);
            if ((x += 16) <= 18) continue;
            x = 1;
            y += 16;
        }
    }

    @Override
    public void onRenderForeground() {
        this.getRenderer().renderTexture((Object)BreweryOverlay, new Vector2f(0.0f, 0.0f));
    }

    protected ControlBreweryProgress(IWidget parent, float x, float y) {
        super(parent, x, y, 34.0f, 39.0f);
        this.addAttribute(Attribute.MouseOver);
    }

    @EventHandler(origin=EventHandler.Origin.Self)
    public void onClick(EventMouse.Down event) {
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        Brewery.ComponentBreweryLogic process = this.getProcess();
        if (tooltip.getType() == Tooltip.Type.Help && process != null) {
            tooltip.add("Fermenter");
            if (process.currentCrafting == null) {
                tooltip.add("Empty");
            } else {
                tooltip.add(process.getTooltip() + " (" + (int)process.getProgress() + "%)");
            }
            float eff = process.getEfficiency();
            if (eff == 0.0f) {
                tooltip.add("Time Left: Infinite");
            } else {
                tooltip.add("Time Left: " + ControlProgress.convertTime((int)((1.0f - this.progress) * (float)process.getProcessLength() / eff)));
            }
            tooltip.add("Total Time: " + ControlProgress.convertTime(process.getProcessLength()));
            tooltip.add("Energy Cost: " + process.getProcessEnergy() + " MJ");
        }
    }

    public void renderFluid(FluidStack fluid, Vector2f pos) {
        int hex = fluid.getFluid().getColor();
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        Icon icon = fluid.getFluid().getIcon();
        GL11.glColor4f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.getRenderer().subRenderer(IRendererMinecraft.class).renderBlockIcon(pos, fluid.getFluid().getIcon());
        GL11.glDisable((int)3042);
    }

    private Brewery.ComponentBreweryLogic getProcess() {
        return Machine.getInterface(Brewery.ComponentBreweryLogic.class, Window.get(this).getInventory());
    }
}

