/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.extrabees.punnett;

import binnie.core.IBinnieMod;
import binnie.core.machines.inventory.SlotValidator;
import binnie.craftgui.controls.ControlTextCentered;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.extrabees.punnett.ControlChromosomes;
import binnie.craftgui.extrabees.punnett.ControlPunnett;
import binnie.craftgui.extrabees.punnett.ExtraBeeGUITexture;
import binnie.craftgui.minecraft.ControlPlayerInventory;
import binnie.craftgui.minecraft.ControlSlot;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.resource.StyleSheet;
import binnie.craftgui.resource.minecraft.CraftGUITexture;
import binnie.craftgui.resource.minecraft.PaddedTexture;
import binnie.craftgui.resource.minecraft.StandardTexture;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.core.ExtraBeeTexture;
import cpw.mods.fml.relauncher.Side;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class WindowPunnettSquare
extends Window {
    ControlSlot bee1;
    ControlSlot bee2;
    ControlChromosomes controlChromosomes;
    ControlPunnett punnett;
    ISpeciesRoot root = null;

    public static Window create(EntityPlayer player, IInventory inventory, Side side) {
        return new WindowPunnettSquare(player, inventory, side);
    }

    public WindowPunnettSquare(EntityPlayer player, IInventory inventory, Side side) {
        super(245.0f, 205.0f, player, inventory, side);
        if (!this.isServer()) {
            this.stylesheet = new StyleSheetPunnett();
        }
    }

    @Override
    public IBinnieMod getMod() {
        return ExtraBees.instance;
    }

    @Override
    public String getName() {
        return "Punnett";
    }

    @Override
    public void initialize() {
        this.setTitle("Punnett Square");
        int x = (int)(this.size().x() / 2.0f);
        this.getWindowInventory().createSlot(0, new SlotValidator.Individual());
        this.getWindowInventory().createSlot(1, new SlotValidator.Individual());
        this.bee1 = new ControlSlot(this, x - 18 - 10, 23);
        this.bee1.create(this.getWindowInventory(), 0);
        this.bee2 = new ControlSlot(this, x + 10, 23);
        this.bee2.create(this.getWindowInventory(), 1);
        new ControlTextCentered((IWidget)this, 28.0f, "X").setColour(0xAAAAAA);
        new ControlPlayerInventory(this);
        this.punnett = new ControlPunnett(this, 24.0f, 80.0f);
        this.controlChromosomes = new ControlChromosomes(this, 25.0f, 46.0f, 26.0f, 200.0f);
    }

    @Override
    public void onWindowInventoryChanged() {
        ISpeciesRoot root1 = AlleleManager.alleleRegistry.getSpeciesRoot(this.bee1.getItemStack());
        ISpeciesRoot root2 = AlleleManager.alleleRegistry.getSpeciesRoot(this.bee2.getItemStack());
        ISpeciesRoot newRoot = null;
        newRoot = root1 != root2 ? null : root1;
        if (this.root != newRoot) {
            this.root = newRoot;
            if (this.root != null) {
                this.controlChromosomes.setValues(this.root.getKaryotype());
            } else {
                this.controlChromosomes.setValues(new IChromosomeType[0]);
            }
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        IIndividual b1 = AlleleManager.alleleRegistry.getIndividual(this.bee1.getItemStack());
        IIndividual b2 = AlleleManager.alleleRegistry.getIndividual(this.bee2.getItemStack());
        this.punnett.setup(this.controlChromosomes.getValue(), b1, b2, this.root);
    }

    static class StyleSheetPunnett
    extends StyleSheet {
        public StyleSheetPunnett() {
            this.textures.put(CraftGUITexture.Window, new PaddedTexture(0, 0, 160, 160, 0, ExtraBeeTexture.GUIPunnett, 32, 32, 32, 32));
            this.textures.put(CraftGUITexture.Slot, new StandardTexture(160, 0, 18, 18, 0, ExtraBeeTexture.GUIPunnett));
            this.textures.put(ExtraBeeGUITexture.Chromosome, new StandardTexture(160, 36, 16, 16, 0, ExtraBeeTexture.GUIPunnett));
            this.textures.put(ExtraBeeGUITexture.Chromosome2, new StandardTexture(160, 52, 16, 16, 0, ExtraBeeTexture.GUIPunnett));
        }
    }
}

