/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.extrabees.indexer;

import binnie.core.IBinnieMod;
import binnie.craftgui.controls.button.ControlEnumButton;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventValueChanged;
import binnie.craftgui.events.core.EventHandler;
import binnie.craftgui.extrabees.indexer.ControlIndexerPanel;
import binnie.craftgui.minecraft.ControlPlayerInventory;
import binnie.craftgui.minecraft.Window;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.machines.tile.TileEntityIndexer;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class WindowIndexer
extends Window {
    EntityPlayer player;
    ControlPlayerInventory playerInventory;
    TileEntityIndexer machine;
    ControlEnumButton<TileEntityIndexer.Mode> modeButton;
    int guiRefreshCounter = 0;
    ControlIndexerPanel indexerPanel;

    public WindowIndexer(EntityPlayer player, IInventory inventory, Side side) {
        super(320.0f, 168.0f, player, inventory, side);
        this.player = player;
        this.machine = (TileEntityIndexer)inventory;
    }

    public static Window create(EntityPlayer player, IInventory inventory, Side side) {
        if (player == null || inventory == null) {
            return null;
        }
        return new WindowIndexer(player, inventory, side);
    }

    @Override
    public void initialize() {
        this.setTitle("Indexer");
        this.playerInventory = new ControlPlayerInventory(this);
        this.playerInventory.setPosition(new Vector2f(130.0f, 76.0f));
        this.indexerPanel = new ControlIndexerPanel(this, 16.0f, 32.0f, 98.0f, 120.0f);
        this.modeButton = new ControlEnumButton<TileEntityIndexer.Mode>((IWidget)this, 180.0f, 40.0f, 64.0f, 18.0f, TileEntityIndexer.Mode.class);
        this.refreshIndexer();
    }

    private void refreshIndexer() {
        this.guiRefreshCounter = this.machine.guiRefreshCounter;
        this.indexerPanel.onIndexerChange();
    }

    @EventHandler(origin=EventHandler.Origin.Any)
    public void onValueChanged(EventValueChanged event) {
        if (event.isOrigin(this.modeButton)) {
            this.machine.setMode(this.modeButton.getValue());
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.modeButton.setValue(this.machine.getMode());
        if (this.machine.guiRefreshCounter != this.guiRefreshCounter) {
            this.refreshIndexer();
        }
    }

    @Override
    public void onInventoryUpdate() {
        if (this.machine.guiRefreshCounter != this.guiRefreshCounter) {
            this.refreshIndexer();
        }
    }

    @Override
    public IBinnieMod getMod() {
        return ExtraBees.instance;
    }

    @Override
    public String getName() {
        return "Indexer";
    }
}

