/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.extrabees.database;

import binnie.core.BinnieCore;
import binnie.core.genetics.BinnieGenetics;
import binnie.craftgui.controls.listbox.ControlList;
import binnie.craftgui.controls.listbox.ControlListBox;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.extrabees.database.ControlProductsItem;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.IAllele;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class ControlProductsBox
extends ControlListBox<Product> {
    private int index;
    private Type type;
    IAlleleBeeSpecies species = null;

    @Override
    public IWidget createOption(Product value, int y) {
        return new ControlProductsItem((ControlList)this.getContent(), value, y);
    }

    public ControlProductsBox(IWidget parent, int x, int y, int width, int height, Type type) {
        super(parent, x, y, width, height, 12.0f);
        this.type = type;
    }

    public void setSpecies(IAlleleBeeSpecies species) {
        if (species != this.species) {
            this.species = species;
            if (species != null) {
                IAllele[] template = BinnieGenetics.getBeeRoot().getTemplate(species.getUID());
                if (template == null) {
                    return;
                }
                IBeeGenome genome = BinnieGenetics.getBeeRoot().templateAsGenome(template);
                float speed = genome.getSpeed();
                float modeSpeed = BinnieGenetics.getBeeRoot().getBeekeepingMode(BinnieCore.proxy.getWorld()).getProductionModifier(genome, 1.0f);
                ArrayList<Product> strings = new ArrayList<Product>();
                if (this.type == Type.Products) {
                    for (Map.Entry entry : species.getProducts().entrySet()) {
                        strings.add(new Product((ItemStack)entry.getKey(), speed * modeSpeed * (float)((Integer)entry.getValue()).intValue()));
                    }
                } else {
                    for (Map.Entry entry : species.getSpecialty().entrySet()) {
                        strings.add(new Product((ItemStack)entry.getKey(), speed * modeSpeed * (float)((Integer)entry.getValue()).intValue()));
                    }
                }
                this.setOptions(strings);
            }
        }
    }

    class Product {
        ItemStack item;
        float chance;

        public Product(ItemStack item, float chance) {
            this.item = item;
            this.chance = chance;
        }
    }

    static enum Type {
        Products,
        Specialties;

    }
}

