/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.controls.scroll;

import binnie.craftgui.controls.core.Control;
import binnie.craftgui.controls.scroll.ControlScroll;
import binnie.craftgui.controls.scroll.IControlScrollable;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.events.core.EventHandler;

public class ControlScrollableContent<T extends IWidget>
extends Control
implements IControlScrollable {
    protected T controlChild;
    float percentageIndex = 0.0f;
    int percentageIndexOffset = 0;

    @EventHandler(origin=EventHandler.Origin.Any)
    public void onMouseWheel(EventMouse.Wheel event) {
        if (this.getRelativeMousePosition().x() > 0.0f && this.getRelativeMousePosition().y() > 0.0f && this.getRelativeMousePosition().x() < this.getSize().x() && this.getRelativeMousePosition().y() < this.getSize().y()) {
            float percentageMove = 2.0f / this.getSize().y();
            this.movePercentage(percentageMove * (float)(-event.getDWheel()));
        }
    }

    public ControlScrollableContent(IWidget parent, float x, float y, float w, float h, float scrollBarSize) {
        super(parent, x, y, w, h);
        new ControlScroll(this, this.getSize().x() - scrollBarSize, 0.0f, scrollBarSize, this.getSize().y(), this);
    }

    public void setScrollableContent(T child) {
        this.controlChild = child;
        child.setCroppedZone(this, new Area(1.0f, 1.0f, this.getSize().x() - 14.0f, this.getSize().y() - 2.0f));
    }

    public T getContent() {
        return this.controlChild;
    }

    @Override
    public float getPercentageShown() {
        float shown = this.getSize().y() / this.controlChild.getSize().y();
        return Math.min(shown, 1.0f);
    }

    @Override
    public float getPercentageIndex() {
        return this.percentageIndex;
    }

    @Override
    public void movePercentage(float percentage) {
        this.percentageIndex += percentage;
        this.percentageIndexOffset = 0;
        if (this.percentageIndex + this.getPercentageShown() > 1.0f) {
            this.percentageIndex = 1.0f - this.getPercentageShown();
            this.percentageIndexOffset = 1;
        }
        if (this.percentageIndex < 0.0f) {
            this.percentageIndex = 0.0f;
        }
        this.controlChild.setOffset(new Vector2f(0.0f, -this.percentageIndex * this.controlChild.getSize().y() - (float)this.percentageIndexOffset));
    }

    @Override
    public void setPercentageIndex(float index) {
        this.movePercentage(index - this.percentageIndex);
    }

    @Override
    public void onUpdate() {
        this.setPercentageIndex(this.getPercentageIndex());
    }
}

