/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.controls.listbox;

import binnie.craftgui.controls.core.Control;
import binnie.craftgui.controls.core.IControlValue;
import binnie.craftgui.controls.listbox.ControlListBox;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventValueChanged;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class ControlList<T>
extends Control
implements IControlValue<T> {
    ControlListBox<T> parent;
    T value = null;
    Map<T, IWidget> options = new LinkedHashMap<T, IWidget>();
    boolean creating = false;

    protected ControlList(ControlListBox<T> parent, float x, float y, float w, float h) {
        super(parent, x, y, w, h);
        this.parent = parent;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
        if (value != null && this.options.containsKey(value)) {
            float top = this.options.get(value).pos().y();
            float bottom = this.options.get(value).pos().y() + this.options.get(value).size().y();
            if (top / this.size().y() < this.parent.getPercentageIndex()) {
                this.parent.setPercentageIndex(top / this.size().y());
            }
            if (bottom / this.size().y() > this.parent.getPercentageIndex() + this.parent.getPercentageShown()) {
                this.parent.setPercentageIndex(bottom / this.size().y() - this.parent.getPercentageShown());
            }
        }
        if (!this.creating) {
            this.getParent().callEvent(new EventValueChanged<T>(this.getParent(), value));
        }
        this.creating = false;
    }

    public void setOptions(Collection<T> options) {
        int height = 0;
        for (IWidget option : this.options.values()) {
            this.deleteChild(option);
        }
        this.options.clear();
        int i = 0;
        for (T option : options) {
            IWidget optionWidget = ((ControlListBox)this.getParent()).createOption(option, height);
            if (optionWidget != null) {
                height = (int)((float)height + optionWidget.getSize().y());
                this.options.put(option, optionWidget);
            }
            ++i;
        }
        this.creating = true;
        this.setValue(this.getValue());
        this.setSize(new Vector2f(this.getSize().x(), height));
    }

    public Collection<T> getOptions() {
        return this.options.keySet();
    }

    public int getIndexOf(T value) {
        int index = 0;
        for (T option : this.getOptions()) {
            if (option.equals(value)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getCurrentIndex() {
        return this.getIndexOf(this.getValue());
    }

    public void setIndex(int currentIndex) {
        int index = 0;
        for (T option : this.getOptions()) {
            if (index == currentIndex) {
                this.setValue(option);
                return;
            }
            ++index;
        }
        this.setValue(null);
    }
}

