/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.controls.button;

import binnie.craftgui.controls.button.ControlButton;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.events.EventValueChanged;
import java.util.ArrayList;
import java.util.List;

public class ControlEnumButton<T extends Enum<T>>
extends ControlButton {
    public static final String eventEnumChanged = "eventEnumButtonChanged";
    private T currentSelection;
    private List<T> enumConstants = new ArrayList<T>();

    @Override
    public String getText() {
        return ((Enum)this.currentSelection).toString();
    }

    @Override
    public void onMouseClick(EventMouse.Down event) {
        int index = this.enumConstants.indexOf(this.currentSelection);
        index = index < this.enumConstants.size() - 1 ? ++index : 0;
        Enum newEnum = (Enum)this.enumConstants.get(index);
        this.setValue(newEnum);
    }

    public void setValue(T selection) {
        if (this.currentSelection != selection) {
            this.currentSelection = selection;
            this.callEvent(new EventValueChanged<T>(this, this.getValue()));
        }
    }

    public ControlEnumButton(IWidget parent, float x, float y, float width, float height, Class<T> enumClass) {
        super(parent, x, y, width, height, "");
        if (enumClass.getEnumConstants() != null) {
            int length = ((Enum[])enumClass.getEnumConstants()).length;
            float tabHeight = height / (float)length;
            for (int i = 0; i < length; ++i) {
                this.enumConstants.add(((Enum[])enumClass.getEnumConstants())[i]);
            }
            this.currentSelection = (Enum)this.enumConstants.get(0);
        }
    }

    public T getValue() {
        return this.currentSelection;
    }
}

