/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.controls;

import binnie.craftgui.controls.ControlText;
import binnie.craftgui.controls.core.Control;
import binnie.craftgui.controls.core.IControlValue;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.CraftGUIUtil;
import binnie.craftgui.core.geometry.TextJustification;
import binnie.craftgui.events.EventKey;
import binnie.craftgui.events.EventValueChanged;
import binnie.craftgui.events.EventWidget;
import binnie.craftgui.events.core.EventHandler;

public class ControlTextEdit
extends Control
implements IControlValue<String> {
    char[] allowedCharacters = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'T', 'Z', ' ', '(', ')', '[', ']'};
    ControlText text = new ControlText(this, CraftGUIUtil.getPaddedArea(this.getArea(), 2), "", TextJustification.MiddleLeft);

    @EventHandler(origin=EventHandler.Origin.Self)
    public void onKeyTyped(EventKey.Down event) {
        if (event.getKey() == 14 && this.text.getValue().length() > 0) {
            this.text.setValue(this.text.getValue().substring(0, this.text.getValue().length() - 1));
        } else {
            char character = event.getCharacter();
            for (char allowed : this.allowedCharacters) {
                if (character != allowed) continue;
                this.text.setValue(this.text.getValue() + allowed);
            }
        }
        this.callEvent(new EventValueChanged<String>(this, this.text.getValue()));
    }

    public ControlTextEdit(IWidget parent, float x, float y, float width, float height) {
        super(parent, x, y, width, height);
        this.text.setColour(0);
        this.setColour(0xAAAAAA);
        this.addAttribute(Attribute.CanFocus);
        this.addAttribute(Attribute.MouseOver);
    }

    @EventHandler(origin=EventHandler.Origin.Self)
    public void gainFocus(EventWidget.GainFocus event) {
        this.setColour(0xFFFFFF);
        this.text.setColour(0xFFFFFF);
    }

    @EventHandler(origin=EventHandler.Origin.Self)
    public void loseFocus(EventWidget.LoseFocus event) {
        this.setColour(0xAAAAAA);
        this.text.setColour(0);
    }

    @Override
    public String getValue() {
        return this.text.getValue();
    }

    @Override
    public void setValue(String value) {
        this.text.setValue(value);
    }

    @EventHandler(origin=EventHandler.Origin.DirectChild)
    public void onTextChanged(EventValueChanged<String> event) {
        this.callEvent(new EventValueChanged<String>(this, event.getValue()));
    }
}

