/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.triggers;

import binnie.core.BinnieCore;
import binnie.core.IBinnieMod;
import binnie.core.resource.BinnieIcon;
import binnie.core.resource.ResourceManager;
import binnie.core.triggers.TriggerProvider;
import binnie.extrabees.ExtraBees;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public final class BinnieTrigger
implements ITrigger {
    public static int incrementalID = 800;
    protected static ITrigger triggerNoBlankTemplate;
    protected static ITrigger triggerNoTemplate;
    protected static ITrigger triggerIsWorking;
    protected static ITrigger triggerIsNotWorking;
    protected static ITrigger triggerCanWork;
    protected static ITrigger triggerCannotWork;
    protected static ITrigger triggerPowerNone;
    protected static ITrigger triggerPowerLow;
    protected static ITrigger triggerPowerMedium;
    protected static ITrigger triggerPowerHigh;
    protected static ITrigger triggerPowerFull;
    protected static ITrigger triggerSerumFull;
    protected static ITrigger triggerSerumPure;
    protected static ITrigger triggerSerumEmpty;
    protected static ITrigger triggerAcclimatiserNone;
    protected static ITrigger triggerAcclimatiserHot;
    protected static ITrigger triggerAcclimatiserCold;
    protected static ITrigger triggerAcclimatiserWet;
    protected static ITrigger triggerAcclimatiserDry;
    String desc;
    String tag;
    BinnieIcon icon;
    public int id = incrementalID++;

    public BinnieTrigger(String desc, String tag, String iconFile) {
        this(desc, tag, BinnieCore.instance, iconFile);
    }

    public BinnieTrigger(String desc, String tag, IBinnieMod mod, String iconFile) {
        ActionManager.registerTrigger(this);
        TriggerProvider.triggers.add(this);
        this.icon = ResourceManager.getItemIcon(mod, iconFile);
        this.desc = desc;
        this.tag = tag;
    }

    public static void setup() {
        triggerNoBlankTemplate = new BinnieTrigger("No Blank Template", "binnie.trigger.noBlankTemplate", ExtraBees.instance, "triggers/NoBlankTemplate");
        triggerNoTemplate = new BinnieTrigger("No Template", "binnie.trigger.noTemplate", ExtraBees.instance, "triggers/NoTemplate");
        triggerIsWorking = new BinnieTrigger("Is Working", "binnie.trigger.isWorking", "triggers/IsWorking");
        triggerIsNotWorking = new BinnieTrigger("Is Not Working", "binnie.trigger.isNotWorking", "triggers/IsNotWorking");
        triggerCanWork = new BinnieTrigger("Can Work", "binnie.trigger.canWork", "triggers/CanWork");
        triggerCannotWork = new BinnieTrigger("Cannot Work", "binnie.trigger.cannotWork", "triggers/CannotWork");
        triggerPowerNone = new BinnieTrigger("Power None", "binnie.trigger.powerNone", "triggers/PowerNone");
        triggerPowerLow = new BinnieTrigger("Power Low", "binnie.trigger.powerLow", "triggers/PowerLow");
        triggerPowerMedium = new BinnieTrigger("Power Medium", "binnie.trigger.powerMedium", "triggers/PowerMedium");
        triggerPowerHigh = new BinnieTrigger("Power High", "binnie.trigger.powerHigh", "triggers/PowerHigh");
        triggerPowerFull = new BinnieTrigger("Power Full", "binnie.trigger.powerFull", "triggers/PowerFull");
        triggerSerumFull = new BinnieTrigger("Serum Full", "binnie.trigger.serumFull", ExtraBees.instance, "triggers/SerumFull");
        triggerSerumPure = new BinnieTrigger("Serum Pure", "binnie.trigger.serumPure", ExtraBees.instance, "triggers/SerumPure");
        triggerSerumEmpty = new BinnieTrigger("Serum Pure", "binnie.trigger.serumEmpty", ExtraBees.instance, "triggers/SerumEmpty");
        ActionManager.registerTriggerProvider(new TriggerProvider());
    }

    @Override
    public ITriggerParameter createParameter() {
        return null;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public boolean hasParameter() {
        return false;
    }

    @Override
    public boolean isTriggerActive(ForgeDirection side, TileEntity tile, ITriggerParameter parameter) {
        return TriggerProvider.isTriggerActive(this, tile);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(IconRegister register) {
        return this.icon.getIcon(register);
    }

    @Override
    public int getLegacyId() {
        return this.id;
    }

    @Override
    public String getUniqueTag() {
        return this.tag;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon() {
        return this.icon.getIcon();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister iconRegister) {
        this.icon.registerIcon(iconRegister);
    }
}

