/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.proxy;

import binnie.core.genetics.BreedingMessageHandler;
import binnie.core.network.IPacketProvider;
import binnie.core.network.packet.BinniePacket;
import binnie.core.proxy.BinnieProxy;
import binnie.core.proxy.IBinnieProxy;
import binnie.core.resource.BinnieResource;
import binnie.craftgui.resource.minecraft.CraftGUIMetadataSection;
import binnie.craftgui.resource.minecraft.CraftGUIMetadataSectionSerializer;
import binnie.craftgui.resource.minecraft.CraftGUITextureSheet;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureObject;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.Resource;
import net.minecraft.client.resources.ResourceManager;
import net.minecraft.client.resources.data.MetadataSectionSerializer;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class BinnieProxyClient
extends BinnieProxy
implements IBinnieProxy {
    List<String> liquids = new ArrayList<String>();

    @Override
    public void bindTexture(BinnieResource texture) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraftInstance().func_110434_K().func_110577_a(texture.getResourceLocation());
    }

    @Override
    public void bindTexture(ResourceLocation location) {
        this.getMinecraftInstance().func_110434_K().func_110577_a(location);
    }

    @Override
    public boolean isSimulating(World world) {
        return !world.field_72995_K;
    }

    @Override
    public void registerCustomItemRenderer(int itemID, IItemRenderer itemRenderer) {
        MinecraftForgeClient.registerItemRenderer((int)itemID, (IItemRenderer)itemRenderer);
    }

    @Override
    public World getWorld() {
        return this.getMinecraftInstance().field_71441_e;
    }

    @Override
    public Minecraft getMinecraftInstance() {
        return FMLClientHandler.instance().getClient();
    }

    @Override
    public void sendToServer(IPacketProvider mod, BinniePacket packet) {
        packet.setChannel(mod.getChannel());
        this.getMinecraftInstance().func_71391_r().func_72552_c(packet.getPacket());
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public File getDirectory() {
        return new File(".");
    }

    @Override
    public void registerTileEntity(Class<? extends TileEntity> tile, String id, Object renderer) {
        if (renderer != null && renderer instanceof TileEntitySpecialRenderer) {
            ClientRegistry.registerTileEntity(tile, (String)id, (TileEntitySpecialRenderer)((TileEntitySpecialRenderer)renderer));
        } else {
            GameRegistry.registerTileEntity(tile, (String)id);
        }
    }

    @Override
    public void registerBlockRenderer(Object renderer) {
        if (renderer != null && renderer instanceof ISimpleBlockRenderingHandler) {
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)((ISimpleBlockRenderingHandler)renderer));
        }
    }

    @Override
    public void createPipe(Item pipe) {
    }

    @Override
    public Object createObject(String renderer) {
        Object object = null;
        try {
            Class<?> rendererClass = Class.forName(renderer);
            if (rendererClass != null) {
                object = rendererClass.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    @Override
    public Icon getIcon(IconRegister register, String mod, String name) {
        return register.func_94245_a(mod + ":" + name);
    }

    @Override
    public void handleTextureRefresh(IconRegister register, int type) {
        binnie.core.resource.ResourceManager.registerIcons(register, type);
    }

    @Override
    public void handlePostTextureRefresh(IconRegister register, int type) {
    }

    @Override
    public boolean isShiftDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    @Override
    public void preInit() {
        super.preInit();
        new BreedingMessageHandler(this.getMinecraftInstance());
        TickRegistry.registerTickHandler((ITickHandler)BreedingMessageHandler.instance, (Side)Side.CLIENT);
        MinecraftForge.EVENT_BUS.register((Object)BreedingMessageHandler.instance);
        MetadataSerializer serializer = (MetadataSerializer)ObfuscationReflectionHelper.getPrivateValue(Minecraft.class, (Object)this.getMinecraftInstance(), (String[])new String[]{"field_110452_an"});
        serializer.func_110504_a((MetadataSectionSerializer)new CraftGUIMetadataSectionSerializer(), CraftGUIMetadataSection.class);
        System.out.println(serializer);
    }

    @Override
    public void postInit() {
        super.postInit();
        try {
            TextureManager manager = this.getMinecraftInstance().func_110434_K();
            ResourceManager resourceManager = (ResourceManager)ObfuscationReflectionHelper.getPrivateValue(TextureManager.class, (Object)manager, (String[])new String[]{"field_110582_d"});
            for (CraftGUITextureSheet textureSheet : CraftGUITextureSheet.values()) {
                ResourceLocation location = textureSheet.getTexture().getResourceLocation();
                SimpleTexture texture = new SimpleTexture(location);
                manager.func_110579_a(location, (TextureObject)texture);
                Resource resource = resourceManager.func_110536_a(location);
                CraftGUIMetadataSection metadata = (CraftGUIMetadataSection)resource.func_110526_a("craftgui");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

