/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.network.packet;

import binnie.core.network.INetworkedEntity;
import binnie.core.network.packet.PacketCoordinates;
import binnie.core.network.packet.PacketPayload;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketUpdate
extends PacketCoordinates {
    public PacketPayload payload;

    public PacketUpdate() {
    }

    public PacketUpdate(int id, INetworkedEntity tile) {
        super(id, ((TileEntity)tile).field_70329_l, ((TileEntity)tile).field_70330_m, ((TileEntity)tile).field_70327_n);
        this.payload = new PacketPayload();
        tile.writeToPacket(this.payload);
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        if (this.payload == null) {
            data.writeInt(0);
            data.writeInt(0);
            data.writeInt(0);
            return;
        }
        data.writeInt(this.payload.intPayload.size());
        data.writeInt(this.payload.floatPayload.size());
        data.writeInt(this.payload.stringPayload.size());
        Iterator<Object> i$ = this.payload.intPayload.iterator();
        while (i$.hasNext()) {
            int intData = i$.next();
            data.writeInt(intData);
        }
        i$ = this.payload.floatPayload.iterator();
        while (i$.hasNext()) {
            float floatData = ((Float)i$.next()).floatValue();
            data.writeFloat(floatData);
        }
        for (String stringData : this.payload.stringPayload) {
            data.writeUTF(stringData);
        }
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        int i;
        super.readData(data);
        this.payload = new PacketPayload();
        int intLength = data.readInt();
        int floatLength = data.readInt();
        int stringLength = data.readInt();
        this.payload.intPayload.clear();
        this.payload.floatPayload.clear();
        this.payload.stringPayload.clear();
        for (i = 0; i < intLength; ++i) {
            this.payload.addInteger(data.readInt());
        }
        for (i = 0; i < floatLength; ++i) {
            this.payload.addFloat(data.readFloat());
        }
        for (i = 0; i < stringLength; ++i) {
            this.payload.addString(data.readUTF());
        }
    }

    public TileEntity getTarget(World world) {
        return world.func_72796_p(this.posX, this.posY, this.posZ);
    }
}

