/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.liquid;

import binnie.core.BinnieCore;
import binnie.core.liquid.IFluidType;
import binnie.core.liquid.ILiquidType;
import binnie.core.liquid.ItemFluidContainer;
import binnie.core.liquid.ItemOldLiquidContainer;
import binnie.core.liquid.LiquidManager;
import forestry.api.core.ItemInterface;
import forestry.api.recipes.RecipeManagers;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.fluids.FluidContainerRegistry;

public enum LiquidContainer {
    CAPSULE("Capsule"),
    REFRACTORY("Capsule"),
    CAN("Can"),
    BUCKET("Bucket"),
    GLASS("Bottle");

    Icon bottle;
    Icon contents;
    String name;

    private LiquidContainer(String name) {
        this.name = name;
    }

    public void updateIcons(IconRegister register) {
        this.bottle = BinnieCore.proxy.getIcon(register, "forestry", "liquids/" + this.toString().toLowerCase() + ".bottle");
        this.contents = BinnieCore.proxy.getIcon(register, "forestry", "liquids/" + this.toString().toLowerCase() + ".contents");
    }

    public static LiquidContainer getContainer(int container) {
        return container >= LiquidContainer.values().length ? CAPSULE : LiquidContainer.values()[container];
    }

    public String getName() {
        return this.name;
    }

    public void register(ItemOldLiquidContainer itemContainer, ILiquidType liquid) {
        ItemStack empty = null;
        switch (this) {
            case BUCKET: {
                empty = new ItemStack(Item.field_77788_aw, 1, 0);
                break;
            }
            case CAN: {
                empty = ItemInterface.getItem((String)"canEmpty");
                break;
            }
            case CAPSULE: {
                empty = ItemInterface.getItem((String)"waxCapsule");
                break;
            }
            case GLASS: {
                empty = new ItemStack(Item.field_77729_bt, 1, 0);
                break;
            }
            case REFRACTORY: {
                empty = ItemInterface.getItem((String)"refractoryEmpty");
            }
        }
        FluidContainerRegistry.FluidContainerData data = new FluidContainerRegistry.FluidContainerData(LiquidManager.getLiquidStack(liquid.getIdentifier(), 1000), new ItemStack(itemContainer.field_77779_bT, 1, liquid.ordinal() + this.ordinal() * 16), empty);
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)data);
    }

    public void registerContainerData(LiquidContainer container, IFluidType fluid) {
        ItemStack filled = ItemFluidContainer.getContainer(fluid, container);
        ItemStack empty = null;
        switch (this) {
            case BUCKET: {
                empty = new ItemStack(Item.field_77788_aw, 1, 0);
                break;
            }
            case CAN: {
                empty = ItemInterface.getItem((String)"canEmpty");
                break;
            }
            case CAPSULE: {
                empty = ItemInterface.getItem((String)"waxCapsule");
                break;
            }
            case GLASS: {
                empty = new ItemStack(Item.field_77729_bt, 1, 0);
                break;
            }
            case REFRACTORY: {
                empty = ItemInterface.getItem((String)"refractoryEmpty");
            }
        }
        if (filled == null) {
            throw new RuntimeException("Filled container not found");
        }
        if (empty == null) {
            throw new RuntimeException("Empty container not found");
        }
        if (fluid.get(1000) == null) {
            throw new RuntimeException("Fluid for container not found - " + fluid.getIdentifier());
        }
        FluidContainerRegistry.FluidContainerData data = new FluidContainerRegistry.FluidContainerData(fluid.get(1000), filled, empty);
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)data);
        RecipeManagers.bottlerManager.addRecipe(5, fluid.get(1000), empty, filled);
    }
}

