/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.liquid;

import binnie.core.liquid.BinnieFluid;
import binnie.core.liquid.IFluidType;
import binnie.core.liquid.LiquidContainer;
import binnie.core.liquid.LiquidManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.fluids.FluidStack;

public class ItemFluidContainer
extends Item {
    public static int LiquidDNA = 0;
    public static int LiquidExtraBee = 64;
    public static int LiquidExtraTree = 128;
    public static int LiquidJuice = 256;
    public static int LiquidAlcohol = 384;
    public static int LiquidSpirit = 512;
    public static int LiquidLiqueuer = 640;
    private static Map<Integer, String> idToFluid = new HashMap<Integer, String>();
    private static Map<String, Integer> fluidToID = new HashMap<String, Integer>();
    static ItemFluidContainer item;

    public static void registerFluidContainer(BinnieFluid fluid, int id) {
        idToFluid.put(id, fluid.getName());
        fluidToID.put(fluid.getName(), id);
    }

    public ItemFluidContainer(int i) {
        super(i);
        item = this;
        this.field_77777_bU = 16;
        this.func_77627_a(true);
        this.func_77655_b("fluidContainer");
        this.func_77637_a(CreativeTabs.field_78035_l);
    }

    private FluidStack getLiquid(ItemStack stack) {
        int index = stack.func_77960_j() & 0xFFF;
        String liquid = idToFluid.get(index);
        return LiquidManager.getLiquidStack(liquid, 1000);
    }

    private LiquidContainer getContainer(ItemStack stack) {
        int index = stack.func_77960_j() >> 12 & 0xF;
        if (index >= 0 && index < LiquidContainer.values().length) {
            return LiquidContainer.values()[index];
        }
        return null;
    }

    public void func_94581_a(IconRegister register) {
        for (LiquidContainer container : LiquidContainer.values()) {
            container.updateIcons(register);
        }
    }

    public String func_77628_j(ItemStack itemstack) {
        if (itemstack == null) {
            return "???";
        }
        FluidStack fluid = this.getLiquid(itemstack);
        LiquidContainer container = this.getContainer(itemstack);
        return fluid.getFluid().getLocalizedName() + " " + container.getName();
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        for (LiquidContainer container : LiquidContainer.values()) {
            for (IFluidType liquid : LiquidManager.fluids.values()) {
                if (!liquid.canBePlacedInContainer(container)) continue;
                itemList.add(ItemFluidContainer.getContainer(liquid, container));
            }
        }
    }

    public static ItemStack getContainer(IFluidType liquid, LiquidContainer container) {
        int id = (container.ordinal() << 12) + fluidToID.get(liquid.getIdentifier().toLowerCase());
        ItemStack itemstack = new ItemStack((Item)item, 1, id);
        return itemstack;
    }

    public Icon getIcon(ItemStack itemstack, int j) {
        LiquidContainer container = this.getContainer(itemstack);
        if (j > 0) {
            return container.bottle;
        }
        return container.contents;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack item, int pass) {
        FluidStack fluid = this.getLiquid(item);
        if (pass == 0 && fluid.getFluid() instanceof BinnieFluid) {
            return ((BinnieFluid)fluid.getFluid()).fluidType.getColour();
        }
        return super.func_82790_a(item, pass);
    }

    public boolean func_77623_v() {
        return true;
    }
}

