/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.core.genetics.BreedingSystem;
import binnie.core.resource.ResourceManager;
import binnie.extratrees.ExtraTrees;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IArboristTracker;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ITreeMutation;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAllelePlantType;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.EnumPlantType;

public class TreeBreedingSystem
extends BreedingSystem {
    public TreeBreedingSystem() {
        this.iconUndiscovered = ResourceManager.getItemIcon(ExtraTrees.instance, "icon/undiscoveredTree");
        this.iconDiscovered = ResourceManager.getItemIcon(ExtraTrees.instance, "icon/discoveredTree");
    }

    @Override
    public float getChance(IMutation mutation, EntityPlayer player, IAllele species1, IAllele species2) {
        IGenome genome0 = this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate(species1.getUID()));
        IGenome genome1 = this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate(species2.getUID()));
        return ((ITreeMutation)mutation).getChance(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, species1, species2, genome0, genome1);
    }

    @Override
    public String getDescriptor() {
        return "Arborist";
    }

    @Override
    public String getEpitome(float discoveredPercentage) {
        if (discoveredPercentage == 1.0f) {
            return "Mother Nature";
        }
        if (discoveredPercentage < 0.1f) {
            return "Wannabe Tree Farmer";
        }
        if (discoveredPercentage < 0.3f) {
            return "Lumberjack";
        }
        if (discoveredPercentage < 0.5f) {
            return "Green Thumbed";
        }
        if (discoveredPercentage < 0.7f) {
            return "Renowned Farmer";
        }
        if (discoveredPercentage < 0.9f) {
            return "Agricultural Master";
        }
        if (discoveredPercentage < 1.0f) {
            return "Lord of the Trees";
        }
        return "";
    }

    @Override
    public ISpeciesRoot getSpeciesRoot() {
        return AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees");
    }

    @Override
    public String getChromosomeName(int i) {
        EnumTreeChromosome chromo = (EnumTreeChromosome)this.getChromosome(i);
        switch (chromo) {
            case EFFECT: {
                return "Effect";
            }
            case FERTILITY: {
                return "Fertility";
            }
            case FRUITS: {
                return "Fruit";
            }
            case GIRTH: {
                return "Girth";
            }
            case GROWTH: {
                return "Growth";
            }
            case HEIGHT: {
                return "Height";
            }
            case MATURATION: {
                return "Maturation";
            }
            case PLANT: {
                return "Plant Type";
            }
            case SAPPINESS: {
                return "Sappiness";
            }
            case SPECIES: {
                return "Species";
            }
            case TERRITORY: {
                return "Territory";
            }
            case YIELD: {
                return "Yield";
            }
        }
        return "";
    }

    @Override
    public int getColour() {
        return 53006;
    }

    @Override
    public Class<? extends IBreedingTracker> getTrackerClass() {
        return IArboristTracker.class;
    }

    @Override
    public String getAlleleName(IChromosomeType chromosome, IAllele allele) {
        if (chromosome == EnumTreeChromosome.GIRTH) {
            return ((IAlleleInteger)allele).getValue() + "x" + ((IAlleleInteger)allele).getValue();
        }
        if (chromosome == EnumTreeChromosome.PLANT) {
            EnumSet types = ((IAllelePlantType)allele).getPlantTypes();
            return types.isEmpty() ? "None" : ((EnumPlantType)types.iterator().next()).toString();
        }
        if (chromosome == EnumTreeChromosome.FRUITS && allele.getUID().contains(".")) {
            IFruitProvider provider = ((IAlleleFruit)allele).getProvider();
            return provider.getProducts().length == 0 ? "None" : provider.getProducts()[0].func_82833_r();
        }
        if (chromosome == EnumTreeChromosome.GROWTH) {
            if (allele.getUID().contains("Tropical")) {
                return "Tropical";
            }
            if (allele.getUID().contains("Lightlevel")) {
                return "Light Level";
            }
        }
        return null;
    }
}

