/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.block;

import binnie.core.BinnieCore;
import binnie.core.block.IBlockMetadata;
import binnie.core.block.TileEntityMetadata;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockMetadata
extends BlockContainer
implements IBlockMetadata {
    static int temporyMeta = -1;

    public BlockMetadata(int par1, Material par2Material) {
        super(par1, par2Material);
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int blockMeta, int fortune) {
        return BlockMetadata.getBlockDropped(this, world, x, y, z, blockMeta);
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return BlockMetadata.breakBlock(this, player, world, x, y, z);
    }

    public TileEntity func_72274_a(World var1) {
        return new TileEntityMetadata();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public boolean func_71883_b(World par1World, int par2, int par3, int par4, int par5, int par6) {
        super.func_71883_b(par1World, par2, par3, par4, par5, par6);
        TileEntity tileentity = par1World.func_72796_p(par2, par3, par4);
        return tileentity != null ? tileentity.func_70315_b(par5, par6) : false;
    }

    public Icon func_71895_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        int metadata = TileEntityMetadata.getTileMetadata(par1IBlockAccess, par2, par3, par4);
        return this.func_71858_a(par5, metadata);
    }

    @Override
    public String getBlockName(ItemStack par1ItemStack) {
        return this.func_71931_t();
    }

    @Override
    public void getBlockTooltip(ItemStack par1ItemStack, List par3List) {
    }

    @Override
    public int getPlacedMeta(ItemStack item, World world, int x, int y, int z, ForgeDirection clickedBlock) {
        int damage = TileEntityMetadata.getItemDamage(item);
        return damage;
    }

    @Override
    public int getDroppedMeta(int tileMeta, int blockMeta) {
        return tileMeta;
    }

    @Override
    public int getBlockID() {
        return this.field_71990_ca;
    }

    public static ArrayList<ItemStack> getBlockDropped(IBlockMetadata block, World world, int x, int y, int z, int blockMeta) {
        ArrayList<ItemStack> array = new ArrayList<ItemStack>();
        TileEntityMetadata tile = TileEntityMetadata.getTile((IBlockAccess)world, x, y, z);
        if (tile != null && !tile.hasDroppedBlock()) {
            int meta = block.getDroppedMeta(world.func_72805_g(x, y, z), tile.getTileMetadata());
            array.add(TileEntityMetadata.getItemStack(block.getBlockID(), meta));
        }
        return array;
    }

    public static boolean breakBlock(IBlockMetadata block, EntityPlayer player, World world, int i, int j, int k) {
        boolean hasBeenBroken;
        ArrayList drops = new ArrayList();
        Block block2 = (Block)block;
        TileEntityMetadata tile = TileEntityMetadata.getTile((IBlockAccess)world, i, j, k);
        if (tile != null && !tile.hasDroppedBlock()) {
            int tileMeta = TileEntityMetadata.getTileMetadata((IBlockAccess)world, i, j, k);
            drops = block2.getBlockDropped(world, i, j, k, world.func_72805_g(i, j, k), 0);
        }
        if ((hasBeenBroken = world.func_94571_i(i, j, k)) && BinnieCore.proxy.isSimulating(world) && drops.size() > 0 && (player == null || !player.field_71075_bZ.field_75098_d)) {
            for (ItemStack drop : drops) {
                block.dropAsStack(world, i, j, k, drop);
            }
            tile.dropBlock();
        }
        return hasBeenBroken;
    }

    @Override
    public void dropAsStack(World world, int x, int y, int z, ItemStack drop) {
        this.func_71929_a(world, x, y, z, drop);
    }

    public void func_71852_a(World par1World, int par2, int par3, int par4, int par5, int par6) {
        super.func_71852_a(par1World, par2, par3, par4, par5, par6);
        par1World.func_72932_q(par2, par3, par4);
    }
}

