/*
 * Decompiled with CFR 0.152.
 */
package binnie.core;

import binnie.core.BinnieCore;
import binnie.core.IBinnieMod;
import binnie.core.config.ConfigurationManager;
import binnie.core.gui.IBinnieGUID;
import binnie.core.network.IPacketID;
import binnie.core.plugin.IBinnieModule;
import binnie.core.proxy.IProxyCore;
import binnie.core.resource.IBinnieTexture;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ModMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public abstract class BinnieCoreMod
implements IBinnieMod {
    private Logger log;
    List<IBinnieModule> modules = new ArrayList<IBinnieModule>();

    public BinnieCoreMod() {
        BinnieCore.registerMod(this);
    }

    @Override
    public abstract String getChannel();

    @Override
    public IPacketID[] getPacketIDs() {
        return new IPacketID[0];
    }

    @Override
    public IBinnieGUID[] getGUIDs() {
        return new IBinnieGUID[0];
    }

    @Override
    public IBinnieTexture[] getTextures() {
        return new IBinnieTexture[0];
    }

    @Override
    public Class[] getConfigs() {
        return new Class[0];
    }

    @Override
    public abstract IProxyCore getProxy();

    @Override
    public abstract String getId();

    @Override
    public void addModMetadata(ModMetadata metadata) {
    }

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public void init() {
        this.getProxy().doInit();
        this.log = Logger.getLogger(this.getId());
        this.log.setParent(FMLLog.getLogger());
        for (IBinnieModule module : this.modules) {
            module.doInit();
        }
    }

    @Override
    public void preInit() {
        if (this.getConfigs() != null) {
            for (Class cls : this.getConfigs()) {
                ConfigurationManager.registerConfiguration(cls, this);
            }
        }
        BinnieCore.loadModBlocksAndItems(this);
        this.registerModules(this.modules);
        this.getProxy().preInit();
        for (IBinnieModule module : this.modules) {
            module.preInit();
        }
    }

    @Override
    public void postInit() {
        this.getProxy().postInit();
        for (IBinnieModule module : this.modules) {
            module.postInit();
        }
    }

    public abstract void registerModules(List<IBinnieModule> var1);
}

