/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.tileentity.storage;

import com.InfinityRaider.AgriCraft.api.v1.IDebuggable;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.network.MessageTileEntitySeedStorage;
import com.InfinityRaider.AgriCraft.network.NetworkWrapperAgriCraft;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCustomWood;
import com.InfinityRaider.AgriCraft.tileentity.storage.ISeedStorageControllable;
import com.InfinityRaider.AgriCraft.tileentity.storage.ISeedStorageController;
import com.InfinityRaider.AgriCraft.tileentity.storage.SeedStorageSlot;
import com.InfinityRaider.AgriCraft.utility.NBTHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;

public class TileEntitySeedStorage
extends TileEntityCustomWood
implements ISeedStorageControllable,
IDebuggable,
ISidedInventory {
    private Item lockedSeed;
    private int lockedSeedMeta;
    private Map<Integer, SeedStorageSlot> slots = new HashMap<Integer, SeedStorageSlot>();
    private ArrayList<SeedStorageSlot> slotsList = new ArrayList();
    private ISeedStorageController controller;

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.lockedSeed != null) {
            NBTTagCompound seedTag = new NBTTagCompound();
            ItemStack seedStack = new ItemStack(this.lockedSeed, 1, this.lockedSeedMeta);
            seedStack.func_77955_b(seedTag);
            tag.func_74782_a("seed", (NBTBase)seedTag);
            if (this.slots != null) {
                NBTTagList tagList = new NBTTagList();
                for (Map.Entry<Integer, SeedStorageSlot> entry : this.slots.entrySet()) {
                    if (entry == null || entry.getValue() == null) continue;
                    SeedStorageSlot slot = entry.getValue();
                    NBTTagCompound stackTag = slot.getTag();
                    NBTTagCompound slotTag = new NBTTagCompound();
                    slotTag.func_74768_a("count", slot.count);
                    slotTag.func_74777_a("growth", stackTag.func_74765_d("growth"));
                    slotTag.func_74777_a("gain", stackTag.func_74765_d("gain"));
                    slotTag.func_74777_a("strength", stackTag.func_74765_d("strength"));
                    slotTag.func_74768_a("id", slot.getId());
                    tagList.func_74742_a((NBTBase)slotTag);
                }
                tag.func_74782_a("agricraftInv", (NBTBase)tagList);
            }
        }
        if (this.hasController()) {
            NBTHelper.addCoordsToNBT(this.controller.getCoordinates(), tag);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        int[] coords;
        super.func_145839_a(tag);
        this.slots = new HashMap<Integer, SeedStorageSlot>();
        this.slotsList = new ArrayList();
        if (tag.func_74764_b("seed")) {
            ItemStack seedStack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("seed"));
            this.lockedSeed = seedStack.func_77973_b();
            this.lockedSeedMeta = seedStack.func_77960_j();
            if (tag.func_74764_b("agricraftInv")) {
                NBTTagList tagList = tag.func_150295_c("agricraftInv", 10);
                int invId = this.getControllableID();
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound slotTag = tagList.func_150305_b(i);
                    NBTTagCompound stackTag = new NBTTagCompound();
                    CropPlantHandler.setSeedNBT(stackTag, slotTag.func_74765_d("growth"), slotTag.func_74765_d("gain"), slotTag.func_74765_d("strength"), true);
                    int id = slotTag.func_74762_e("id");
                    SeedStorageSlot slot = new SeedStorageSlot(stackTag, slotTag.func_74762_e("count"), id, invId);
                    this.slots.put(id, slot);
                    this.slotsList.add(slot);
                }
            }
        } else {
            this.lockedSeed = null;
            this.lockedSeedMeta = 0;
        }
        if ((coords = NBTHelper.getCoordsFromNBT(tag)) != null && coords.length == 3) {
            this.controller = (ISeedStorageController)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void syncSlotToClient(SeedStorageSlot slot) {
        NetworkWrapperAgriCraft.wrapper.sendToDimension((IMessage)new MessageTileEntitySeedStorage(this.field_145851_c, this.field_145848_d, this.field_145849_e, slot), this.field_145850_b.field_73011_w.field_76574_g);
        this.field_145850_b.func_72938_d(this.field_145851_c, this.field_145849_e).func_76630_e();
    }

    @Override
    public void addDebugInfo(List<String> list) {
        String info = this.lockedSeed == null ? "null" : this.getLockedSeed().func_82833_r();
        int mapSize = this.slots == null ? 0 : this.slots.size();
        int listSize = this.slotsList == null ? 0 : this.slotsList.size();
        list.add("Locked Seed: " + info);
        list.add("Nr of map entries: " + mapSize);
        list.add("Nr of list entries: " + listSize);
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addWailaInformation(List information) {
        information.add(StatCollector.func_74838_a((String)"agricraft_tooltip.storage") + ": " + (this.hasLockedSeed() ? this.getLockedSeed().func_82833_r() : StatCollector.func_74838_a((String)"agricraft_tooltip.none")));
        super.addWailaInformation(information);
    }

    @Override
    public boolean addStackToInventory(ItemStack stack) {
        boolean success = false;
        if (!CropPlantHandler.isAnalyzedSeed(stack)) {
            return false;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.hasLockedSeed() && this.lockedSeed == stack.func_77973_b() && this.lockedSeedMeta == stack.func_77960_j()) {
                for (Map.Entry<Integer, SeedStorageSlot> entry : this.slots.entrySet()) {
                    if (entry.getValue() == null || !ItemStack.func_77970_a((ItemStack)entry.getValue().getStack(this.lockedSeed, this.lockedSeedMeta), (ItemStack)stack)) continue;
                    ItemStack newStack = stack.func_77946_l();
                    newStack.field_77994_a += entry.getValue().count;
                    this.setSlotContents(entry.getKey(), newStack);
                    success = true;
                    break;
                }
                if (!success) {
                    if (this.slots.size() == 0) {
                        this.setSlotContents(0, stack);
                        success = true;
                    } else {
                        int slotId = this.getFirstFreeSlot();
                        if (slotId >= 0) {
                            this.setSlotContents(slotId, stack);
                            success = true;
                        }
                    }
                }
            } else {
                this.setLockedSeed(stack.func_77973_b(), stack.func_77960_j());
                this.setSlotContents(0, stack);
                success = true;
            }
        }
        return success;
    }

    private int getFirstFreeSlot() {
        for (int i = 0; i < this.slots.size(); ++i) {
            if (this.slots.containsKey(i)) continue;
            return i;
        }
        return this.slots.size();
    }

    @Override
    public ItemStack getStackForSlotId(int slotId) {
        if (!this.hasLockedSeed()) {
            return null;
        }
        SeedStorageSlot slot = this.slots.get(slotId);
        return slot == null ? null : slot.getStack(this.lockedSeed, this.lockedSeedMeta);
    }

    @Override
    public void setSlotContents(int realSlotId, ItemStack inputStack) {
        if (realSlotId < 0) {
            this.addStackToInventory(inputStack);
            return;
        }
        if (this.isValidForSlot(realSlotId, inputStack)) {
            SeedStorageSlot slotAt = this.slots.get(realSlotId);
            if (slotAt != null) {
                slotAt.count = inputStack.field_77994_a;
                if (slotAt.count <= 0) {
                    this.slots.remove(realSlotId);
                    this.slotsList.remove(slotAt);
                }
            } else {
                slotAt = new SeedStorageSlot(inputStack.func_77978_p(), inputStack.field_77994_a, realSlotId, this.getControllableID());
                if (slotAt.count > 0) {
                    this.slots.put(realSlotId, slotAt);
                    this.slotsList.add(slotAt);
                }
            }
            if (!this.field_145850_b.field_72995_K) {
                this.syncSlotToClient(slotAt);
            } else {
                this.markForUpdate();
            }
        }
    }

    private boolean isValidForSlot(int realSlot, ItemStack stack) {
        if (!CropPlantHandler.isAnalyzedSeed(stack)) {
            return false;
        }
        if (this.hasLockedSeed()) {
            if (stack.func_77973_b() == this.lockedSeed && stack.func_77960_j() == this.lockedSeedMeta) {
                SeedStorageSlot slotAt = this.slots.get(realSlot);
                return slotAt == null || ItemStack.func_77970_a((ItemStack)stack, (ItemStack)slotAt.getStack(this.lockedSeed, this.lockedSeedMeta));
            }
        } else {
            return true;
        }
        return false;
    }

    @Override
    public ItemStack decreaseStackSizeInSlot(int realSlotId, int amount) {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stackInSlot = null;
            if (this.slots != null) {
                SeedStorageSlot slotAt = this.slots.get(realSlotId);
                if (slotAt != null) {
                    stackInSlot = slotAt.getStack(this.lockedSeed, this.lockedSeedMeta);
                    stackInSlot.field_77994_a = Math.min(amount, slotAt.count);
                    if (slotAt.count <= amount) {
                        this.slots.remove(realSlotId);
                        this.slotsList.remove(slotAt);
                        slotAt.count = 0;
                    } else {
                        slotAt.count -= amount;
                    }
                }
                this.syncSlotToClient(slotAt);
            }
            return stackInSlot;
        }
        return null;
    }

    public ArrayList<ItemStack> getInventory() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (this.hasLockedSeed()) {
            for (Map.Entry<Integer, SeedStorageSlot> entries : this.slots.entrySet()) {
                if (entries == null || entries.getValue() == null) continue;
                stacks.add(entries.getValue().getStack(this.lockedSeed, this.lockedSeedMeta));
            }
        }
        return stacks;
    }

    @Override
    public List<SeedStorageSlot> getSlots() {
        if (this.slotsList == null) {
            this.slotsList = new ArrayList();
        }
        return this.slotsList;
    }

    @Override
    public int[] getControllerCoords() {
        return this.controller != null ? this.controller.getCoordinates() : null;
    }

    @Override
    public int[] getCoords() {
        return new int[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    @Override
    public ISeedStorageController getController() {
        return this.controller;
    }

    @Override
    public boolean hasController() {
        return this.controller != null;
    }

    @Override
    public boolean hasLockedSeed() {
        return this.lockedSeed != null;
    }

    @Override
    public void setLockedSeed(Item seed, int meta) {
        if (!this.hasLockedSeed()) {
            this.lockedSeed = seed;
            this.lockedSeedMeta = meta;
            this.markForUpdate();
        }
    }

    @Override
    public void clearLockedSeed() {
        if (this.slots.size() == 0) {
            this.lockedSeed = null;
            this.lockedSeedMeta = 0;
            this.markForUpdate();
        }
    }

    @Override
    public ItemStack getLockedSeed() {
        return new ItemStack(this.lockedSeed, 1, this.lockedSeedMeta);
    }

    @Override
    public int getControllableID() {
        int id = -1;
        if (this.hasController()) {
            id = this.getController().getControllableID(this);
        }
        return id;
    }

    public int func_70302_i_() {
        return this.slots.size() + 1;
    }

    public ItemStack func_70301_a(int slot) {
        if (this.slotsList == null || slot >= this.slotsList.size() || !this.hasLockedSeed()) {
            return null;
        }
        return this.slotsList.get(slot).getStack(this.lockedSeed, this.lockedSeedMeta);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.slotsList == null || slot >= this.slotsList.size() || !this.hasLockedSeed()) {
            return null;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stackInSlot = null;
            SeedStorageSlot slotAt = this.slotsList.get(slot);
            if (slotAt != null) {
                stackInSlot = slotAt.getStack(this.lockedSeed, this.lockedSeedMeta);
                stackInSlot.field_77994_a = Math.min(amount, slotAt.count);
                if (slotAt.count <= amount) {
                    this.slots.remove(slotAt.getId());
                    this.slotsList.remove(slotAt);
                    slotAt.count = 0;
                } else {
                    slotAt.count -= amount;
                }
            }
            this.syncSlotToClient(slotAt);
            return stackInSlot;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.slotsList == null || slot >= this.slotsList.size() || !this.hasLockedSeed()) {
            return null;
        }
        SeedStorageSlot slotAt = this.slotsList.get(slot);
        ItemStack stackInSlot = slotAt.getStack(this.lockedSeed, this.lockedSeedMeta);
        this.slots.remove(slotAt.getId());
        this.slotsList.remove(slotAt);
        return stackInSlot;
    }

    public void func_70299_a(int slot, ItemStack inputStack) {
        if (this.slotsList == null || slot >= this.slotsList.size()) {
            this.addStackToInventory(inputStack);
            return;
        }
        if (inputStack == null) {
            inputStack = this.slotsList.get(slot).getStack(this.lockedSeed, this.lockedSeedMeta);
            inputStack.field_77994_a = 0;
        }
        if (this.func_94041_b(slot, inputStack)) {
            SeedStorageSlot slotAt = this.slotsList.get(slot);
            if (slotAt != null) {
                slotAt.count = inputStack.field_77994_a;
                if (slotAt.count <= 0) {
                    this.slots.remove(slotAt.getId());
                    this.slotsList.remove(slotAt);
                }
                if (!this.field_145850_b.field_72995_K) {
                    this.syncSlotToClient(slotAt);
                }
            } else {
                this.addStackToInventory(inputStack);
            }
        }
    }

    public String func_145825_b() {
        return "AgriCraft".toLowerCase() + ":" + "seedStorage";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return Integer.MAX_VALUE;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (!CropPlantHandler.isAnalyzedSeed(stack)) {
            return false;
        }
        if (this.hasLockedSeed()) {
            if (stack.func_77973_b() == this.lockedSeed && stack.func_77960_j() == this.lockedSeedMeta) {
                if (slot >= this.slotsList.size()) {
                    return true;
                }
                SeedStorageSlot slotAt = this.slotsList.get(slot);
                return slotAt == null || ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.func_70301_a(slot));
            }
        } else {
            return true;
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        int[] array = new int[this.slotsList.size() + 1];
        for (int i = 0; i < array.length; ++i) {
            array[i] = i;
        }
        return array;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        if (slot >= this.slotsList.size()) {
            return !this.hasLockedSeed() || stack != null && stack.func_77973_b() == this.lockedSeed && stack.func_77960_j() == this.lockedSeedMeta;
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (slot >= this.slotsList.size()) {
            return false;
        }
        if (!this.hasLockedSeed()) {
            return false;
        }
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        if (stack.func_77973_b() != this.lockedSeed || stack.func_77960_j() != this.lockedSeedMeta) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.slotsList.get(slot).getStack(this.lockedSeed, this.lockedSeedMeta));
    }
}

