/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.tileentity.irrigation;

import com.InfinityRaider.AgriCraft.blocks.BlockWaterChannel;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.renderers.particles.LiquidSprayFX;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityAgricraft;
import com.InfinityRaider.AgriCraft.tileentity.irrigation.TileEntityChannel;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.IGrowable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.IPlantable;

public class TileEntitySprinkler
extends TileEntityAgricraft {
    private int counter = 0;
    public float angle = 0.0f;
    private boolean isSprinkled = false;

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.counter > 0) {
            tag.func_74768_a("level", this.counter);
        }
        tag.func_74757_a("isSprinkled", this.isSprinkled);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.counter = tag.func_74764_b("level") ? tag.func_74762_e("level") : 0;
        this.isSprinkled = tag.func_74764_b("isSprinkled") ? tag.func_74767_n("isSprinkled") : false;
    }

    public boolean isConnected() {
        return this.field_145850_b != null && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof BlockWaterChannel;
    }

    public IIcon getChannelIcon() {
        if (this.isConnected()) {
            TileEntityChannel channel = (TileEntityChannel)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            return channel.getIcon();
        }
        return Blocks.field_150344_f.func_149691_a(0, 0);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.sprinkle()) {
                ++this.counter;
                this.counter %= ConfigurationHandler.sprinklerGrowthIntervalTicks;
                this.drainWaterFromChannel();
                for (int yOffset = 1; yOffset < 6; ++yOffset) {
                    for (int xOffset = -3; xOffset <= 3; ++xOffset) {
                        for (int zOffset = -3; zOffset <= 3; ++zOffset) {
                            this.irrigate(this.field_145851_c + xOffset, this.field_145848_d - yOffset, this.field_145849_e + zOffset, yOffset >= 5);
                        }
                    }
                }
            }
        } else if (this.isSprinkled) {
            this.renderLiquidSpray();
        }
    }

    public boolean canSprinkle() {
        return this.isConnected() && ((TileEntityChannel)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)).getFluidLevel() > ConfigurationHandler.sprinklerRatePerHalfSecond;
    }

    private boolean sprinkle() {
        boolean newState = this.canSprinkle();
        if (newState != this.isSprinkled) {
            this.isSprinkled = newState;
            this.markForUpdate();
        }
        return this.isSprinkled;
    }

    private void irrigate(int x, int y, int z, boolean farmlandOnly) {
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        if (block != null) {
            if (block instanceof BlockFarmland && this.field_145850_b.func_72805_g(x, y, z) < 7) {
                int flag = this.counter == 0 ? 2 : 6;
                this.field_145850_b.func_72921_c(x, y, z, 7, flag);
            } else if ((block instanceof IPlantable || block instanceof IGrowable) && !farmlandOnly && this.counter == 0 && this.field_145850_b.field_73012_v.nextDouble() <= (double)ConfigurationHandler.sprinklerGrowthChancePercent) {
                block.func_149674_a(this.field_145850_b, x, y, z, this.field_145850_b.field_73012_v);
            }
        }
    }

    private void drainWaterFromChannel() {
        if (this.counter % 10 == 0) {
            TileEntityChannel channel = (TileEntityChannel)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            channel.pullFluid(ConfigurationHandler.sprinklerRatePerHalfSecond);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderLiquidSpray() {
        this.angle = (this.angle + 5.0f) % 360.0f;
        if (ConfigurationHandler.disableParticles) {
            return;
        }
        int particleSetting = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        this.counter = (this.counter + 1) % (particleSetting + 1);
        if (this.counter == 0) {
            for (int i = 0; i < 4; ++i) {
                float alpha = (this.angle + (float)(90 * i)) * (float)Math.PI / 180.0f;
                double xOffset = 0.25 * Math.cos(alpha);
                double zOffset = 0.25 * Math.sin(alpha);
                float radius = 0.3f;
                for (int j = 0; j <= 4; ++j) {
                    float beta = (float)(-j) * (float)Math.PI / 8.0f;
                    Vec3 vector = Vec3.func_72443_a((double)((double)radius * Math.cos(alpha)), (double)((double)radius * Math.sin(beta)), (double)((double)radius * Math.sin(alpha)));
                    this.spawnLiquidSpray(xOffset * (double)(4 - j) / 4.0, zOffset * (double)(4 - j) / 4.0, vector);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnLiquidSpray(double xOffset, double zOffset, Vec3 vector) {
        LiquidSprayFX liquidSpray = new LiquidSprayFX(this.field_145850_b, (double)((float)this.field_145851_c + 0.5f) + xOffset, (float)this.field_145848_d + 0.3125f, (double)((float)this.field_145849_e + 0.5f) + zOffset, 0.3f, 0.7f, vector);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)liquidSpray);
    }

    @Override
    public boolean isRotatable() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addWailaInformation(List information) {
    }
}

