/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.farming.mutation.statcalculator;

import com.InfinityRaider.AgriCraft.api.v1.IMutation;
import com.InfinityRaider.AgriCraft.api.v2.ICrop;
import com.InfinityRaider.AgriCraft.api.v2.ISeedStats;
import com.InfinityRaider.AgriCraft.farming.PlantStats;
import com.InfinityRaider.AgriCraft.farming.mutation.MutationHandler;
import com.InfinityRaider.AgriCraft.farming.mutation.statcalculator.StatCalculator;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class StatCalculatorBase
extends StatCalculator {
    @Override
    public ISeedStats calculateStats(ItemStack result, List<? extends ICrop> input, boolean mutation) {
        return result == null ? new PlantStats() : this.calculateStats(result.func_77973_b(), result.func_77960_j(), input, mutation);
    }

    @Override
    public ISeedStats calculateStats(Item result, int resultMeta, List<? extends ICrop> input, boolean mutation) {
        ICrop[] parents = this.filterParents(input);
        int nrParents = parents.length;
        int nrValidParents = 0;
        int[] growth = new int[nrParents];
        int[] gain = new int[nrParents];
        int[] strength = new int[nrParents];
        for (int i = 0; i < nrParents; ++i) {
            boolean canInherit = this.canInheritStats(result, resultMeta, parents[i].getSeedStack().func_77973_b(), parents[i].getSeedStack().func_77960_j());
            if (canInherit) {
                ++nrValidParents;
            }
            int multiplier = canInherit ? 1 : (ConfigurationHandler.otherCropsAffectStatsNegatively ? 0 : -1);
            growth[i] = multiplier * parents[i].getGrowth();
            gain[i] = multiplier * parents[i].getGain();
            strength[i] = multiplier * parents[i].getStrength();
        }
        int meanGrowth = this.getMeanIgnoringNegativeValues(growth);
        int meanGain = this.getMeanIgnoringNegativeValues(gain);
        int meanStrength = this.getMeanIgnoringNegativeValues(strength);
        int divisor = mutation ? ConfigurationHandler.cropStatDivisor : 1;
        return new PlantStats(this.calculateStats(meanGrowth, nrValidParents, divisor), this.calculateStats(meanGain, nrValidParents, divisor), this.calculateStats(meanStrength, nrValidParents, divisor));
    }

    protected ICrop[] filterParents(List<? extends ICrop> input) {
        ArrayList<ICrop> list = new ArrayList<ICrop>();
        for (ICrop iCrop : input) {
            if (iCrop == null || !iCrop.isMature()) continue;
            list.add(iCrop);
        }
        return list.toArray(new ICrop[list.size()]);
    }

    protected boolean canInheritStats(Item child, int childMeta, Item seed, int seedMeta) {
        boolean b;
        int validParentId = ConfigurationHandler.validParents;
        if (validParentId == 1) {
            return true;
        }
        if (validParentId == 3) {
            return child == seed && childMeta == seedMeta;
        }
        boolean bl = b = child == seed && childMeta == seedMeta;
        if (!b) {
            for (IMutation mutation : MutationHandler.getInstance().getMutationsFromChild(child, childMeta)) {
                if (mutation == null) continue;
                ItemStack parent1Stack = mutation.getParents()[0];
                ItemStack parent2Stack = mutation.getParents()[1];
                if (parent1Stack.func_77973_b() == seed && parent1Stack.func_77960_j() == seedMeta) {
                    b = true;
                    break;
                }
                if (parent2Stack.func_77973_b() != seed || parent2Stack.func_77960_j() != seedMeta) continue;
                b = true;
                break;
            }
        }
        return b;
    }

    private int getMeanIgnoringNegativeValues(int[] input) {
        int sum = 0;
        int total = input.length;
        int mean = 0;
        if (total > 0) {
            for (int nr : input) {
                if (nr >= 0) {
                    sum += nr;
                    continue;
                }
                --total;
            }
            if (total > 0) {
                mean = Math.round((float)sum / (float)total);
            }
        }
        return mean;
    }

    protected abstract int calculateStats(int var1, int var2, int var3);
}

