/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.network.message;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import shedar.mods.ic2.nuclearcontrol.api.CardState;
import shedar.mods.ic2.nuclearcontrol.api.ICardWrapper;
import shedar.mods.ic2.nuclearcontrol.api.IPanelDataSource;
import shedar.mods.ic2.nuclearcontrol.api.IRemoteSensor;
import shedar.mods.ic2.nuclearcontrol.items.ItemCardBase;
import shedar.mods.ic2.nuclearcontrol.network.message.PacketClientRemoteMonitor;
import shedar.mods.ic2.nuclearcontrol.panel.CardWrapperImpl;

public class PacketServerUpdate
implements IMessage {
    public ItemStack itemstack;

    public PacketServerUpdate() {
    }

    public PacketServerUpdate(ItemStack card) {
        this.itemstack = card;
    }

    public void fromBytes(ByteBuf buf) {
        this.itemstack = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.itemstack);
    }

    public static class Handler
    implements IMessageHandler<PacketServerUpdate, IMessage> {
        public IMessage onMessage(PacketServerUpdate message, MessageContext ctx) {
            CardWrapperImpl helper;
            ItemStack stack = message.itemstack;
            if (stack != null && stack.func_77973_b() instanceof ItemCardBase && (helper = this.processCard(stack, 10, 0)) != null) {
                return new PacketClientRemoteMonitor(helper.getUpdateSet());
            }
            return null;
        }

        private CardWrapperImpl processCard(ItemStack card, int upgradeCountRange, int slot) {
            if (card == null) {
                return null;
            }
            Item item = card.func_77973_b();
            if (item instanceof IPanelDataSource) {
                boolean needUpdate = true;
                if (upgradeCountRange > 7) {
                    upgradeCountRange = 7;
                }
                int range = 100 * (int)Math.pow(2.0, upgradeCountRange);
                CardWrapperImpl cardHelper = new CardWrapperImpl(card, slot);
                if (item instanceof IRemoteSensor) {
                    ChunkCoordinates target = cardHelper.getTarget();
                    if (target == null) {
                        needUpdate = false;
                        cardHelper.setState(CardState.INVALID_CARD);
                    } else {
                        cardHelper.setState(CardState.OUT_OF_RANGE);
                    }
                }
                if (needUpdate) {
                    CardState state = null;
                    state = ((IPanelDataSource)item).update((World)MinecraftServer.func_71276_C().field_71305_c[0], (ICardWrapper)cardHelper, range);
                    cardHelper.setInt("state", state.getIndex());
                }
                return cardHelper;
            }
            return null;
        }
    }
}

