/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui;

import binnie.core.util.UniqueItemStackSet;
import binnie.craftgui.controls.ControlTextCentered;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IPoint;
import binnie.craftgui.minecraft.control.ControlIconDisplay;
import binnie.craftgui.minecraft.control.ControlItemDisplay;
import binnie.genetics.gui.AnalystPageProduce;
import binnie.genetics.item.ModuleItem;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IChromosomeType;
import net.minecraft.item.ItemStack;

public class AnalystPageWood
extends AnalystPageProduce {
    public AnalystPageWood(IWidget parent, IArea area, ITree ind) {
        super(parent, area);
        this.setColour(0x663300);
        ITreeGenome genome = ind.getGenome();
        int y = 4;
        new ControlTextCentered((IWidget)this, y, "\u00a7nWood").setColour(this.getColour());
        y += 12;
        if (((IAlleleBoolean)ind.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.FIREPROOF)).getValue()) {
            new ControlIconDisplay(this, (this.w() - 16.0f) / 2.0f, y, ModuleItem.iconNoFire.getIcon()).addTooltip("Fireproof");
        } else {
            new ControlIconDisplay(this, (this.w() - 16.0f) / 2.0f, y, ModuleItem.iconFire.getIcon()).addTooltip("Flammable");
        }
        y += 30;
        UniqueItemStackSet products = new UniqueItemStackSet();
        for (ItemStack stack : ind.getGenome().getPrimary().getLogStacks()) {
            products.add(stack);
        }
        if (products.size() > 0) {
            new ControlTextCentered((IWidget)this, y, "Logs").setColour(this.getColour());
            y += 10;
            int w = products.size() * 18 - 2;
            int i = 0;
            for (ItemStack stack : products) {
                ControlItemDisplay d = new ControlItemDisplay(this, (this.w() - (float)w) / 2.0f + (float)(18 * i), y);
                d.setTooltip();
                d.setItemStack(stack);
            }
            y += 26;
        }
        UniqueItemStackSet allProducts = new UniqueItemStackSet();
        for (ItemStack stack : products) {
            allProducts.add(stack);
        }
        UniqueItemStackSet refinedProducts = new UniqueItemStackSet();
        refinedProducts.addAll(this.getAllProductsAndFluids(allProducts));
        if (refinedProducts.size() > 0) {
            y = this.getRefined("Refined Products", y, refinedProducts);
            y += 8;
        }
        if (products.size() == 0) {
            new ControlTextCentered((IWidget)this, y, "This tree has no \nfruits or nuts").setColour(this.getColour());
            y += 28;
        }
        this.setSize(new IPoint(this.w(), y + 8));
    }

    @Override
    public String getTitle() {
        return "Wood";
    }
}

