/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.util.UniqueItemStackSet;
import binnie.craftgui.controls.ControlTextCentered;
import binnie.craftgui.controls.core.Control;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.CraftGUIUtil;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IPoint;
import binnie.craftgui.extratrees.kitchen.ControlFluidDisplay;
import binnie.craftgui.minecraft.control.ControlItemDisplay;
import binnie.genetics.gui.AnalystPageProduce;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.IChromosomeType;
import forestry.plugins.PluginApiculture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class AnalystPageProducts
extends AnalystPageProduce {
    public AnalystPageProducts(IWidget parent, IArea area, IBee ind) {
        super(parent, area);
        this.setColour(0xCC3300);
        IBeeGenome genome = ind.getGenome();
        float speed = genome.getSpeed();
        float modeSpeed = Binnie.Genetics.getBeeRoot().getBeekeepingMode(BinnieCore.proxy.getWorld()).getProductionModifier(genome, 1.0f);
        int y = 4;
        new ControlTextCentered((IWidget)this, y, "\u00a7nProduce").setColour(this.getColour());
        new ControlTextCentered((IWidget)this, y += 12, "\u00a7oRate: " + Binnie.Genetics.beeBreedingSystem.getAlleleName((IChromosomeType)EnumBeeChromosome.SPEED, ind.getGenome().getActiveAllele((IChromosomeType)EnumBeeChromosome.SPEED))).setColour(this.getColour());
        y += 20;
        UniqueItemStackSet refinedProducts = new UniqueItemStackSet();
        UniqueItemStackSet productList = new UniqueItemStackSet();
        UniqueItemStackSet specialtyList = new UniqueItemStackSet();
        Map products = new HashMap();
        products.putAll(genome.getPrimary().getProducts());
        products.putAll(genome.getSecondary().getProducts());
        if (!products.isEmpty()) {
            new ControlTextCentered((IWidget)this, y, "Natural Products").setColour(this.getColour());
            y += 12;
            for (Map.Entry entry : products.entrySet()) {
                if (!productList.add(entry.getKey())) continue;
                refinedProducts.addAll(this.getAllProducts((ItemStack)entry.getKey()));
                this.createProductEntry((ItemStack)entry.getKey(), (Integer)entry.getValue(), y, speed * modeSpeed);
                y += 18;
            }
            y += 12;
        }
        if (!(products = genome.getPrimary().getSpecialty()).isEmpty()) {
            new ControlTextCentered((IWidget)this, y, "Specialty Products").setColour(this.getColour());
            y += 12;
            for (Map.Entry entry : products.entrySet()) {
                refinedProducts.addAll(this.getAllProducts((ItemStack)entry.getKey()));
                this.createProductEntry((ItemStack)entry.getKey(), (Integer)entry.getValue(), y, speed * modeSpeed);
                y += 18;
            }
            y += 12;
        }
        new ControlTextCentered((IWidget)this, y, "Refined Products").setColour(this.getColour());
        y += 12;
        UniqueItemStackSet level2Products = new UniqueItemStackSet();
        for (ItemStack stack : refinedProducts) {
            level2Products.addAll(this.getAllProducts(stack));
        }
        refinedProducts.addAll(level2Products);
        level2Products = new UniqueItemStackSet();
        for (ItemStack stack : refinedProducts) {
            level2Products.addAll(this.getAllProducts(stack));
        }
        refinedProducts.addAll(level2Products);
        ArrayList<FluidStack> allFluids = new ArrayList<FluidStack>();
        for (ItemStack stack : refinedProducts) {
            for (FluidStack addition : this.getAllFluids(stack)) {
                boolean alreadyIn = false;
                for (FluidStack existing : allFluids) {
                    if (!existing.isFluidEqual(addition)) continue;
                    alreadyIn = true;
                }
                if (alreadyIn) continue;
                allFluids.add(addition);
            }
        }
        int maxBiomePerLine = (int)((this.w() + 2.0f - 16.0f) / 18.0f);
        float biomeListX = (this.w() - (float)(Math.min(maxBiomePerLine, allFluids.size() + refinedProducts.size()) * 18 - 2)) / 2.0f;
        int dx = 0;
        int dy = 0;
        for (ItemStack itemStack : refinedProducts) {
            if (dx >= 18 * maxBiomePerLine) {
                dx = 0;
                dy += 18;
            }
            ControlItemDisplay display = new ControlItemDisplay(this, biomeListX + (float)dx, y + dy);
            display.setItemStack(itemStack);
            display.setTooltip();
            dx += 18;
        }
        for (FluidStack fluidStack : allFluids) {
            Control display;
            if (dx >= 18 * maxBiomePerLine) {
                dx = 0;
                dy += 18;
            }
            ItemStack container = null;
            for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                if (data.emptyContainer.func_77969_a(new ItemStack(Items.field_151069_bo)) && data.fluid.isFluidEqual(fluidStack)) {
                    container = data.filledContainer;
                    break;
                }
                if (data.emptyContainer.func_77969_a(new ItemStack(Items.field_151133_ar)) && data.fluid.isFluidEqual(fluidStack)) {
                    container = data.filledContainer;
                    break;
                }
                if (!data.fluid.isFluidEqual(fluidStack)) continue;
                container = data.filledContainer;
                break;
            }
            if (container == null) {
                display = new ControlFluidDisplay(this, biomeListX + (float)dx, y + dy);
                ((ControlFluidDisplay)display).setItemStack(fluidStack);
                ((ControlFluidDisplay)display).setTooltip();
            } else {
                display = new ControlItemDisplay(this, biomeListX + (float)dx, y + dy);
                ((ControlItemDisplay)display).setItemStack(container);
                ((ControlItemDisplay)display).setTooltip();
            }
            dx += 18;
        }
        this.setSize(new IPoint(this.w(), y + dy + 18 + 8));
    }

    private void createProductEntry(final ItemStack key, Integer value, int y, float speed) {
        ControlItemDisplay item = new ControlItemDisplay(this, 16.0f, (float)y){

            @Override
            public void getTooltip(Tooltip tooltip) {
                Collection<ItemStack> liquids;
                super.getTooltip(tooltip);
                Collection<ItemStack> products = AnalystPageProducts.this.getCentrifuge(key);
                if (!products.isEmpty()) {
                    tooltip.add("Centrifuges to give: ");
                    for (ItemStack prod : products) {
                        NBTTagCompound nbt = new NBTTagCompound();
                        prod.func_77955_b(nbt);
                        tooltip.add(prod, prod.func_82833_r());
                    }
                }
                if (!(liquids = AnalystPageProducts.this.getSqueezer(key)).isEmpty()) {
                    tooltip.add("Squeezes to give: ");
                    for (ItemStack prod : liquids) {
                        NBTTagCompound nbt = new NBTTagCompound();
                        prod.func_77955_b(nbt);
                        tooltip.add(prod, prod.func_82833_r());
                    }
                }
            }
        };
        item.setTooltip();
        ControlTextCentered textWidget = new ControlTextCentered((IWidget)this, y + 4, "");
        textWidget.setColour(this.getColour());
        CraftGUIUtil.moveWidget(textWidget, new IPoint(12.0f, 0.0f));
        item.setItemStack(key);
        float time = (int)((double)PluginApiculture.ticksPerBeeWorkCycle * 100.0 / (double)(speed * (float)value.intValue()));
        textWidget.setValue("Every " + this.getTimeString(time));
    }

    @Override
    public String getTitle() {
        return "Produce";
    }
}

