/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.machines.IMachineType;
import binnie.core.machines.Machine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.MachinePackage;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.component.IInteraction;
import binnie.core.resource.BinnieResource;
import binnie.core.resource.ResourceType;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.core.ExtraTreesGUID;
import binnie.extratrees.machines.Brewery;
import binnie.extratrees.machines.Designer;
import binnie.extratrees.machines.Distillery;
import binnie.extratrees.machines.Lumbermill;
import binnie.extratrees.machines.MachineRendererForestry;
import binnie.extratrees.machines.Nursery;
import binnie.extratrees.machines.Press;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public enum ExtraTreeMachine implements IMachineType
{
    Lumbermill(Lumbermill.PackageLumbermill.class),
    Woodworker(Designer.PackageWoodworker.class),
    Panelworker(Designer.PackagePanelworker.class),
    Nursery(Nursery.PackageNursery.class),
    Press(Press.PackagePress.class),
    Brewery(Brewery.PackageBrewery.class),
    Distillery(Distillery.PackageDistillery.class),
    Glassworker(Designer.PackageGlassworker.class),
    Tileworker(Designer.PackageTileworker.class);

    Class<? extends MachinePackage> clss;

    private ExtraTreeMachine(Class<? extends MachinePackage> clss) {
        this.clss = clss;
    }

    @Override
    public Class<? extends MachinePackage> getPackageClass() {
        return this.clss;
    }

    @Override
    public boolean isActive() {
        if (this == Tileworker) {
            return BinnieCore.isBotanyActive();
        }
        return this != Nursery;
    }

    public ItemStack get(int i) {
        return new ItemStack(ExtraTrees.blockMachine, i, this.ordinal());
    }

    public static abstract class PackageExtraTreeMachine
    extends MachinePackage {
        BinnieResource textureName;

        protected PackageExtraTreeMachine(String uid, String textureName, boolean powered) {
            super(uid, powered);
            this.textureName = Binnie.Resource.getFile(ExtraTrees.instance, ResourceType.Tile, textureName);
        }

        protected PackageExtraTreeMachine(String uid, BinnieResource textureName, boolean powered) {
            super(uid, powered);
            this.textureName = textureName;
        }

        @Override
        public TileEntity createTileEntity() {
            return new TileEntityMachine(this);
        }

        @Override
        public void register() {
        }

        @Override
        public void renderMachine(Machine machine, double x, double y, double z, float var8, RenderBlocks renderer) {
            MachineRendererForestry.renderMachine(this.textureName.getShortPath(), x, y, z, var8);
        }
    }

    public static class ComponentExtraTreeGUI
    extends MachineComponent
    implements IInteraction.RightClick {
        ExtraTreesGUID id;

        public ComponentExtraTreeGUI(Machine machine, ExtraTreesGUID id) {
            super(machine);
            this.id = id;
        }

        @Override
        public void onRightClick(World world, EntityPlayer player, int x, int y, int z) {
            ExtraTrees.proxy.openGui(this.id, player, x, y, z);
        }
    }
}

