/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.carpentry;

import binnie.core.AbstractMod;
import binnie.core.BinnieCore;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.IDesignMaterial;
import binnie.extratrees.api.IDesignSystem;
import binnie.extratrees.api.IPattern;
import binnie.extratrees.block.PlankType;
import binnie.extratrees.carpentry.DesignerManager;
import binnie.extratrees.carpentry.EnumPattern;
import binnie.extratrees.carpentry.GlassType;
import binnie.extratrees.item.ExtraTreeItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public enum DesignSystem implements IDesignSystem
{
    Wood,
    Glass;

    Map<Integer, IIcon> primary = new HashMap<Integer, IIcon>();
    Map<Integer, IIcon> secondary = new HashMap<Integer, IIcon>();

    private DesignSystem() {
        DesignerManager.instance.registerDesignSystem(this);
    }

    @Override
    public IDesignMaterial getDefaultMaterial() {
        switch (this) {
            case Glass: {
                return GlassType.get(0);
            }
            case Wood: {
                return PlankType.ExtraTreePlanks.Fir;
            }
        }
        return null;
    }

    @Override
    public IDesignMaterial getDefaultMaterial2() {
        switch (this) {
            case Glass: {
                return GlassType.get(1);
            }
            case Wood: {
                return PlankType.ExtraTreePlanks.Whitebeam;
            }
        }
        return null;
    }

    @Override
    public IDesignMaterial getMaterial(int id) {
        switch (this) {
            case Glass: {
                return GlassType.get(id);
            }
            case Wood: {
                return CarpentryManager.carpentryInterface.getWoodMaterial(id);
            }
        }
        return null;
    }

    @Override
    public int getMaterialIndex(IDesignMaterial id) {
        switch (this) {
            case Glass: {
                return GlassType.getIndex(id);
            }
            case Wood: {
                return CarpentryManager.carpentryInterface.getCarpentryWoodIndex(id);
            }
        }
        return 0;
    }

    public String getTexturePath() {
        switch (this) {
            case Glass: {
                return "glass";
            }
            case Wood: {
                return "patterns";
            }
        }
        return "";
    }

    @Override
    public IDesignMaterial getMaterial(ItemStack stack) {
        switch (this) {
            case Glass: {
                return GlassType.get(stack);
            }
            case Wood: {
                return CarpentryManager.carpentryInterface.getWoodMaterial(stack);
            }
        }
        return null;
    }

    @Override
    public ItemStack getAdhesive() {
        switch (this) {
            case Glass: {
                return ExtraTreeItems.GlassFitting.get(1);
            }
            case Wood: {
                return ExtraTreeItems.WoodWax.get(1);
            }
        }
        return null;
    }

    @Override
    public IIcon getPrimaryIcon(IPattern pattern) {
        if (pattern instanceof EnumPattern) {
            return this.primary.get(((EnumPattern)pattern).ordinal());
        }
        return null;
    }

    @Override
    public IIcon getSecondaryIcon(IPattern pattern) {
        if (pattern instanceof EnumPattern) {
            return this.secondary.get(((EnumPattern)pattern).ordinal());
        }
        return null;
    }

    @Override
    public void registerIcons(IIconRegister register) {
        for (EnumPattern pattern : EnumPattern.values()) {
            this.primary.put(pattern.ordinal(), BinnieCore.proxy.getIcon(register, this.getMod().getModID(), this.getTexturePath() + "/" + pattern.toString().toLowerCase() + ".0"));
            this.secondary.put(pattern.ordinal(), BinnieCore.proxy.getIcon(register, this.getMod().getModID(), this.getTexturePath() + "/" + pattern.toString().toLowerCase() + ".1"));
        }
    }

    public AbstractMod getMod() {
        return ExtraTrees.instance;
    }
}

