/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.IInitializable;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.genetics.ExtraBeeMutation;
import binnie.extrabees.genetics.ExtraBeesBranch;
import binnie.extrabees.genetics.ExtraBeesFlowers;
import binnie.extrabees.genetics.ExtraBeesSpecies;
import binnie.extrabees.genetics.effect.BlockEctoplasm;
import binnie.extrabees.genetics.effect.ExtraBeesEffect;
import binnie.extrabees.genetics.items.ItemDictionary;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.recipes.RecipeManagers;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class ModuleGenetics
implements IInitializable {
    @Override
    public void preInit() {
        for (ExtraBeesSpecies species : ExtraBeesSpecies.values()) {
            AlleleManager.alleleRegistry.registerAllele((IAllele)species);
        }
        ExtraBees.dictionary = new ItemDictionary();
        ExtraBees.ectoplasm = new BlockEctoplasm();
        GameRegistry.registerBlock((Block)ExtraBees.ectoplasm, (String)"ectoplasm");
    }

    @Override
    public void init() {
        ExtraBeesEffect.doInit();
        ExtraBeesFlowers.doInit();
        ExtraBeesSpecies.doInit();
        ExtraBeeMutation.doInit();
        ExtraBeesBranch.doInit();
    }

    @Override
    public void postInit() {
        int ebSpeciesCount = 0;
        int ebTotalSpeciesCount = 0;
        for (ExtraBeesSpecies species : ExtraBeesSpecies.values()) {
            ++ebTotalSpeciesCount;
            if (AlleleManager.alleleRegistry.isBlacklisted(species.getUID())) continue;
            ++ebSpeciesCount;
        }
        RecipeManagers.carpenterManager.addRecipe(100, Binnie.Liquid.getLiquidStack("water", 2000), null, new ItemStack(ExtraBees.dictionary), new Object[]{"X#X", "YEY", "RDR", Character.valueOf('#'), Blocks.field_150410_aZ, Character.valueOf('X'), Items.field_151043_k, Character.valueOf('Y'), "ingotTin", Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('D'), Items.field_151045_i, Character.valueOf('E'), Items.field_151166_bC});
    }

    public static IGenome getGenome(IAlleleBeeSpecies allele0) {
        return Binnie.Genetics.getBeeRoot().templateAsGenome(Binnie.Genetics.getBeeRoot().getTemplate(allele0.getUID()));
    }

    public static ItemStack getBeeIcon(IAlleleBeeSpecies species) {
        if (species == null) {
            return null;
        }
        IAllele[] template = Binnie.Genetics.getBeeRoot().getTemplate(species.getUID());
        if (template == null) {
            return null;
        }
        IBeeGenome genome = Binnie.Genetics.getBeeRoot().templateAsGenome(template);
        IBee bee = Binnie.Genetics.getBeeRoot().getBee(BinnieCore.proxy.getWorld(), genome);
        ItemStack item = Binnie.Genetics.getBeeRoot().getMemberStack((IIndividual)bee, EnumBeeType.PRINCESS.ordinal());
        return item;
    }
}

