/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.apiary.machine;

import binnie.core.machines.Machine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.craftgui.minecraft.IMachineInformation;
import binnie.extrabees.apiary.TileExtraBeeAlveary;
import binnie.extrabees.apiary.machine.AlvearyMachine;
import binnie.extrabees.core.ExtraBeeTexture;
import cofh.api.energy.IEnergyHandler;
import java.util.ArrayList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class AlvearyTransmission {

    public static class ComponentTransmission
    extends MachineComponent {
        public ComponentTransmission(Machine machine) {
            super(machine);
        }

        @Override
        public void onUpdate() {
            super.onUpdate();
            int energy = this.getUtil().getPoweredMachine().getEnergyStored(ForgeDirection.NORTH);
            if (energy == 0) {
                return;
            }
            TileExtraBeeAlveary tile = (TileExtraBeeAlveary)this.getMachine().getTileEntity();
            ArrayList<IEnergyHandler> handlers = new ArrayList<IEnergyHandler>();
            for (TileEntity alvearyTile : tile.getAlvearyBlocks()) {
                if (!(alvearyTile instanceof IEnergyHandler) || alvearyTile == tile) continue;
                handlers.add((IEnergyHandler)alvearyTile);
            }
            if (handlers.isEmpty()) {
                return;
            }
            int maxOutput = 500;
            int output = energy / handlers.size();
            if (output > maxOutput) {
                output = maxOutput;
            }
            if (output < 1) {
                output = 1;
            }
            for (IEnergyHandler handler : handlers) {
                int recieved = handler.receiveEnergy(ForgeDirection.NORTH, output, false);
                this.getUtil().getPoweredMachine().extractEnergy(ForgeDirection.NORTH, recieved, false);
                energy = this.getUtil().getPoweredMachine().getEnergyStored(ForgeDirection.NORTH);
                if (energy != 0) continue;
                return;
            }
        }
    }

    public static class PackageAlvearyTransmission
    extends AlvearyMachine.AlvearyPackage
    implements IMachineInformation {
        public PackageAlvearyTransmission() {
            super("transmission", ExtraBeeTexture.AlvearyTransmission.getTexture(), false);
        }

        @Override
        public void createMachine(Machine machine) {
            new ComponentPowerReceptor(machine, 1000);
            new ComponentTransmission(machine);
        }
    }
}

