/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.mod.database;

import binnie.craftgui.controls.ControlText;
import binnie.craftgui.controls.ControlTextCentered;
import binnie.craftgui.core.CraftGUI;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IPoint;
import binnie.craftgui.core.geometry.TextJustification;
import binnie.craftgui.mod.database.ControlDatabaseIndividualDisplay;
import binnie.craftgui.mod.database.DatabaseTab;
import binnie.craftgui.mod.database.EnumDiscoveryState;
import binnie.craftgui.mod.database.PageSpecies;
import forestry.api.genetics.IAlleleSpecies;

public class PageSpeciesOverview
extends PageSpecies {
    private ControlText controlName;
    private ControlText controlScientific;
    private ControlText controlAuthority;
    private ControlText controlComplexity;
    private ControlText controlDescription;
    private ControlText controlSignature;
    private ControlDatabaseIndividualDisplay controlInd1 = new ControlDatabaseIndividualDisplay(this, 5.0f, 5.0f);
    private ControlDatabaseIndividualDisplay controlInd2 = new ControlDatabaseIndividualDisplay(this, 123.0f, 5.0f);

    public PageSpeciesOverview(IWidget parent, DatabaseTab tab) {
        super(parent, tab);
        this.controlName = new ControlTextCentered((IWidget)this, 8.0f, "");
        this.controlScientific = new ControlTextCentered((IWidget)this, 32.0f, "");
        this.controlAuthority = new ControlTextCentered((IWidget)this, 44.0f, "");
        this.controlComplexity = new ControlTextCentered((IWidget)this, 56.0f, "");
        this.controlDescription = new ControlText(this, new IArea(8.0f, 84.0f, this.getSize().x() - 16.0f, 0.0f), "", TextJustification.MiddleCenter);
        this.controlSignature = new ControlText(this, new IArea(8.0f, 84.0f, this.getSize().x() - 16.0f, 0.0f), "", TextJustification.BottomRight);
    }

    @Override
    public void onValueChanged(IAlleleSpecies species) {
        this.controlInd1.setSpecies(species, EnumDiscoveryState.Show);
        this.controlInd2.setSpecies(species, EnumDiscoveryState.Show);
        String branchBinomial = species.getBranch() != null ? species.getBranch().getScientific() : "<Unknown>";
        String branchName = species.getBranch() != null ? species.getBranch().getName() : "Unknown";
        this.controlName.setValue("\u00a7n" + species.getName() + "\u00a7r");
        this.controlScientific.setValue("\u00a7o" + branchBinomial + " " + species.getBinomial() + "\u00a7r");
        this.controlAuthority.setValue("Discovered by \u00a7l" + species.getAuthority() + "\u00a7r");
        this.controlComplexity.setValue("Complexity: " + species.getComplexity());
        String desc = species.getDescription();
        String descBody = "\u00a7o";
        String descSig = "";
        if (desc == null || desc == "") {
            descBody = descBody + "No Description Provided.";
        } else {
            String[] descStrings = desc.split("\\|");
            descBody = descBody + descStrings[0];
            for (int i = 1; i < descStrings.length - 1; ++i) {
                descBody = descBody + " " + descStrings[i];
            }
            if (descStrings.length > 1) {
                descSig = descSig + descStrings[descStrings.length - 1];
            }
        }
        this.controlDescription.setValue(descBody + "\u00a7r");
        this.controlSignature.setValue(descSig + "\u00a7r");
        float descHeight = CraftGUI.Render.textHeight(this.controlDescription.getValue(), this.controlDescription.getSize().x());
        this.controlSignature.setPosition(new IPoint(this.controlSignature.pos().x(), this.controlDescription.getPosition().y() + descHeight + 10.0f));
    }
}

